/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services;

import com.google.ads.googleads.v22.services.CustomerAssetSetOperation;
import com.google.ads.googleads.v22.services.CustomerAssetSetServiceSettings;
import com.google.ads.googleads.v22.services.MutateCustomerAssetSetsRequest;
import com.google.ads.googleads.v22.services.MutateCustomerAssetSetsResponse;
import com.google.ads.googleads.v22.services.stub.CustomerAssetSetServiceStub;
import com.google.ads.googleads.v22.services.stub.CustomerAssetSetServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerAssetSetServiceClient
implements BackgroundResource {
    private final CustomerAssetSetServiceSettings settings;
    private final CustomerAssetSetServiceStub stub;

    public static final CustomerAssetSetServiceClient create() throws IOException {
        return CustomerAssetSetServiceClient.create(CustomerAssetSetServiceSettings.newBuilder().build());
    }

    public static final CustomerAssetSetServiceClient create(CustomerAssetSetServiceSettings settings) throws IOException {
        return new CustomerAssetSetServiceClient(settings);
    }

    public static final CustomerAssetSetServiceClient create(CustomerAssetSetServiceStub stub) {
        return new CustomerAssetSetServiceClient(stub);
    }

    protected CustomerAssetSetServiceClient(CustomerAssetSetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerAssetSetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomerAssetSetServiceClient(CustomerAssetSetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerAssetSetServiceSettings getSettings() {
        return this.settings;
    }

    public CustomerAssetSetServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomerAssetSetsResponse mutateCustomerAssetSets(String customerId, List<CustomerAssetSetOperation> operations) {
        MutateCustomerAssetSetsRequest request = MutateCustomerAssetSetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerAssetSets(request);
    }

    public final MutateCustomerAssetSetsResponse mutateCustomerAssetSets(MutateCustomerAssetSetsRequest request) {
        return (MutateCustomerAssetSetsResponse)this.mutateCustomerAssetSetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerAssetSetsRequest, MutateCustomerAssetSetsResponse> mutateCustomerAssetSetsCallable() {
        return this.stub.mutateCustomerAssetSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

