/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services;

import com.google.ads.googleads.v22.enums.DataLinkStatusEnum;
import com.google.ads.googleads.v22.resources.DataLink;
import com.google.ads.googleads.v22.resources.DataLinkName;
import com.google.ads.googleads.v22.services.CreateDataLinkRequest;
import com.google.ads.googleads.v22.services.CreateDataLinkResponse;
import com.google.ads.googleads.v22.services.DataLinkServiceSettings;
import com.google.ads.googleads.v22.services.RemoveDataLinkRequest;
import com.google.ads.googleads.v22.services.RemoveDataLinkResponse;
import com.google.ads.googleads.v22.services.UpdateDataLinkRequest;
import com.google.ads.googleads.v22.services.UpdateDataLinkResponse;
import com.google.ads.googleads.v22.services.stub.DataLinkServiceStub;
import com.google.ads.googleads.v22.services.stub.DataLinkServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DataLinkServiceClient
implements BackgroundResource {
    private final DataLinkServiceSettings settings;
    private final DataLinkServiceStub stub;

    public static final DataLinkServiceClient create() throws IOException {
        return DataLinkServiceClient.create(DataLinkServiceSettings.newBuilder().build());
    }

    public static final DataLinkServiceClient create(DataLinkServiceSettings settings) throws IOException {
        return new DataLinkServiceClient(settings);
    }

    public static final DataLinkServiceClient create(DataLinkServiceStub stub) {
        return new DataLinkServiceClient(stub);
    }

    protected DataLinkServiceClient(DataLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DataLinkServiceClient(DataLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataLinkServiceSettings getSettings() {
        return this.settings;
    }

    public DataLinkServiceStub getStub() {
        return this.stub;
    }

    public final CreateDataLinkResponse createDataLink(String customerId, DataLink dataLink) {
        CreateDataLinkRequest request = CreateDataLinkRequest.newBuilder().setCustomerId(customerId).setDataLink(dataLink).build();
        return this.createDataLink(request);
    }

    public final CreateDataLinkResponse createDataLink(CreateDataLinkRequest request) {
        return (CreateDataLinkResponse)this.createDataLinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataLinkRequest, CreateDataLinkResponse> createDataLinkCallable() {
        return this.stub.createDataLinkCallable();
    }

    public final RemoveDataLinkResponse removeDataLink(String customerId, DataLinkName resourceName) {
        RemoveDataLinkRequest request = RemoveDataLinkRequest.newBuilder().setCustomerId(customerId).setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.removeDataLink(request);
    }

    public final RemoveDataLinkResponse removeDataLink(String customerId, String resourceName) {
        RemoveDataLinkRequest request = RemoveDataLinkRequest.newBuilder().setCustomerId(customerId).setResourceName(resourceName).build();
        return this.removeDataLink(request);
    }

    public final RemoveDataLinkResponse removeDataLink(RemoveDataLinkRequest request) {
        return (RemoveDataLinkResponse)this.removeDataLinkCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveDataLinkRequest, RemoveDataLinkResponse> removeDataLinkCallable() {
        return this.stub.removeDataLinkCallable();
    }

    public final UpdateDataLinkResponse updateDataLink(String customerId, DataLinkStatusEnum.DataLinkStatus dataLinkStatus, DataLinkName resourceName) {
        UpdateDataLinkRequest request = UpdateDataLinkRequest.newBuilder().setCustomerId(customerId).setDataLinkStatus(dataLinkStatus).setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.updateDataLink(request);
    }

    public final UpdateDataLinkResponse updateDataLink(String customerId, DataLinkStatusEnum.DataLinkStatus dataLinkStatus, String resourceName) {
        UpdateDataLinkRequest request = UpdateDataLinkRequest.newBuilder().setCustomerId(customerId).setDataLinkStatus(dataLinkStatus).setResourceName(resourceName).build();
        return this.updateDataLink(request);
    }

    public final UpdateDataLinkResponse updateDataLink(UpdateDataLinkRequest request) {
        return (UpdateDataLinkResponse)this.updateDataLinkCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDataLinkRequest, UpdateDataLinkResponse> updateDataLinkCallable() {
        return this.stub.updateDataLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

