/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services;

import com.google.ads.googleads.v22.enums.AdvertisingChannelTypeEnum;
import com.google.ads.googleads.v22.enums.AssetFieldTypeEnum;
import com.google.ads.googleads.v22.services.AssetGenerationExistingContext;
import com.google.ads.googleads.v22.services.AssetGenerationExistingContextOrBuilder;
import com.google.ads.googleads.v22.services.AssetGenerationServiceProto;
import com.google.ads.googleads.v22.services.GenerateTextRequestOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GenerateTextRequest
extends GeneratedMessageV3
implements GenerateTextRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int contextCase_ = 0;
    private Object context_;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int ASSET_FIELD_TYPES_FIELD_NUMBER = 2;
    private List<Integer> assetFieldTypes_;
    private static final Internal.ListAdapter.Converter<Integer, AssetFieldTypeEnum.AssetFieldType> assetFieldTypes_converter_ = new Internal.ListAdapter.Converter<Integer, AssetFieldTypeEnum.AssetFieldType>(){

        public AssetFieldTypeEnum.AssetFieldType convert(Integer from) {
            AssetFieldTypeEnum.AssetFieldType result = AssetFieldTypeEnum.AssetFieldType.forNumber(from);
            return result == null ? AssetFieldTypeEnum.AssetFieldType.UNRECOGNIZED : result;
        }
    };
    private int assetFieldTypesMemoizedSerializedSize;
    public static final int FINAL_URL_FIELD_NUMBER = 5;
    private volatile Object finalUrl_ = "";
    public static final int FREEFORM_PROMPT_FIELD_NUMBER = 6;
    private volatile Object freeformPrompt_ = "";
    public static final int KEYWORDS_FIELD_NUMBER = 7;
    private LazyStringArrayList keywords_ = LazyStringArrayList.emptyList();
    public static final int EXISTING_GENERATION_CONTEXT_FIELD_NUMBER = 3;
    public static final int ADVERTISING_CHANNEL_TYPE_FIELD_NUMBER = 4;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GenerateTextRequest DEFAULT_INSTANCE = new GenerateTextRequest();
    private static final Parser<GenerateTextRequest> PARSER = new AbstractParser<GenerateTextRequest>(){

        public GenerateTextRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GenerateTextRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GenerateTextRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GenerateTextRequest() {
        this.customerId_ = "";
        this.assetFieldTypes_ = Collections.emptyList();
        this.finalUrl_ = "";
        this.freeformPrompt_ = "";
        this.keywords_ = LazyStringArrayList.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GenerateTextRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateTextRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateTextRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateTextRequest.class, Builder.class);
    }

    @Override
    public ContextCase getContextCase() {
        return ContextCase.forNumber(this.contextCase_);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AssetFieldTypeEnum.AssetFieldType> getAssetFieldTypesList() {
        return new Internal.ListAdapter(this.assetFieldTypes_, assetFieldTypes_converter_);
    }

    @Override
    public int getAssetFieldTypesCount() {
        return this.assetFieldTypes_.size();
    }

    @Override
    public AssetFieldTypeEnum.AssetFieldType getAssetFieldTypes(int index) {
        return (AssetFieldTypeEnum.AssetFieldType)((Object)assetFieldTypes_converter_.convert((Object)this.assetFieldTypes_.get(index)));
    }

    @Override
    public List<Integer> getAssetFieldTypesValueList() {
        return this.assetFieldTypes_;
    }

    @Override
    public int getAssetFieldTypesValue(int index) {
        return this.assetFieldTypes_.get(index);
    }

    @Override
    public String getFinalUrl() {
        Object ref = this.finalUrl_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.finalUrl_ = s;
        return s;
    }

    @Override
    public ByteString getFinalUrlBytes() {
        Object ref = this.finalUrl_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.finalUrl_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getFreeformPrompt() {
        Object ref = this.freeformPrompt_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.freeformPrompt_ = s;
        return s;
    }

    @Override
    public ByteString getFreeformPromptBytes() {
        Object ref = this.freeformPrompt_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.freeformPrompt_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getKeywordsList() {
        return this.keywords_;
    }

    @Override
    public int getKeywordsCount() {
        return this.keywords_.size();
    }

    @Override
    public String getKeywords(int index) {
        return this.keywords_.get(index);
    }

    @Override
    public ByteString getKeywordsBytes(int index) {
        return this.keywords_.getByteString(index);
    }

    @Override
    public boolean hasExistingGenerationContext() {
        return this.contextCase_ == 3;
    }

    @Override
    public AssetGenerationExistingContext getExistingGenerationContext() {
        if (this.contextCase_ == 3) {
            return (AssetGenerationExistingContext)this.context_;
        }
        return AssetGenerationExistingContext.getDefaultInstance();
    }

    @Override
    public AssetGenerationExistingContextOrBuilder getExistingGenerationContextOrBuilder() {
        if (this.contextCase_ == 3) {
            return (AssetGenerationExistingContext)this.context_;
        }
        return AssetGenerationExistingContext.getDefaultInstance();
    }

    @Override
    public boolean hasAdvertisingChannelType() {
        return this.contextCase_ == 4;
    }

    @Override
    public int getAdvertisingChannelTypeValue() {
        if (this.contextCase_ == 4) {
            return (Integer)this.context_;
        }
        return 0;
    }

    @Override
    public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelType() {
        if (this.contextCase_ == 4) {
            AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber((Integer)this.context_);
            return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
        }
        return AdvertisingChannelTypeEnum.AdvertisingChannelType.UNSPECIFIED;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        if (this.getAssetFieldTypesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.assetFieldTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.assetFieldTypes_.size(); ++i) {
            output.writeEnumNoTag(this.assetFieldTypes_.get(i).intValue());
        }
        if (this.contextCase_ == 3) {
            output.writeMessage(3, (MessageLite)((AssetGenerationExistingContext)this.context_));
        }
        if (this.contextCase_ == 4) {
            output.writeEnum(4, ((Integer)this.context_).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.finalUrl_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.finalUrl_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.freeformPrompt_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.freeformPrompt_);
        }
        for (i = 0; i < this.keywords_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.keywords_.getRaw(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        int dataSize = 0;
        for (i = 0; i < this.assetFieldTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.assetFieldTypes_.get(i));
        }
        size += dataSize;
        if (!this.getAssetFieldTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.assetFieldTypesMemoizedSerializedSize = dataSize;
        if (this.contextCase_ == 3) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((AssetGenerationExistingContext)this.context_));
        }
        if (this.contextCase_ == 4) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)((Integer)this.context_));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.finalUrl_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.finalUrl_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.freeformPrompt_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.freeformPrompt_);
        }
        dataSize = 0;
        for (i = 0; i < this.keywords_.size(); ++i) {
            dataSize += GenerateTextRequest.computeStringSizeNoTag((Object)this.keywords_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getKeywordsList().size();
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenerateTextRequest)) {
            return super.equals(obj);
        }
        GenerateTextRequest other = (GenerateTextRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (!this.assetFieldTypes_.equals(other.assetFieldTypes_)) {
            return false;
        }
        if (!this.getFinalUrl().equals(other.getFinalUrl())) {
            return false;
        }
        if (!this.getFreeformPrompt().equals(other.getFreeformPrompt())) {
            return false;
        }
        if (!this.getKeywordsList().equals(other.getKeywordsList())) {
            return false;
        }
        if (!this.getContextCase().equals((Object)other.getContextCase())) {
            return false;
        }
        switch (this.contextCase_) {
            case 3: {
                if (this.getExistingGenerationContext().equals(other.getExistingGenerationContext())) break;
                return false;
            }
            case 4: {
                if (this.getAdvertisingChannelTypeValue() == other.getAdvertisingChannelTypeValue()) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GenerateTextRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.getAssetFieldTypesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.assetFieldTypes_.hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getFinalUrl().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getFreeformPrompt().hashCode();
        if (this.getKeywordsCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getKeywordsList().hashCode();
        }
        switch (this.contextCase_) {
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getExistingGenerationContext().hashCode();
                break;
            }
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getAdvertisingChannelTypeValue();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GenerateTextRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GenerateTextRequest)PARSER.parseFrom(data);
    }

    public static GenerateTextRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateTextRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateTextRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GenerateTextRequest)PARSER.parseFrom(data);
    }

    public static GenerateTextRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateTextRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateTextRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GenerateTextRequest)PARSER.parseFrom(data);
    }

    public static GenerateTextRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateTextRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateTextRequest parseFrom(InputStream input) throws IOException {
        return (GenerateTextRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateTextRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateTextRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateTextRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GenerateTextRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateTextRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateTextRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateTextRequest parseFrom(CodedInputStream input) throws IOException {
        return (GenerateTextRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GenerateTextRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateTextRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GenerateTextRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GenerateTextRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GenerateTextRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GenerateTextRequest> parser() {
        return PARSER;
    }

    public Parser<GenerateTextRequest> getParserForType() {
        return PARSER;
    }

    public GenerateTextRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GenerateTextRequestOrBuilder {
        private int contextCase_ = 0;
        private Object context_;
        private int bitField0_;
        private Object customerId_ = "";
        private List<Integer> assetFieldTypes_ = Collections.emptyList();
        private Object finalUrl_ = "";
        private Object freeformPrompt_ = "";
        private LazyStringArrayList keywords_ = LazyStringArrayList.emptyList();
        private SingleFieldBuilderV3<AssetGenerationExistingContext, AssetGenerationExistingContext.Builder, AssetGenerationExistingContextOrBuilder> existingGenerationContextBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateTextRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateTextRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateTextRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            this.assetFieldTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.finalUrl_ = "";
            this.freeformPrompt_ = "";
            this.keywords_ = LazyStringArrayList.emptyList();
            if (this.existingGenerationContextBuilder_ != null) {
                this.existingGenerationContextBuilder_.clear();
            }
            this.contextCase_ = 0;
            this.context_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateTextRequest_descriptor;
        }

        public GenerateTextRequest getDefaultInstanceForType() {
            return GenerateTextRequest.getDefaultInstance();
        }

        public GenerateTextRequest build() {
            GenerateTextRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GenerateTextRequest buildPartial() {
            GenerateTextRequest result = new GenerateTextRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(GenerateTextRequest result) {
            if ((this.bitField0_ & 2) != 0) {
                this.assetFieldTypes_ = Collections.unmodifiableList(this.assetFieldTypes_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.assetFieldTypes_ = this.assetFieldTypes_;
        }

        private void buildPartial0(GenerateTextRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.finalUrl_ = this.finalUrl_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.freeformPrompt_ = this.freeformPrompt_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                this.keywords_.makeImmutable();
                result.keywords_ = this.keywords_;
            }
        }

        private void buildPartialOneofs(GenerateTextRequest result) {
            result.contextCase_ = this.contextCase_;
            result.context_ = this.context_;
            if (this.contextCase_ == 3 && this.existingGenerationContextBuilder_ != null) {
                result.context_ = this.existingGenerationContextBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GenerateTextRequest) {
                return this.mergeFrom((GenerateTextRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GenerateTextRequest other) {
            if (other == GenerateTextRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.assetFieldTypes_.isEmpty()) {
                if (this.assetFieldTypes_.isEmpty()) {
                    this.assetFieldTypes_ = other.assetFieldTypes_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureAssetFieldTypesIsMutable();
                    this.assetFieldTypes_.addAll(other.assetFieldTypes_);
                }
                this.onChanged();
            }
            if (!other.getFinalUrl().isEmpty()) {
                this.finalUrl_ = other.finalUrl_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getFreeformPrompt().isEmpty()) {
                this.freeformPrompt_ = other.freeformPrompt_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.keywords_.isEmpty()) {
                if (this.keywords_.isEmpty()) {
                    this.keywords_ = other.keywords_;
                    this.bitField0_ |= 0x10;
                } else {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.addAll((Collection)other.keywords_);
                }
                this.onChanged();
            }
            switch (other.getContextCase()) {
                case EXISTING_GENERATION_CONTEXT: {
                    this.mergeExistingGenerationContext(other.getExistingGenerationContext());
                    break;
                }
                case ADVERTISING_CHANNEL_TYPE: {
                    this.setAdvertisingChannelTypeValue(other.getAdvertisingChannelTypeValue());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block16: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block16;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block16;
                        }
                        case 16: {
                            int tmpRaw = input.readEnum();
                            this.ensureAssetFieldTypesIsMutable();
                            this.assetFieldTypes_.add(tmpRaw);
                            continue block16;
                        }
                        case 18: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureAssetFieldTypesIsMutable();
                                this.assetFieldTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block16;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getExistingGenerationContextFieldBuilder().getBuilder(), extensionRegistry);
                            this.contextCase_ = 3;
                            continue block16;
                        }
                        case 32: {
                            int rawValue = input.readEnum();
                            this.contextCase_ = 4;
                            this.context_ = rawValue;
                            continue block16;
                        }
                        case 42: {
                            this.finalUrl_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block16;
                        }
                        case 50: {
                            this.freeformPrompt_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block16;
                        }
                        case 58: {
                            String s = input.readStringRequireUtf8();
                            this.ensureKeywordsIsMutable();
                            this.keywords_.add((Object)s);
                            continue block16;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public ContextCase getContextCase() {
            return ContextCase.forNumber(this.contextCase_);
        }

        public Builder clearContext() {
            this.contextCase_ = 0;
            this.context_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = GenerateTextRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateTextRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureAssetFieldTypesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.assetFieldTypes_ = new ArrayList<Integer>(this.assetFieldTypes_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<AssetFieldTypeEnum.AssetFieldType> getAssetFieldTypesList() {
            return new Internal.ListAdapter(this.assetFieldTypes_, assetFieldTypes_converter_);
        }

        @Override
        public int getAssetFieldTypesCount() {
            return this.assetFieldTypes_.size();
        }

        @Override
        public AssetFieldTypeEnum.AssetFieldType getAssetFieldTypes(int index) {
            return (AssetFieldTypeEnum.AssetFieldType)((Object)assetFieldTypes_converter_.convert((Object)this.assetFieldTypes_.get(index)));
        }

        public Builder setAssetFieldTypes(int index, AssetFieldTypeEnum.AssetFieldType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAssetFieldTypesIsMutable();
            this.assetFieldTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAssetFieldTypes(AssetFieldTypeEnum.AssetFieldType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAssetFieldTypesIsMutable();
            this.assetFieldTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAssetFieldTypes(Iterable<? extends AssetFieldTypeEnum.AssetFieldType> values) {
            this.ensureAssetFieldTypesIsMutable();
            for (AssetFieldTypeEnum.AssetFieldType assetFieldType : values) {
                this.assetFieldTypes_.add(assetFieldType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAssetFieldTypes() {
            this.assetFieldTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAssetFieldTypesValueList() {
            return Collections.unmodifiableList(this.assetFieldTypes_);
        }

        @Override
        public int getAssetFieldTypesValue(int index) {
            return this.assetFieldTypes_.get(index);
        }

        public Builder setAssetFieldTypesValue(int index, int value) {
            this.ensureAssetFieldTypesIsMutable();
            this.assetFieldTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAssetFieldTypesValue(int value) {
            this.ensureAssetFieldTypesIsMutable();
            this.assetFieldTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAssetFieldTypesValue(Iterable<Integer> values) {
            this.ensureAssetFieldTypesIsMutable();
            for (int value : values) {
                this.assetFieldTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public String getFinalUrl() {
            Object ref = this.finalUrl_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.finalUrl_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFinalUrlBytes() {
            Object ref = this.finalUrl_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.finalUrl_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFinalUrl(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.finalUrl_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearFinalUrl() {
            this.finalUrl_ = GenerateTextRequest.getDefaultInstance().getFinalUrl();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setFinalUrlBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateTextRequest.checkByteStringIsUtf8((ByteString)value);
            this.finalUrl_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getFreeformPrompt() {
            Object ref = this.freeformPrompt_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.freeformPrompt_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFreeformPromptBytes() {
            Object ref = this.freeformPrompt_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.freeformPrompt_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFreeformPrompt(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.freeformPrompt_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearFreeformPrompt() {
            this.freeformPrompt_ = GenerateTextRequest.getDefaultInstance().getFreeformPrompt();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setFreeformPromptBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateTextRequest.checkByteStringIsUtf8((ByteString)value);
            this.freeformPrompt_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        private void ensureKeywordsIsMutable() {
            if (!this.keywords_.isModifiable()) {
                this.keywords_ = new LazyStringArrayList((LazyStringList)this.keywords_);
            }
            this.bitField0_ |= 0x10;
        }

        public ProtocolStringList getKeywordsList() {
            this.keywords_.makeImmutable();
            return this.keywords_;
        }

        @Override
        public int getKeywordsCount() {
            return this.keywords_.size();
        }

        @Override
        public String getKeywords(int index) {
            return this.keywords_.get(index);
        }

        @Override
        public ByteString getKeywordsBytes(int index) {
            return this.keywords_.getByteString(index);
        }

        public Builder setKeywords(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureKeywordsIsMutable();
            this.keywords_.set(index, value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addKeywords(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureKeywordsIsMutable();
            this.keywords_.add((Object)value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addAllKeywords(Iterable<String> values) {
            this.ensureKeywordsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.keywords_);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearKeywords() {
            this.keywords_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder addKeywordsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateTextRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureKeywordsIsMutable();
            this.keywords_.add(value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasExistingGenerationContext() {
            return this.contextCase_ == 3;
        }

        @Override
        public AssetGenerationExistingContext getExistingGenerationContext() {
            if (this.existingGenerationContextBuilder_ == null) {
                if (this.contextCase_ == 3) {
                    return (AssetGenerationExistingContext)this.context_;
                }
                return AssetGenerationExistingContext.getDefaultInstance();
            }
            if (this.contextCase_ == 3) {
                return (AssetGenerationExistingContext)this.existingGenerationContextBuilder_.getMessage();
            }
            return AssetGenerationExistingContext.getDefaultInstance();
        }

        public Builder setExistingGenerationContext(AssetGenerationExistingContext value) {
            if (this.existingGenerationContextBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.context_ = value;
                this.onChanged();
            } else {
                this.existingGenerationContextBuilder_.setMessage((AbstractMessage)value);
            }
            this.contextCase_ = 3;
            return this;
        }

        public Builder setExistingGenerationContext(AssetGenerationExistingContext.Builder builderForValue) {
            if (this.existingGenerationContextBuilder_ == null) {
                this.context_ = builderForValue.build();
                this.onChanged();
            } else {
                this.existingGenerationContextBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.contextCase_ = 3;
            return this;
        }

        public Builder mergeExistingGenerationContext(AssetGenerationExistingContext value) {
            if (this.existingGenerationContextBuilder_ == null) {
                this.context_ = this.contextCase_ == 3 && this.context_ != AssetGenerationExistingContext.getDefaultInstance() ? AssetGenerationExistingContext.newBuilder((AssetGenerationExistingContext)this.context_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.contextCase_ == 3) {
                this.existingGenerationContextBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.existingGenerationContextBuilder_.setMessage((AbstractMessage)value);
            }
            this.contextCase_ = 3;
            return this;
        }

        public Builder clearExistingGenerationContext() {
            if (this.existingGenerationContextBuilder_ == null) {
                if (this.contextCase_ == 3) {
                    this.contextCase_ = 0;
                    this.context_ = null;
                    this.onChanged();
                }
            } else {
                if (this.contextCase_ == 3) {
                    this.contextCase_ = 0;
                    this.context_ = null;
                }
                this.existingGenerationContextBuilder_.clear();
            }
            return this;
        }

        public AssetGenerationExistingContext.Builder getExistingGenerationContextBuilder() {
            return (AssetGenerationExistingContext.Builder)this.getExistingGenerationContextFieldBuilder().getBuilder();
        }

        @Override
        public AssetGenerationExistingContextOrBuilder getExistingGenerationContextOrBuilder() {
            if (this.contextCase_ == 3 && this.existingGenerationContextBuilder_ != null) {
                return (AssetGenerationExistingContextOrBuilder)this.existingGenerationContextBuilder_.getMessageOrBuilder();
            }
            if (this.contextCase_ == 3) {
                return (AssetGenerationExistingContext)this.context_;
            }
            return AssetGenerationExistingContext.getDefaultInstance();
        }

        private SingleFieldBuilderV3<AssetGenerationExistingContext, AssetGenerationExistingContext.Builder, AssetGenerationExistingContextOrBuilder> getExistingGenerationContextFieldBuilder() {
            if (this.existingGenerationContextBuilder_ == null) {
                if (this.contextCase_ != 3) {
                    this.context_ = AssetGenerationExistingContext.getDefaultInstance();
                }
                this.existingGenerationContextBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((AssetGenerationExistingContext)this.context_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.context_ = null;
            }
            this.contextCase_ = 3;
            this.onChanged();
            return this.existingGenerationContextBuilder_;
        }

        @Override
        public boolean hasAdvertisingChannelType() {
            return this.contextCase_ == 4;
        }

        @Override
        public int getAdvertisingChannelTypeValue() {
            if (this.contextCase_ == 4) {
                return (Integer)this.context_;
            }
            return 0;
        }

        public Builder setAdvertisingChannelTypeValue(int value) {
            this.contextCase_ = 4;
            this.context_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelType() {
            if (this.contextCase_ == 4) {
                AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber((Integer)this.context_);
                return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
            }
            return AdvertisingChannelTypeEnum.AdvertisingChannelType.UNSPECIFIED;
        }

        public Builder setAdvertisingChannelType(AdvertisingChannelTypeEnum.AdvertisingChannelType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.contextCase_ = 4;
            this.context_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAdvertisingChannelType() {
            if (this.contextCase_ == 4) {
                this.contextCase_ = 0;
                this.context_ = null;
                this.onChanged();
            }
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ContextCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        EXISTING_GENERATION_CONTEXT(3),
        ADVERTISING_CHANNEL_TYPE(4),
        CONTEXT_NOT_SET(0);

        private final int value;

        private ContextCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static ContextCase valueOf(int value) {
            return ContextCase.forNumber(value);
        }

        public static ContextCase forNumber(int value) {
            switch (value) {
                case 3: {
                    return EXISTING_GENERATION_CONTEXT;
                }
                case 4: {
                    return ADVERTISING_CHANNEL_TYPE;
                }
                case 0: {
                    return CONTEXT_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

