// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.GoogleAdsAllVersions;
import com.google.ads.googleads.v19.services.AccountBudgetProposalServiceClient;
import com.google.ads.googleads.v19.services.AccountBudgetProposalServiceSettings;
import com.google.ads.googleads.v19.services.AccountLinkServiceClient;
import com.google.ads.googleads.v19.services.AccountLinkServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupAdLabelServiceClient;
import com.google.ads.googleads.v19.services.AdGroupAdLabelServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupAdServiceClient;
import com.google.ads.googleads.v19.services.AdGroupAdServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupAssetServiceClient;
import com.google.ads.googleads.v19.services.AdGroupAssetServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupAssetSetServiceClient;
import com.google.ads.googleads.v19.services.AdGroupAssetSetServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupBidModifierServiceClient;
import com.google.ads.googleads.v19.services.AdGroupBidModifierServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupCriterionCustomizerServiceClient;
import com.google.ads.googleads.v19.services.AdGroupCriterionCustomizerServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupCriterionLabelServiceClient;
import com.google.ads.googleads.v19.services.AdGroupCriterionLabelServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupCriterionServiceClient;
import com.google.ads.googleads.v19.services.AdGroupCriterionServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupCustomizerServiceClient;
import com.google.ads.googleads.v19.services.AdGroupCustomizerServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupLabelServiceClient;
import com.google.ads.googleads.v19.services.AdGroupLabelServiceSettings;
import com.google.ads.googleads.v19.services.AdGroupServiceClient;
import com.google.ads.googleads.v19.services.AdGroupServiceSettings;
import com.google.ads.googleads.v19.services.AdParameterServiceClient;
import com.google.ads.googleads.v19.services.AdParameterServiceSettings;
import com.google.ads.googleads.v19.services.AdServiceClient;
import com.google.ads.googleads.v19.services.AdServiceSettings;
import com.google.ads.googleads.v19.services.AssetGroupAssetServiceClient;
import com.google.ads.googleads.v19.services.AssetGroupAssetServiceSettings;
import com.google.ads.googleads.v19.services.AssetGroupListingGroupFilterServiceClient;
import com.google.ads.googleads.v19.services.AssetGroupListingGroupFilterServiceSettings;
import com.google.ads.googleads.v19.services.AssetGroupServiceClient;
import com.google.ads.googleads.v19.services.AssetGroupServiceSettings;
import com.google.ads.googleads.v19.services.AssetGroupSignalServiceClient;
import com.google.ads.googleads.v19.services.AssetGroupSignalServiceSettings;
import com.google.ads.googleads.v19.services.AssetServiceClient;
import com.google.ads.googleads.v19.services.AssetServiceSettings;
import com.google.ads.googleads.v19.services.AssetSetAssetServiceClient;
import com.google.ads.googleads.v19.services.AssetSetAssetServiceSettings;
import com.google.ads.googleads.v19.services.AssetSetServiceClient;
import com.google.ads.googleads.v19.services.AssetSetServiceSettings;
import com.google.ads.googleads.v19.services.AudienceInsightsServiceClient;
import com.google.ads.googleads.v19.services.AudienceInsightsServiceSettings;
import com.google.ads.googleads.v19.services.AudienceServiceClient;
import com.google.ads.googleads.v19.services.AudienceServiceSettings;
import com.google.ads.googleads.v19.services.BatchJobServiceClient;
import com.google.ads.googleads.v19.services.BatchJobServiceSettings;
import com.google.ads.googleads.v19.services.BiddingDataExclusionServiceClient;
import com.google.ads.googleads.v19.services.BiddingDataExclusionServiceSettings;
import com.google.ads.googleads.v19.services.BiddingSeasonalityAdjustmentServiceClient;
import com.google.ads.googleads.v19.services.BiddingSeasonalityAdjustmentServiceSettings;
import com.google.ads.googleads.v19.services.BiddingStrategyServiceClient;
import com.google.ads.googleads.v19.services.BiddingStrategyServiceSettings;
import com.google.ads.googleads.v19.services.BillingSetupServiceClient;
import com.google.ads.googleads.v19.services.BillingSetupServiceSettings;
import com.google.ads.googleads.v19.services.BrandSuggestionServiceClient;
import com.google.ads.googleads.v19.services.BrandSuggestionServiceSettings;
import com.google.ads.googleads.v19.services.CampaignAssetServiceClient;
import com.google.ads.googleads.v19.services.CampaignAssetServiceSettings;
import com.google.ads.googleads.v19.services.CampaignAssetSetServiceClient;
import com.google.ads.googleads.v19.services.CampaignAssetSetServiceSettings;
import com.google.ads.googleads.v19.services.CampaignBidModifierServiceClient;
import com.google.ads.googleads.v19.services.CampaignBidModifierServiceSettings;
import com.google.ads.googleads.v19.services.CampaignBudgetServiceClient;
import com.google.ads.googleads.v19.services.CampaignBudgetServiceSettings;
import com.google.ads.googleads.v19.services.CampaignConversionGoalServiceClient;
import com.google.ads.googleads.v19.services.CampaignConversionGoalServiceSettings;
import com.google.ads.googleads.v19.services.CampaignCriterionServiceClient;
import com.google.ads.googleads.v19.services.CampaignCriterionServiceSettings;
import com.google.ads.googleads.v19.services.CampaignCustomizerServiceClient;
import com.google.ads.googleads.v19.services.CampaignCustomizerServiceSettings;
import com.google.ads.googleads.v19.services.CampaignDraftServiceClient;
import com.google.ads.googleads.v19.services.CampaignDraftServiceSettings;
import com.google.ads.googleads.v19.services.CampaignGroupServiceClient;
import com.google.ads.googleads.v19.services.CampaignGroupServiceSettings;
import com.google.ads.googleads.v19.services.CampaignLabelServiceClient;
import com.google.ads.googleads.v19.services.CampaignLabelServiceSettings;
import com.google.ads.googleads.v19.services.CampaignLifecycleGoalServiceClient;
import com.google.ads.googleads.v19.services.CampaignLifecycleGoalServiceSettings;
import com.google.ads.googleads.v19.services.CampaignServiceClient;
import com.google.ads.googleads.v19.services.CampaignServiceSettings;
import com.google.ads.googleads.v19.services.CampaignSharedSetServiceClient;
import com.google.ads.googleads.v19.services.CampaignSharedSetServiceSettings;
import com.google.ads.googleads.v19.services.ContentCreatorInsightsServiceClient;
import com.google.ads.googleads.v19.services.ContentCreatorInsightsServiceSettings;
import com.google.ads.googleads.v19.services.ConversionActionServiceClient;
import com.google.ads.googleads.v19.services.ConversionActionServiceSettings;
import com.google.ads.googleads.v19.services.ConversionAdjustmentUploadServiceClient;
import com.google.ads.googleads.v19.services.ConversionAdjustmentUploadServiceSettings;
import com.google.ads.googleads.v19.services.ConversionCustomVariableServiceClient;
import com.google.ads.googleads.v19.services.ConversionCustomVariableServiceSettings;
import com.google.ads.googleads.v19.services.ConversionGoalCampaignConfigServiceClient;
import com.google.ads.googleads.v19.services.ConversionGoalCampaignConfigServiceSettings;
import com.google.ads.googleads.v19.services.ConversionUploadServiceClient;
import com.google.ads.googleads.v19.services.ConversionUploadServiceSettings;
import com.google.ads.googleads.v19.services.ConversionValueRuleServiceClient;
import com.google.ads.googleads.v19.services.ConversionValueRuleServiceSettings;
import com.google.ads.googleads.v19.services.ConversionValueRuleSetServiceClient;
import com.google.ads.googleads.v19.services.ConversionValueRuleSetServiceSettings;
import com.google.ads.googleads.v19.services.CustomAudienceServiceClient;
import com.google.ads.googleads.v19.services.CustomAudienceServiceSettings;
import com.google.ads.googleads.v19.services.CustomConversionGoalServiceClient;
import com.google.ads.googleads.v19.services.CustomConversionGoalServiceSettings;
import com.google.ads.googleads.v19.services.CustomInterestServiceClient;
import com.google.ads.googleads.v19.services.CustomInterestServiceSettings;
import com.google.ads.googleads.v19.services.CustomerAssetServiceClient;
import com.google.ads.googleads.v19.services.CustomerAssetServiceSettings;
import com.google.ads.googleads.v19.services.CustomerAssetSetServiceClient;
import com.google.ads.googleads.v19.services.CustomerAssetSetServiceSettings;
import com.google.ads.googleads.v19.services.CustomerClientLinkServiceClient;
import com.google.ads.googleads.v19.services.CustomerClientLinkServiceSettings;
import com.google.ads.googleads.v19.services.CustomerConversionGoalServiceClient;
import com.google.ads.googleads.v19.services.CustomerConversionGoalServiceSettings;
import com.google.ads.googleads.v19.services.CustomerCustomizerServiceClient;
import com.google.ads.googleads.v19.services.CustomerCustomizerServiceSettings;
import com.google.ads.googleads.v19.services.CustomerLabelServiceClient;
import com.google.ads.googleads.v19.services.CustomerLabelServiceSettings;
import com.google.ads.googleads.v19.services.CustomerLifecycleGoalServiceClient;
import com.google.ads.googleads.v19.services.CustomerLifecycleGoalServiceSettings;
import com.google.ads.googleads.v19.services.CustomerManagerLinkServiceClient;
import com.google.ads.googleads.v19.services.CustomerManagerLinkServiceSettings;
import com.google.ads.googleads.v19.services.CustomerNegativeCriterionServiceClient;
import com.google.ads.googleads.v19.services.CustomerNegativeCriterionServiceSettings;
import com.google.ads.googleads.v19.services.CustomerServiceClient;
import com.google.ads.googleads.v19.services.CustomerServiceSettings;
import com.google.ads.googleads.v19.services.CustomerSkAdNetworkConversionValueSchemaServiceClient;
import com.google.ads.googleads.v19.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings;
import com.google.ads.googleads.v19.services.CustomerUserAccessInvitationServiceClient;
import com.google.ads.googleads.v19.services.CustomerUserAccessInvitationServiceSettings;
import com.google.ads.googleads.v19.services.CustomerUserAccessServiceClient;
import com.google.ads.googleads.v19.services.CustomerUserAccessServiceSettings;
import com.google.ads.googleads.v19.services.CustomizerAttributeServiceClient;
import com.google.ads.googleads.v19.services.CustomizerAttributeServiceSettings;
import com.google.ads.googleads.v19.services.DataLinkServiceClient;
import com.google.ads.googleads.v19.services.DataLinkServiceSettings;
import com.google.ads.googleads.v19.services.ExperimentArmServiceClient;
import com.google.ads.googleads.v19.services.ExperimentArmServiceSettings;
import com.google.ads.googleads.v19.services.ExperimentServiceClient;
import com.google.ads.googleads.v19.services.ExperimentServiceSettings;
import com.google.ads.googleads.v19.services.GeoTargetConstantServiceClient;
import com.google.ads.googleads.v19.services.GeoTargetConstantServiceSettings;
import com.google.ads.googleads.v19.services.GoogleAdsFieldServiceClient;
import com.google.ads.googleads.v19.services.GoogleAdsFieldServiceSettings;
import com.google.ads.googleads.v19.services.GoogleAdsServiceClient;
import com.google.ads.googleads.v19.services.GoogleAdsServiceSettings;
import com.google.ads.googleads.v19.services.GoogleAdsVersion;
import com.google.ads.googleads.v19.services.IdentityVerificationServiceClient;
import com.google.ads.googleads.v19.services.IdentityVerificationServiceSettings;
import com.google.ads.googleads.v19.services.InvoiceServiceClient;
import com.google.ads.googleads.v19.services.InvoiceServiceSettings;
import com.google.ads.googleads.v19.services.KeywordPlanAdGroupKeywordServiceClient;
import com.google.ads.googleads.v19.services.KeywordPlanAdGroupKeywordServiceSettings;
import com.google.ads.googleads.v19.services.KeywordPlanAdGroupServiceClient;
import com.google.ads.googleads.v19.services.KeywordPlanAdGroupServiceSettings;
import com.google.ads.googleads.v19.services.KeywordPlanCampaignKeywordServiceClient;
import com.google.ads.googleads.v19.services.KeywordPlanCampaignKeywordServiceSettings;
import com.google.ads.googleads.v19.services.KeywordPlanCampaignServiceClient;
import com.google.ads.googleads.v19.services.KeywordPlanCampaignServiceSettings;
import com.google.ads.googleads.v19.services.KeywordPlanIdeaServiceClient;
import com.google.ads.googleads.v19.services.KeywordPlanIdeaServiceSettings;
import com.google.ads.googleads.v19.services.KeywordPlanServiceClient;
import com.google.ads.googleads.v19.services.KeywordPlanServiceSettings;
import com.google.ads.googleads.v19.services.KeywordThemeConstantServiceClient;
import com.google.ads.googleads.v19.services.KeywordThemeConstantServiceSettings;
import com.google.ads.googleads.v19.services.LabelServiceClient;
import com.google.ads.googleads.v19.services.LabelServiceSettings;
import com.google.ads.googleads.v19.services.LocalServicesLeadServiceClient;
import com.google.ads.googleads.v19.services.LocalServicesLeadServiceSettings;
import com.google.ads.googleads.v19.services.OfflineUserDataJobServiceClient;
import com.google.ads.googleads.v19.services.OfflineUserDataJobServiceSettings;
import com.google.ads.googleads.v19.services.PaymentsAccountServiceClient;
import com.google.ads.googleads.v19.services.PaymentsAccountServiceSettings;
import com.google.ads.googleads.v19.services.ProductLinkInvitationServiceClient;
import com.google.ads.googleads.v19.services.ProductLinkInvitationServiceSettings;
import com.google.ads.googleads.v19.services.ProductLinkServiceClient;
import com.google.ads.googleads.v19.services.ProductLinkServiceSettings;
import com.google.ads.googleads.v19.services.ReachPlanServiceClient;
import com.google.ads.googleads.v19.services.ReachPlanServiceSettings;
import com.google.ads.googleads.v19.services.RecommendationServiceClient;
import com.google.ads.googleads.v19.services.RecommendationServiceSettings;
import com.google.ads.googleads.v19.services.RecommendationSubscriptionServiceClient;
import com.google.ads.googleads.v19.services.RecommendationSubscriptionServiceSettings;
import com.google.ads.googleads.v19.services.RemarketingActionServiceClient;
import com.google.ads.googleads.v19.services.RemarketingActionServiceSettings;
import com.google.ads.googleads.v19.services.ShareablePreviewServiceClient;
import com.google.ads.googleads.v19.services.ShareablePreviewServiceSettings;
import com.google.ads.googleads.v19.services.SharedCriterionServiceClient;
import com.google.ads.googleads.v19.services.SharedCriterionServiceSettings;
import com.google.ads.googleads.v19.services.SharedSetServiceClient;
import com.google.ads.googleads.v19.services.SharedSetServiceSettings;
import com.google.ads.googleads.v19.services.SmartCampaignSettingServiceClient;
import com.google.ads.googleads.v19.services.SmartCampaignSettingServiceSettings;
import com.google.ads.googleads.v19.services.SmartCampaignSuggestServiceClient;
import com.google.ads.googleads.v19.services.SmartCampaignSuggestServiceSettings;
import com.google.ads.googleads.v19.services.ThirdPartyAppAnalyticsLinkServiceClient;
import com.google.ads.googleads.v19.services.ThirdPartyAppAnalyticsLinkServiceSettings;
import com.google.ads.googleads.v19.services.TravelAssetSuggestionServiceClient;
import com.google.ads.googleads.v19.services.TravelAssetSuggestionServiceSettings;
import com.google.ads.googleads.v19.services.UserDataServiceClient;
import com.google.ads.googleads.v19.services.UserDataServiceSettings;
import com.google.ads.googleads.v19.services.UserListCustomerTypeServiceClient;
import com.google.ads.googleads.v19.services.UserListCustomerTypeServiceSettings;
import com.google.ads.googleads.v19.services.UserListServiceClient;
import com.google.ads.googleads.v19.services.UserListServiceSettings;
import com.google.ads.googleads.v21.services.AutomaticallyCreatedAssetRemovalServiceClient;
import com.google.ads.googleads.v21.services.AutomaticallyCreatedAssetRemovalServiceSettings;
import com.google.ads.googleads.v22.services.AssetGenerationServiceClient;
import com.google.ads.googleads.v22.services.AssetGenerationServiceSettings;
import com.google.ads.googleads.v22.services.CampaignGoalConfigServiceClient;
import com.google.ads.googleads.v22.services.CampaignGoalConfigServiceSettings;
import com.google.ads.googleads.v22.services.GoalServiceClient;
import com.google.ads.googleads.v22.services.GoalServiceSettings;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.SortedSet;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class GeneratedCatalog implements ApiCatalog {
  private static GeneratedCatalog instance;

  static {
    try {
      instance = new GeneratedCatalog(VersionFactory.getVersions());
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InstantiationException e) {
      throw new RuntimeException(e);
    }
  }

  private final ImmutableSortedSet<Version> supportedVersions;

  /**
   * Creates a new constant catalog from a known collection of versions. */
  public GeneratedCatalog(ImmutableSet<Version> versions) {
    supportedVersions = ImmutableSortedSet.copyOf(versions);
  }

  public static GeneratedCatalog getDefault() {
    return instance;
  }

  public SortedSet<Version> getSupportedVersions() {
    return supportedVersions;
  }

  public Version getLatestVersion() {
    return getSupportedVersions().first();
  }

  public GoogleAdsAllVersions createAllVersionsClient(TransportChannelProvider provider,
      Credentials credentials) {
    return new GoogleAdsAllVersions() {
      @Override
      public GoogleAdsVersion getVersion19() {
        return new V19Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v20.services.GoogleAdsVersion getVersion20() {
        return new V20Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v21.services.GoogleAdsVersion getVersion21() {
        return new V21Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v22.services.GoogleAdsVersion getVersion22() {
        return new V22Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v22.services.GoogleAdsVersion getLatestVersion() {
        return getVersion22();
      }
    };
  }

  private static class V19Client implements GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V19Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient() {
      try {
        AccountBudgetProposalServiceSettings settings =
          AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AccountLinkServiceClient createAccountLinkServiceClient() {
      try {
        AccountLinkServiceSettings settings =
          AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient() {
      try {
        AdGroupAdLabelServiceSettings settings =
          AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdServiceClient createAdGroupAdServiceClient() {
      try {
        AdGroupAdServiceSettings settings =
          AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAssetServiceClient createAdGroupAssetServiceClient() {
      try {
        AdGroupAssetServiceSettings settings =
          AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient() {
      try {
        AdGroupAssetSetServiceSettings settings =
          AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient() {
      try {
        AdGroupBidModifierServiceSettings settings =
          AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient() {
      try {
        AdGroupCriterionCustomizerServiceSettings settings =
          AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient() {
      try {
        AdGroupCriterionLabelServiceSettings settings =
          AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionServiceClient createAdGroupCriterionServiceClient() {
      try {
        AdGroupCriterionServiceSettings settings =
          AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient() {
      try {
        AdGroupCustomizerServiceSettings settings =
          AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupLabelServiceClient createAdGroupLabelServiceClient() {
      try {
        AdGroupLabelServiceSettings settings =
          AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupServiceClient createAdGroupServiceClient() {
      try {
        AdGroupServiceSettings settings =
          AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdParameterServiceClient createAdParameterServiceClient() {
      try {
        AdParameterServiceSettings settings =
          AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdServiceClient createAdServiceClient() {
      try {
        AdServiceSettings settings =
          AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupAssetServiceClient createAssetGroupAssetServiceClient() {
      try {
        AssetGroupAssetServiceSettings settings =
          AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        AssetGroupListingGroupFilterServiceSettings settings =
          AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupServiceClient createAssetGroupServiceClient() {
      try {
        AssetGroupServiceSettings settings =
          AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupSignalServiceClient createAssetGroupSignalServiceClient() {
      try {
        AssetGroupSignalServiceSettings settings =
          AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetServiceClient createAssetServiceClient() {
      try {
        AssetServiceSettings settings =
          AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetAssetServiceClient createAssetSetAssetServiceClient() {
      try {
        AssetSetAssetServiceSettings settings =
          AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetServiceClient createAssetSetServiceClient() {
      try {
        AssetSetServiceSettings settings =
          AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AudienceInsightsServiceClient createAudienceInsightsServiceClient() {
      try {
        AudienceInsightsServiceSettings settings =
          AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AudienceServiceClient createAudienceServiceClient() {
      try {
        AudienceServiceSettings settings =
          AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BatchJobServiceClient createBatchJobServiceClient() {
      try {
        BatchJobServiceSettings settings =
          BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient() {
      try {
        BiddingDataExclusionServiceSettings settings =
          BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        BiddingSeasonalityAdjustmentServiceSettings settings =
          BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingStrategyServiceClient createBiddingStrategyServiceClient() {
      try {
        BiddingStrategyServiceSettings settings =
          BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BillingSetupServiceClient createBillingSetupServiceClient() {
      try {
        BillingSetupServiceSettings settings =
          BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BrandSuggestionServiceClient createBrandSuggestionServiceClient() {
      try {
        BrandSuggestionServiceSettings settings =
          BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetServiceClient createCampaignAssetServiceClient() {
      try {
        CampaignAssetServiceSettings settings =
          CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetSetServiceClient createCampaignAssetSetServiceClient() {
      try {
        CampaignAssetSetServiceSettings settings =
          CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBidModifierServiceClient createCampaignBidModifierServiceClient() {
      try {
        CampaignBidModifierServiceSettings settings =
          CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBudgetServiceClient createCampaignBudgetServiceClient() {
      try {
        CampaignBudgetServiceSettings settings =
          CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient() {
      try {
        CampaignConversionGoalServiceSettings settings =
          CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCriterionServiceClient createCampaignCriterionServiceClient() {
      try {
        CampaignCriterionServiceSettings settings =
          CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCustomizerServiceClient createCampaignCustomizerServiceClient() {
      try {
        CampaignCustomizerServiceSettings settings =
          CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignDraftServiceClient createCampaignDraftServiceClient() {
      try {
        CampaignDraftServiceSettings settings =
          CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignGroupServiceClient createCampaignGroupServiceClient() {
      try {
        CampaignGroupServiceSettings settings =
          CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLabelServiceClient createCampaignLabelServiceClient() {
      try {
        CampaignLabelServiceSettings settings =
          CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient() {
      try {
        CampaignLifecycleGoalServiceSettings settings =
          CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignServiceClient createCampaignServiceClient() {
      try {
        CampaignServiceSettings settings =
          CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignSharedSetServiceClient createCampaignSharedSetServiceClient() {
      try {
        CampaignSharedSetServiceSettings settings =
          CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ContentCreatorInsightsServiceClient createContentCreatorInsightsServiceClient() {
      try {
        ContentCreatorInsightsServiceSettings settings =
          ContentCreatorInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ContentCreatorInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionActionServiceClient createConversionActionServiceClient() {
      try {
        ConversionActionServiceSettings settings =
          ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient() {
      try {
        ConversionAdjustmentUploadServiceSettings settings =
          ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient() {
      try {
        ConversionCustomVariableServiceSettings settings =
          ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        ConversionGoalCampaignConfigServiceSettings settings =
          ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionUploadServiceClient createConversionUploadServiceClient() {
      try {
        ConversionUploadServiceSettings settings =
          ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleServiceClient createConversionValueRuleServiceClient() {
      try {
        ConversionValueRuleServiceSettings settings =
          ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient() {
      try {
        ConversionValueRuleSetServiceSettings settings =
          ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomAudienceServiceClient createCustomAudienceServiceClient() {
      try {
        CustomAudienceServiceSettings settings =
          CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomConversionGoalServiceClient createCustomConversionGoalServiceClient() {
      try {
        CustomConversionGoalServiceSettings settings =
          CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomInterestServiceClient createCustomInterestServiceClient() {
      try {
        CustomInterestServiceSettings settings =
          CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerAssetServiceClient createCustomerAssetServiceClient() {
      try {
        CustomerAssetServiceSettings settings =
          CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerAssetSetServiceClient createCustomerAssetSetServiceClient() {
      try {
        CustomerAssetSetServiceSettings settings =
          CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerClientLinkServiceClient createCustomerClientLinkServiceClient() {
      try {
        CustomerClientLinkServiceSettings settings =
          CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient() {
      try {
        CustomerConversionGoalServiceSettings settings =
          CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerCustomizerServiceClient createCustomerCustomizerServiceClient() {
      try {
        CustomerCustomizerServiceSettings settings =
          CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLabelServiceClient createCustomerLabelServiceClient() {
      try {
        CustomerLabelServiceSettings settings =
          CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient() {
      try {
        CustomerLifecycleGoalServiceSettings settings =
          CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient() {
      try {
        CustomerManagerLinkServiceSettings settings =
          CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient() {
      try {
        CustomerNegativeCriterionServiceSettings settings =
          CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerServiceClient createCustomerServiceClient() {
      try {
        CustomerServiceSettings settings =
          CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        CustomerUserAccessInvitationServiceSettings settings =
          CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessServiceClient createCustomerUserAccessServiceClient() {
      try {
        CustomerUserAccessServiceSettings settings =
          CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomizerAttributeServiceClient createCustomizerAttributeServiceClient() {
      try {
        CustomizerAttributeServiceSettings settings =
          CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DataLinkServiceClient createDataLinkServiceClient() {
      try {
        DataLinkServiceSettings settings =
          DataLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DataLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExperimentArmServiceClient createExperimentArmServiceClient() {
      try {
        ExperimentArmServiceSettings settings =
          ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExperimentServiceClient createExperimentServiceClient() {
      try {
        ExperimentServiceSettings settings =
          ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GeoTargetConstantServiceClient createGeoTargetConstantServiceClient() {
      try {
        GeoTargetConstantServiceSettings settings =
          GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient() {
      try {
        GoogleAdsFieldServiceSettings settings =
          GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsServiceClient createGoogleAdsServiceClient() {
      try {
        GoogleAdsServiceSettings settings =
          GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public IdentityVerificationServiceClient createIdentityVerificationServiceClient() {
      try {
        IdentityVerificationServiceSettings settings =
          IdentityVerificationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return IdentityVerificationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public InvoiceServiceClient createInvoiceServiceClient() {
      try {
        InvoiceServiceSettings settings =
          InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient() {
      try {
        KeywordPlanAdGroupKeywordServiceSettings settings =
          KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient() {
      try {
        KeywordPlanAdGroupServiceSettings settings =
          KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient() {
      try {
        KeywordPlanCampaignKeywordServiceSettings settings =
          KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient() {
      try {
        KeywordPlanCampaignServiceSettings settings =
          KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient() {
      try {
        KeywordPlanIdeaServiceSettings settings =
          KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanServiceClient createKeywordPlanServiceClient() {
      try {
        KeywordPlanServiceSettings settings =
          KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient() {
      try {
        KeywordThemeConstantServiceSettings settings =
          KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LabelServiceClient createLabelServiceClient() {
      try {
        LabelServiceSettings settings =
          LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LocalServicesLeadServiceClient createLocalServicesLeadServiceClient() {
      try {
        LocalServicesLeadServiceSettings settings =
          LocalServicesLeadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LocalServicesLeadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient() {
      try {
        OfflineUserDataJobServiceSettings settings =
          OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public PaymentsAccountServiceClient createPaymentsAccountServiceClient() {
      try {
        PaymentsAccountServiceSettings settings =
          PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient() {
      try {
        ProductLinkInvitationServiceSettings settings =
          ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductLinkServiceClient createProductLinkServiceClient() {
      try {
        ProductLinkServiceSettings settings =
          ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ReachPlanServiceClient createReachPlanServiceClient() {
      try {
        ReachPlanServiceSettings settings =
          ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationServiceClient createRecommendationServiceClient() {
      try {
        RecommendationServiceSettings settings =
          RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient() {
      try {
        RecommendationSubscriptionServiceSettings settings =
          RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RemarketingActionServiceClient createRemarketingActionServiceClient() {
      try {
        RemarketingActionServiceSettings settings =
          RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ShareablePreviewServiceClient createShareablePreviewServiceClient() {
      try {
        ShareablePreviewServiceSettings settings =
          ShareablePreviewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ShareablePreviewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedCriterionServiceClient createSharedCriterionServiceClient() {
      try {
        SharedCriterionServiceSettings settings =
          SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedSetServiceClient createSharedSetServiceClient() {
      try {
        SharedSetServiceSettings settings =
          SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient() {
      try {
        SmartCampaignSettingServiceSettings settings =
          SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient() {
      try {
        SmartCampaignSuggestServiceSettings settings =
          SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient() {
      try {
        ThirdPartyAppAnalyticsLinkServiceSettings settings =
          ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient() {
      try {
        TravelAssetSuggestionServiceSettings settings =
          TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserDataServiceClient createUserDataServiceClient() {
      try {
        UserDataServiceSettings settings =
          UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserListCustomerTypeServiceClient createUserListCustomerTypeServiceClient() {
      try {
        UserListCustomerTypeServiceSettings settings =
          UserListCustomerTypeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserListCustomerTypeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserListServiceClient createUserListServiceClient() {
      try {
        UserListServiceSettings settings =
          UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V20Client implements com.google.ads.googleads.v20.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V20Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v20.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v20.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupAssetSetServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupCriterionCustomizerServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupCustomizerServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v20.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v20.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v20.services.AdServiceSettings settings =
          com.google.ads.googleads.v20.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetGroupAssetServiceClient createAssetGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetGroupAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetGroupListingGroupFilterServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetGroupServiceClient createAssetGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetGroupServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetGroupSignalServiceClient createAssetGroupSignalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetGroupSignalServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v20.services.AssetServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetSetAssetServiceClient createAssetSetAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetSetAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetSetServiceClient createAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetSetServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AudienceInsightsServiceClient createAudienceInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AudienceInsightsServiceSettings settings =
          com.google.ads.googleads.v20.services.AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AudienceServiceClient createAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AudienceServiceSettings settings =
          com.google.ads.googleads.v20.services.AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v20.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v20.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v20.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v20.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v20.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BrandSuggestionServiceClient createBrandSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BrandSuggestionServiceSettings settings =
          com.google.ads.googleads.v20.services.BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignAssetSetServiceClient createCampaignAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignAssetSetServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignConversionGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignCustomizerServiceClient createCampaignCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignCustomizerServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignGroupServiceClient createCampaignGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignGroupServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ContentCreatorInsightsServiceClient createContentCreatorInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ContentCreatorInsightsServiceSettings settings =
          com.google.ads.googleads.v20.services.ContentCreatorInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ContentCreatorInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionGoalCampaignConfigServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomConversionGoalServiceClient createCustomConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomConversionGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerAssetSetServiceClient createCustomerAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerAssetSetServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerConversionGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerCustomizerServiceClient createCustomerCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerCustomizerServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomizerAttributeServiceClient createCustomizerAttributeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomizerAttributeServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.DataLinkServiceClient createDataLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.DataLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.DataLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.DataLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ExperimentArmServiceClient createExperimentArmServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ExperimentArmServiceSettings settings =
          com.google.ads.googleads.v20.services.ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ExperimentServiceClient createExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ExperimentServiceSettings settings =
          com.google.ads.googleads.v20.services.ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v20.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v20.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v20.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.IdentityVerificationServiceClient createIdentityVerificationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.IdentityVerificationServiceSettings settings =
          com.google.ads.googleads.v20.services.IdentityVerificationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.IdentityVerificationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v20.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v20.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v20.services.LabelServiceSettings settings =
          com.google.ads.googleads.v20.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.LocalServicesLeadServiceClient createLocalServicesLeadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.LocalServicesLeadServiceSettings settings =
          com.google.ads.googleads.v20.services.LocalServicesLeadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.LocalServicesLeadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v20.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v20.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ProductLinkInvitationServiceSettings settings =
          com.google.ads.googleads.v20.services.ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ProductLinkServiceClient createProductLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ProductLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v20.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v20.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.RecommendationSubscriptionServiceSettings settings =
          com.google.ads.googleads.v20.services.RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v20.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ShareablePreviewServiceClient createShareablePreviewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ShareablePreviewServiceSettings settings =
          com.google.ads.googleads.v20.services.ShareablePreviewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ShareablePreviewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v20.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v20.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v20.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.TravelAssetSuggestionServiceSettings settings =
          com.google.ads.googleads.v20.services.TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v20.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.UserListCustomerTypeServiceClient createUserListCustomerTypeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.UserListCustomerTypeServiceSettings settings =
          com.google.ads.googleads.v20.services.UserListCustomerTypeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.UserListCustomerTypeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.UserListServiceSettings settings =
          com.google.ads.googleads.v20.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V21Client implements com.google.ads.googleads.v21.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V21Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v21.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v21.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v21.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupAssetSetServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupCriterionCustomizerServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupCustomizerServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v21.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v21.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v21.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v21.services.AdServiceSettings settings =
          com.google.ads.googleads.v21.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AssetGroupAssetServiceClient createAssetGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AssetGroupAssetServiceSettings settings =
          com.google.ads.googleads.v21.services.AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AssetGroupListingGroupFilterServiceSettings settings =
          com.google.ads.googleads.v21.services.AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AssetGroupServiceClient createAssetGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AssetGroupServiceSettings settings =
          com.google.ads.googleads.v21.services.AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AssetGroupSignalServiceClient createAssetGroupSignalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AssetGroupSignalServiceSettings settings =
          com.google.ads.googleads.v21.services.AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v21.services.AssetServiceSettings settings =
          com.google.ads.googleads.v21.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AssetSetAssetServiceClient createAssetSetAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AssetSetAssetServiceSettings settings =
          com.google.ads.googleads.v21.services.AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AssetSetServiceClient createAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AssetSetServiceSettings settings =
          com.google.ads.googleads.v21.services.AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AudienceInsightsServiceClient createAudienceInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AudienceInsightsServiceSettings settings =
          com.google.ads.googleads.v21.services.AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.AudienceServiceClient createAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.AudienceServiceSettings settings =
          com.google.ads.googleads.v21.services.AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v21.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v21.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v21.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v21.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v21.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.BrandSuggestionServiceClient createBrandSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.BrandSuggestionServiceSettings settings =
          com.google.ads.googleads.v21.services.BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignAssetSetServiceClient createCampaignAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignAssetSetServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignConversionGoalServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignCustomizerServiceClient createCampaignCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignCustomizerServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignGroupServiceClient createCampaignGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignGroupServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v21.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ContentCreatorInsightsServiceClient createContentCreatorInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ContentCreatorInsightsServiceSettings settings =
          com.google.ads.googleads.v21.services.ContentCreatorInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ContentCreatorInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v21.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v21.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v21.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ConversionGoalCampaignConfigServiceSettings settings =
          com.google.ads.googleads.v21.services.ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v21.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v21.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v21.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomConversionGoalServiceClient createCustomConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomConversionGoalServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerAssetSetServiceClient createCustomerAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerAssetSetServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerConversionGoalServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerCustomizerServiceClient createCustomerCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerCustomizerServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.CustomizerAttributeServiceClient createCustomizerAttributeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.CustomizerAttributeServiceSettings settings =
          com.google.ads.googleads.v21.services.CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.DataLinkServiceClient createDataLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.DataLinkServiceSettings settings =
          com.google.ads.googleads.v21.services.DataLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.DataLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ExperimentArmServiceClient createExperimentArmServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ExperimentArmServiceSettings settings =
          com.google.ads.googleads.v21.services.ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ExperimentServiceClient createExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ExperimentServiceSettings settings =
          com.google.ads.googleads.v21.services.ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v21.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v21.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v21.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.IdentityVerificationServiceClient createIdentityVerificationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.IdentityVerificationServiceSettings settings =
          com.google.ads.googleads.v21.services.IdentityVerificationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.IdentityVerificationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v21.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v21.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v21.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v21.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v21.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v21.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v21.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v21.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v21.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v21.services.LabelServiceSettings settings =
          com.google.ads.googleads.v21.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.LocalServicesLeadServiceClient createLocalServicesLeadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.LocalServicesLeadServiceSettings settings =
          com.google.ads.googleads.v21.services.LocalServicesLeadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.LocalServicesLeadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v21.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v21.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ProductLinkInvitationServiceSettings settings =
          com.google.ads.googleads.v21.services.ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ProductLinkServiceClient createProductLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ProductLinkServiceSettings settings =
          com.google.ads.googleads.v21.services.ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v21.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v21.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.RecommendationSubscriptionServiceSettings settings =
          com.google.ads.googleads.v21.services.RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v21.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ShareablePreviewServiceClient createShareablePreviewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ShareablePreviewServiceSettings settings =
          com.google.ads.googleads.v21.services.ShareablePreviewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ShareablePreviewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v21.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v21.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v21.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v21.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v21.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.TravelAssetSuggestionServiceSettings settings =
          com.google.ads.googleads.v21.services.TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v21.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.UserListCustomerTypeServiceClient createUserListCustomerTypeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.UserListCustomerTypeServiceSettings settings =
          com.google.ads.googleads.v21.services.UserListCustomerTypeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.UserListCustomerTypeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v21.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v21.services.UserListServiceSettings settings =
          com.google.ads.googleads.v21.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v21.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AutomaticallyCreatedAssetRemovalServiceClient createAutomaticallyCreatedAssetRemovalServiceClient(
        ) {
      try {
        AutomaticallyCreatedAssetRemovalServiceSettings settings =
          AutomaticallyCreatedAssetRemovalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AutomaticallyCreatedAssetRemovalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V22Client implements com.google.ads.googleads.v22.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V22Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public AssetGenerationServiceClient createAssetGenerationServiceClient() {
      try {
        AssetGenerationServiceSettings settings =
          AssetGenerationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGenerationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignGoalConfigServiceClient createCampaignGoalConfigServiceClient() {
      try {
        CampaignGoalConfigServiceSettings settings =
          CampaignGoalConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignGoalConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoalServiceClient createGoalServiceClient() {
      try {
        GoalServiceSettings settings =
          GoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v22.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v22.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupAssetSetServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupCriterionCustomizerServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupCustomizerServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v22.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v22.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v22.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v22.services.AdServiceSettings settings =
          com.google.ads.googleads.v22.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AssetGroupAssetServiceClient createAssetGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AssetGroupAssetServiceSettings settings =
          com.google.ads.googleads.v22.services.AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AssetGroupListingGroupFilterServiceSettings settings =
          com.google.ads.googleads.v22.services.AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AssetGroupServiceClient createAssetGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AssetGroupServiceSettings settings =
          com.google.ads.googleads.v22.services.AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AssetGroupSignalServiceClient createAssetGroupSignalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AssetGroupSignalServiceSettings settings =
          com.google.ads.googleads.v22.services.AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v22.services.AssetServiceSettings settings =
          com.google.ads.googleads.v22.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AssetSetAssetServiceClient createAssetSetAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AssetSetAssetServiceSettings settings =
          com.google.ads.googleads.v22.services.AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AssetSetServiceClient createAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AssetSetServiceSettings settings =
          com.google.ads.googleads.v22.services.AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AudienceInsightsServiceClient createAudienceInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AudienceInsightsServiceSettings settings =
          com.google.ads.googleads.v22.services.AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AudienceServiceClient createAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AudienceServiceSettings settings =
          com.google.ads.googleads.v22.services.AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v22.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v22.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v22.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v22.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v22.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.BrandSuggestionServiceClient createBrandSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.BrandSuggestionServiceSettings settings =
          com.google.ads.googleads.v22.services.BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignAssetSetServiceClient createCampaignAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignAssetSetServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignConversionGoalServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignCustomizerServiceClient createCampaignCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignCustomizerServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignGroupServiceClient createCampaignGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignGroupServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v22.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ContentCreatorInsightsServiceClient createContentCreatorInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ContentCreatorInsightsServiceSettings settings =
          com.google.ads.googleads.v22.services.ContentCreatorInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ContentCreatorInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v22.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v22.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v22.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ConversionGoalCampaignConfigServiceSettings settings =
          com.google.ads.googleads.v22.services.ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v22.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v22.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v22.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomConversionGoalServiceClient createCustomConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomConversionGoalServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerAssetSetServiceClient createCustomerAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerAssetSetServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerConversionGoalServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerCustomizerServiceClient createCustomerCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerCustomizerServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.CustomizerAttributeServiceClient createCustomizerAttributeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.CustomizerAttributeServiceSettings settings =
          com.google.ads.googleads.v22.services.CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.DataLinkServiceClient createDataLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.DataLinkServiceSettings settings =
          com.google.ads.googleads.v22.services.DataLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.DataLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ExperimentArmServiceClient createExperimentArmServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ExperimentArmServiceSettings settings =
          com.google.ads.googleads.v22.services.ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ExperimentServiceClient createExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ExperimentServiceSettings settings =
          com.google.ads.googleads.v22.services.ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v22.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v22.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v22.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.IdentityVerificationServiceClient createIdentityVerificationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.IdentityVerificationServiceSettings settings =
          com.google.ads.googleads.v22.services.IdentityVerificationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.IdentityVerificationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v22.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v22.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v22.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v22.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v22.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v22.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v22.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v22.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v22.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v22.services.LabelServiceSettings settings =
          com.google.ads.googleads.v22.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.LocalServicesLeadServiceClient createLocalServicesLeadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.LocalServicesLeadServiceSettings settings =
          com.google.ads.googleads.v22.services.LocalServicesLeadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.LocalServicesLeadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v22.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v22.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ProductLinkInvitationServiceSettings settings =
          com.google.ads.googleads.v22.services.ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ProductLinkServiceClient createProductLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ProductLinkServiceSettings settings =
          com.google.ads.googleads.v22.services.ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v22.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v22.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.RecommendationSubscriptionServiceSettings settings =
          com.google.ads.googleads.v22.services.RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v22.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ShareablePreviewServiceClient createShareablePreviewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ShareablePreviewServiceSettings settings =
          com.google.ads.googleads.v22.services.ShareablePreviewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ShareablePreviewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v22.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v22.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v22.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v22.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v22.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.TravelAssetSuggestionServiceSettings settings =
          com.google.ads.googleads.v22.services.TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v22.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.UserListCustomerTypeServiceClient createUserListCustomerTypeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.UserListCustomerTypeServiceSettings settings =
          com.google.ads.googleads.v22.services.UserListCustomerTypeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.UserListCustomerTypeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.UserListServiceSettings settings =
          com.google.ads.googleads.v22.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v22.services.AutomaticallyCreatedAssetRemovalServiceClient createAutomaticallyCreatedAssetRemovalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v22.services.AutomaticallyCreatedAssetRemovalServiceSettings settings =
          com.google.ads.googleads.v22.services.AutomaticallyCreatedAssetRemovalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v22.services.AutomaticallyCreatedAssetRemovalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
}
