/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzcgp;
import com.google.android.gms.internal.zzcgr;
import com.google.android.gms.internal.zzcgv;
import com.google.android.gms.internal.zzcgw;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchc;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzclk;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.internal.zzclp;
import com.google.android.gms.internal.zzclq;
import com.google.android.gms.internal.zzclr;
import com.google.android.gms.internal.zzcls;
import com.google.android.gms.internal.zzclv;
import com.google.android.gms.internal.zzcmb;
import com.google.android.gms.internal.zzcmc;
import com.google.android.gms.internal.zzcme;
import com.google.android.gms.internal.zzcmf;
import com.google.android.gms.internal.zzfjj;
import com.google.android.gms.internal.zzfjk;
import com.google.android.gms.internal.zzfjm;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcgo
extends zzcjl {
    private static final String[] zziyp = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zziyq = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zziyr = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;"};
    private static final String[] zziys = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zziyt = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;"};
    private static final String[] zziyu = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzcgr zziyv;
    private final zzclk zziyw = new zzclk(this.zzws());

    zzcgo(zzcim zzcim2) {
        super(zzcim2);
        String string = "google_app_measurement.db";
        this.zziyv = new zzcgr(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzaxz() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzxf();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzxf();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzxf();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzawy().zzazd().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzve();
        try {
            return this.zziyv.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazf().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzcgw zzae(String string, String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        this.zzve();
        this.zzxf();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Boolean bl = null;
            if (!cursor.isNull(6)) {
                bl = cursor.getLong(6) == 1L;
            }
            zzcgw zzcgw2 = new zzcgw(string, string2, l, l2, l3, l4, l5, l6, bl);
            if (cursor.moveToNext()) {
                this.zzawy().zzazd().zzj("Got multiple records for event aggregates, expected one. appId", zzchm.zzjk(string));
            }
            zzcgw zzcgw3 = zzcgw2;
            return zzcgw3;
        }
    }

    @WorkerThread
    public final void zza(zzcgw zzcgw2) {
        zzbq.checkNotNull((Object)zzcgw2);
        this.zzve();
        this.zzxf();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcgw2.mAppId);
        contentValues.put("name", zzcgw2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzcgw2.zzizk));
        contentValues.put("current_bundle_count", Long.valueOf(zzcgw2.zzizl));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzcgw2.zzizm));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzcgw2.zzizn));
        contentValues.put("last_sampled_complex_event_id", zzcgw2.zzizo);
        contentValues.put("last_sampling_rate", zzcgw2.zzizp);
        Long l = null;
        if (zzcgw2.zzizq != null && zzcgw2.zzizq.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzawy().zzazd().zzj("Failed to insert/update event aggregates (got -1). appId", zzchm.zzjk(zzcgw2.mAppId));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing event aggregates. appId", zzchm.zzjk(zzcgw2.mAppId), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzaf(String string, String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        this.zzve();
        this.zzxf();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzawy().zzazj().zzj("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zzd("Error deleting user attribute. appId", zzchm.zzjk(string), this.zzawt().zzjj(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzclp zzclp2) {
        zzbq.checkNotNull((Object)zzclp2);
        this.zzve();
        this.zzxf();
        if (this.zzag(zzclp2.mAppId, zzclp2.mName) == null && (zzclq.zzjz(zzclp2.mName) ? this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzclp2.mAppId}) >= 25L : this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzclp2.mAppId, zzclp2.mOrigin}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzclp2.mAppId);
        contentValues.put("origin", zzclp2.mOrigin);
        contentValues.put("name", zzclp2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzclp2.zzjjm));
        zzcgo.zza(contentValues, "value", zzclp2.mValue);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzawy().zzazd().zzj("Failed to insert/update user property (got -1). appId", zzchm.zzjk(zzclp2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing user property. appId", zzchm.zzjk(zzclp2.mAppId), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzclp zzag(String string, String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        this.zzve();
        this.zzxf();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzclp zzclp2 = new zzclp(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzawy().zzazd().zzj("Got multiple records for user property, expected one. appId", zzchm.zzjk(string));
            }
            zzclp zzclp3 = zzclp2;
            return zzclp3;
        }
    }

    @WorkerThread
    public final List<zzclp> zzja(String string) {
        zzbq.zzgm((String)string);
        this.zzve();
        this.zzxf();
        ArrayList<zzclp> arrayList = new ArrayList<zzclp>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzclp> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzawy().zzazd().zzj("Read invalid user property value, ignoring it. appId", zzchm.zzjk(string));
                    continue;
                }
                zzclp zzclp2 = new zzclp(string, string2, (String)object, l, object2);
                arrayList.add(zzclp2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzclp> zzg(String string, String string2, String string3) {
        zzbq.zzgm((String)string);
        this.zzve();
        this.zzxf();
        ArrayList<zzclp> arrayList = new ArrayList<zzclp>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzclp> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzawy().zzazd().zzj("Read more than the max allowed user properties, ignoring excess", 1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzawy().zzazd().zzd("(2)Read invalid user property value, ignoring it", zzchm.zzjk(string), string2, string3);
                    continue;
                }
                zzclp zzclp2 = new zzclp(string, string2, (String)object, l, object2);
                arrayList.add(zzclp2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcgl zzcgl2) {
        zzbq.checkNotNull((Object)((Object)zzcgl2));
        this.zzve();
        this.zzxf();
        if (this.zzag(zzcgl2.packageName, zzcgl2.zziyg.name) == null && this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcgl2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcgl2.packageName);
        contentValues.put("origin", zzcgl2.zziyf);
        contentValues.put("name", zzcgl2.zziyg.name);
        zzcgo.zza(contentValues, "value", zzcgl2.zziyg.getValue());
        contentValues.put("active", Boolean.valueOf(zzcgl2.zziyi));
        contentValues.put("trigger_event_name", zzcgl2.zziyj);
        contentValues.put("trigger_timeout", Long.valueOf(zzcgl2.zziyl));
        this.zzawu();
        contentValues.put("timed_out_event", zzclq.zza((Parcelable)zzcgl2.zziyk));
        contentValues.put("creation_timestamp", Long.valueOf(zzcgl2.zziyh));
        this.zzawu();
        contentValues.put("triggered_event", zzclq.zza((Parcelable)zzcgl2.zziym));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcgl2.zziyg.zzjji));
        contentValues.put("time_to_live", Long.valueOf(zzcgl2.zziyn));
        this.zzawu();
        contentValues.put("expired_event", zzclq.zza((Parcelable)zzcgl2.zziyo));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzawy().zzazd().zzj("Failed to insert/update conditional user property (got -1)", zzchm.zzjk(zzcgl2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing conditional user property", zzchm.zzjk(zzcgl2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcgl zzah(String string, String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        this.zzve();
        this.zzxf();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcha zzcha2 = this.zzawu().zzb(cursor.getBlob(5), zzcha.CREATOR);
            long l2 = cursor.getLong(6);
            zzcha zzcha3 = this.zzawu().zzb(cursor.getBlob(7), zzcha.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcha zzcha4 = this.zzawu().zzb(cursor.getBlob(10), zzcha.CREATOR);
            zzcln zzcln2 = new zzcln(string2, l3, object, string3);
            zzcgl zzcgl2 = new zzcgl(string, string3, zzcln2, l2, bl, string4, zzcha2, l, zzcha3, l4, zzcha4);
            if (cursor.moveToNext()) {
                this.zzawy().zzazd().zze("Got multiple records for conditional property, expected one", zzchm.zzjk(string), this.zzawt().zzjj(string2));
            }
            zzcgl zzcgl3 = zzcgl2;
            return zzcgl3;
        }
    }

    @WorkerThread
    public final int zzai(String string, String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        this.zzve();
        this.zzxf();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zzd("Error deleting conditional property", zzchm.zzjk(string), this.zzawt().zzjj(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcgl> zzh(String string, String string2, String string3) {
        zzbq.zzgm((String)string);
        this.zzve();
        this.zzxf();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzc(stringBuilder.toString(), stringArray);
    }

    public final List<zzcgl> zzc(String string, String[] stringArray) {
        this.zzve();
        this.zzxf();
        ArrayList<zzcgl> arrayList = new ArrayList<zzcgl>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcgl> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzawy().zzazd().zzj("Read more than the max allowed conditional properties, ignoring extra", 1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcha zzcha2 = this.zzawu().zzb(cursor.getBlob(7), zzcha.CREATOR);
                long l2 = cursor.getLong(8);
                zzcha zzcha3 = this.zzawu().zzb(cursor.getBlob(9), zzcha.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcha zzcha4 = this.zzawu().zzb(cursor.getBlob(12), zzcha.CREATOR);
                zzcln zzcln2 = new zzcln(string3, l3, object2, string2);
                zzcgl zzcgl2 = new zzcgl((String)object, string2, zzcln2, l2, bl, string4, zzcha2, l, zzcha3, l4, zzcha4);
                arrayList.add(zzcgl2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzcgh zzjb(String string) {
        zzbq.zzgm((String)string);
        this.zzve();
        this.zzxf();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzcgh zzcgh2 = new zzcgh(this.zziwf, string);
            zzcgh2.zzir(cursor.getString(0));
            zzcgh2.zzis(cursor.getString(1));
            zzcgh2.zzit(cursor.getString(2));
            zzcgh2.zzaq(cursor.getLong(3));
            zzcgh2.zzal(cursor.getLong(4));
            zzcgh2.zzam(cursor.getLong(5));
            zzcgh2.setAppVersion(cursor.getString(6));
            zzcgh2.zziv(cursor.getString(7));
            zzcgh2.zzao(cursor.getLong(8));
            zzcgh2.zzap(cursor.getLong(9));
            zzcgh2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzcgh2.zzat(cursor.getLong(11));
            zzcgh2.zzau(cursor.getLong(12));
            zzcgh2.zzav(cursor.getLong(13));
            zzcgh2.zzaw(cursor.getLong(14));
            zzcgh2.zzar(cursor.getLong(15));
            zzcgh2.zzas(cursor.getLong(16));
            zzcgh2.zzan(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzcgh2.zziu(cursor.getString(18));
            zzcgh2.zzay(cursor.getLong(19));
            zzcgh2.zzax(cursor.getLong(20));
            zzcgh2.zziw(cursor.getString(21));
            zzcgh2.zzaz(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzcgh2.zzbl(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzcgh2.zzaxb();
            if (cursor.moveToNext()) {
                this.zzawy().zzazd().zzj("Got multiple records for app, expected one. appId", zzchm.zzjk(string));
            }
            zzcgh zzcgh3 = zzcgh2;
            return zzcgh3;
        }
    }

    @WorkerThread
    public final void zza(zzcgh zzcgh2) {
        zzbq.checkNotNull((Object)zzcgh2);
        this.zzve();
        this.zzxf();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcgh2.getAppId());
        contentValues.put("app_instance_id", zzcgh2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzcgh2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzcgh2.zzaxc());
        contentValues.put("last_bundle_index", Long.valueOf(zzcgh2.zzaxl()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzcgh2.zzaxe()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzcgh2.zzaxf()));
        contentValues.put("app_version", zzcgh2.zzvj());
        contentValues.put("app_store", zzcgh2.zzaxh());
        contentValues.put("gmp_version", Long.valueOf(zzcgh2.zzaxi()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzcgh2.zzaxj()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzcgh2.zzaxk()));
        contentValues.put("day", Long.valueOf(zzcgh2.zzaxp()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzcgh2.zzaxq()));
        contentValues.put("daily_events_count", Long.valueOf(zzcgh2.zzaxr()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzcgh2.zzaxs()));
        contentValues.put("config_fetched_time", Long.valueOf(zzcgh2.zzaxm()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzcgh2.zzaxn()));
        contentValues.put("app_version_int", Long.valueOf(zzcgh2.zzaxg()));
        contentValues.put("firebase_instance_id", zzcgh2.zzaxd());
        contentValues.put("daily_error_events_count", Long.valueOf(zzcgh2.zzaxu()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzcgh2.zzaxt()));
        contentValues.put("health_monitor_sample", zzcgh2.zzaxv());
        contentValues.put("android_id", Long.valueOf(zzcgh2.zzaxx()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzcgh2.zzaxy()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzcgh2.getAppId()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzawy().zzazd().zzj("Failed to insert/update app (got -1). appId", zzchm.zzjk(zzcgh2.getAppId()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing app. appId", zzchm.zzjk(zzcgh2.getAppId()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzjc(String string) {
        zzbq.zzgm((String)string);
        this.zzve();
        this.zzxf();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzaxa().zzb(string2, zzchc.zzjas);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error deleting over the limit events. appId", zzchm.zzjk(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzcgp zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbq.zzgm((String)string);
        this.zzve();
        this.zzxf();
        String[] stringArray = new String[]{string};
        zzcgp zzcgp2 = new zzcgp();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzawy().zzazf().zzj("Not updating daily counts, app is not known. appId", zzchm.zzjk(string));
                zzcgp zzcgp3 = zzcgp2;
                return zzcgp3;
            }
            if (cursor.getLong(0) == l) {
                zzcgp2.zziyy = cursor.getLong(1);
                zzcgp2.zziyx = cursor.getLong(2);
                zzcgp2.zziyz = cursor.getLong(3);
                zzcgp2.zziza = cursor.getLong(4);
                zzcgp2.zzizb = cursor.getLong(5);
            }
            if (bl) {
                ++zzcgp2.zziyy;
            }
            if (bl2) {
                ++zzcgp2.zziyx;
            }
            if (bl3) {
                ++zzcgp2.zziyz;
            }
            if (bl4) {
                ++zzcgp2.zziza;
            }
            if (bl5) {
                ++zzcgp2.zzizb;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzcgp2.zziyx));
            contentValues.put("daily_events_count", Long.valueOf(zzcgp2.zziyy));
            contentValues.put("daily_conversions_count", Long.valueOf(zzcgp2.zziyz));
            contentValues.put("daily_error_events_count", Long.valueOf(zzcgp2.zziza));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzcgp2.zzizb));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzcgp zzcgp4 = zzcgp2;
            return zzcgp4;
        }
    }

    @WorkerThread
    public final byte[] zzjd(String string) {
        zzbq.zzgm((String)string);
        this.zzve();
        this.zzxf();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzawy().zzazd().zzj("Got multiple records for app config, expected one. appId", zzchm.zzjk(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzcme zzcme2, boolean bl) {
        byte[] byArray;
        this.zzve();
        this.zzxf();
        zzbq.checkNotNull((Object)((Object)zzcme2));
        zzbq.zzgm((String)zzcme2.zzcn);
        zzbq.checkNotNull((Object)zzcme2.zzjlt);
        this.zzayh();
        long l = this.zzws().currentTimeMillis();
        if (zzcme2.zzjlt < l - zzcgn.zzayb() || zzcme2.zzjlt > l + zzcgn.zzayb()) {
            this.zzawy().zzazf().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzchm.zzjk(zzcme2.zzcn), l, zzcme2.zzjlt);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzcme2.zzho()];
            zzfjk zzfjk2 = zzfjk.zzo((byte[])byArray2, (int)0, (int)byArray3.length);
            zzcme2.zza(zzfjk2);
            zzfjk2.zzcwt();
            byArray = this.zzawu().zzq(byArray2);
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zze("Data loss. Failed to serialize bundle. appId", zzchm.zzjk(zzcme2.zzcn), iOException);
            return false;
        }
        this.zzawy().zzazj().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcme2.zzcn);
        contentValues.put("bundle_end_timestamp", zzcme2.zzjlt);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzawy().zzazd().zzj("Failed to insert bundle (got -1). appId", zzchm.zzjk(zzcme2.zzcn));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing bundle. appId", zzchm.zzjk(zzcme2.zzcn), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzayf() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzayg() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzcme, Long>> zzl(String string, int n, int n2) {
        this.zzve();
        this.zzxf();
        zzbq.checkArgument((n > 0 ? 1 : 0) != 0);
        zzbq.checkArgument((n2 > 0 ? 1 : 0) != 0);
        zzbq.zzgm((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzcme, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzcme, Long>> arrayList = new ArrayList<Pair<zzcme, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzawu().zzr((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzawy().zzazd().zze("Failed to unzip queued bundle. appId", zzchm.zzjk(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzfjj.zzn((byte[])byArray, (int)0, (int)byArray2.length);
                zzcme zzcme2 = new zzcme();
                try {
                    zzcme2.zza((zzfjj)object);
                }
                catch (IOException iOException) {
                    this.zzawy().zzazd().zze("Failed to merge queued bundle. appId", zzchm.zzjk(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzcme, Long>)Pair.create((Object)((Object)zzcme2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzcme, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzayh() {
        this.zzve();
        this.zzxf();
        if (!this.zzayn()) {
            return;
        }
        long l = this.zzawz().zzjcu.get();
        long l2 = this.zzws().elapsedRealtime();
        if (Math.abs(l2 - l) > zzchc.zzjbb.get()) {
            this.zzawz().zzjcu.set(l2);
            zzcgo zzcgo2 = this;
            zzcgo2.zzve();
            zzcgo2.zzxf();
            if (zzcgo2.zzayn()) {
                SQLiteDatabase sQLiteDatabase = zzcgo2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzcgo2.zzws().currentTimeMillis()), String.valueOf(zzcgn.zzayb())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcgo2.zzawy().zzazj().zzj("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzclr[] zzclrArray) {
        this.zzxf();
        this.zzve();
        zzbq.zzgm((String)string);
        zzbq.checkNotNull((Object)zzclrArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcgo zzcgo2 = this;
            zzcgo2.zzxf();
            zzcgo2.zzve();
            zzbq.zzgm((String)string2);
            Object object = zzcgo2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzclrArray;
            int n2 = zzclrArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzcls zzcls2;
                int n3;
                int n4;
                zzclr zzclr2 = object2[n];
                object = zzclr2;
                string2 = string;
                zzcgo2 = this;
                zzcgo2.zzxf();
                zzcgo2.zzve();
                zzbq.zzgm((String)string2);
                zzbq.checkNotNull((Object)object);
                zzbq.checkNotNull((Object)object.zzjju);
                zzbq.checkNotNull((Object)object.zzjjt);
                if (object.zzjjs == null) {
                    zzcgo2.zzawy().zzazf().zzj("Audience with no ID. appId", zzchm.zzjk(string2));
                    continue;
                }
                int n5 = object.zzjjs;
                zzfjm[] zzfjmArray = object.zzjju;
                int n6 = object.zzjju.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzfjmArray[n4].zzjjw != null) continue;
                    zzcgo2.zzawy().zzazf().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzchm.zzjk(string2), object.zzjjs);
                    continue block3;
                }
                zzfjmArray = object.zzjjt;
                n6 = object.zzjjt.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzfjmArray[n4].zzjjw != null) continue;
                    zzcgo2.zzawy().zzazf().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzchm.zzjk(string2), object.zzjjs);
                    continue block3;
                }
                boolean bl = true;
                zzfjm[] zzfjmArray2 = object.zzjju;
                n4 = object.zzjju.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzcls2 = zzfjmArray2[n3];
                    if (zzcgo2.zza(string2, n5, zzcls2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzfjmArray2 = object.zzjjt;
                    n4 = object.zzjjt.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzcls2 = zzfjmArray2[n3];
                        if (zzcgo2.zza(string2, n5, (zzclv)((Object)zzcls2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcgo zzcgo3 = zzcgo2;
                zzcgo3.zzxf();
                zzcgo3.zzve();
                zzbq.zzgm((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcgo3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzclr[] zzclrArray2 = zzclrArray;
            n = zzclrArray.length;
            for (int i = 0; i < n; ++i) {
                zzclr zzclr3 = zzclrArray2[i];
                object2.add(zzclr3.zzjjs);
            }
            this.zze(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcls zzcls2) {
        byte[] byArray;
        this.zzxf();
        this.zzve();
        zzbq.zzgm((String)string);
        zzbq.checkNotNull((Object)((Object)zzcls2));
        if (TextUtils.isEmpty((CharSequence)zzcls2.zzjjx)) {
            this.zzawy().zzazf().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzchm.zzjk(string), n, String.valueOf(zzcls2.zzjjw));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcls2.zzho()];
            zzfjk zzfjk2 = zzfjk.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzcls2.zza(zzfjk2);
            zzfjk2.zzcwt();
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zze("Configuration loss. Failed to serialize event filter. appId", zzchm.zzjk(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcls2.zzjjw);
        contentValues.put("event_name", zzcls2.zzjjx);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzawy().zzazd().zzj("Failed to insert event filter (got -1). appId", zzchm.zzjk(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing event filter. appId", zzchm.zzjk(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzclv zzclv2) {
        byte[] byArray;
        this.zzxf();
        this.zzve();
        zzbq.zzgm((String)string);
        zzbq.checkNotNull((Object)((Object)zzclv2));
        if (TextUtils.isEmpty((CharSequence)zzclv2.zzjkm)) {
            this.zzawy().zzazf().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzchm.zzjk(string), n, String.valueOf(zzclv2.zzjjw));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzclv2.zzho()];
            zzfjk zzfjk2 = zzfjk.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzclv2.zza(zzfjk2);
            zzfjk2.zzcwt();
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zze("Configuration loss. Failed to serialize property filter. appId", zzchm.zzjk(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzclv2.zzjjw);
        contentValues.put("property_name", zzclv2.zzjkm);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzawy().zzazd().zzj("Failed to insert property filter (got -1). appId", zzchm.zzjk(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing property filter. appId", zzchm.zzjk(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzcls>> zzaj(String string, String string2) {
        this.zzxf();
        this.zzve();
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcls>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzfjj zzfjj2 = zzfjj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                zzcls zzcls2 = new zzcls();
                try {
                    zzcls2.zza(zzfjj2);
                }
                catch (IOException iOException) {
                    this.zzawy().zzazd().zze("Failed to merge filter. appId", zzchm.zzjk(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcls> arrayList = (ArrayList<zzcls>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcls>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcls2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzclv>> zzak(String string, String string2) {
        this.zzxf();
        this.zzve();
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzclv>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzfjj zzfjj2 = zzfjj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                zzclv zzclv2 = new zzclv();
                try {
                    zzclv2.zza(zzfjj2);
                }
                catch (IOException iOException) {
                    this.zzawy().zzazd().zze("Failed to merge filter", zzchm.zzjk(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzclv> arrayList = (ArrayList<zzclv>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzclv>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzclv2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zze(String string, List<Integer> list) {
        Object object;
        long l;
        zzbq.zzgm((String)string);
        this.zzxf();
        this.zzve();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Database error querying filters. appId", zzchm.zzjk(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzaxa().zzb(string2, zzchc.zzjbi);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzcmf> zzje(String string) {
        this.zzxf();
        this.zzve();
        zzbq.zzgm((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzfjj zzfjj2 = zzfjj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                zzcmf zzcmf2 = new zzcmf();
                try {
                    zzcmf2.zza(zzfjj2);
                }
                catch (IOException iOException) {
                    this.zzawy().zzazd().zzd("Failed to merge filter results. appId, audienceId, error", zzchm.zzjk(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzcmf2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbq.zzgm((String)string);
        zzbq.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzawy().zzazd().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzawy().zzazd().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzawy().zzazd().zzj("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzayi() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzal(String string, String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        this.zzve();
        this.zzxf();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzawy().zzazd().zze("Failed to insert column (got -1). appId", zzchm.zzjk(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzawy().zzazd().zze("Failed to update column (got 0). appId", zzchm.zzjk(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zzd("Error inserting column. appId", zzchm.zzjk(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzayj() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzcme zzcme2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzve();
        this.zzxf();
        zzbq.checkNotNull((Object)((Object)zzcme2));
        zzbq.zzgm((String)zzcme2.zzcn);
        try {
            byArray = new byte[zzcme2.zzho()];
            object = byArray;
            zzfjk zzfjk2 = zzfjk.zzo((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzcme2.zza(zzfjk2);
            zzfjk2.zzcwt();
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zze("Data loss. Failed to serialize event metadata. appId", zzchm.zzjk(zzcme2.zzcn), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzawu();
        zzbq.checkNotNull((Object)byArray2);
        ((zzcjk)object).zzve();
        MessageDigest messageDigest = zzclq.zzek("MD5");
        if (messageDigest == null) {
            ((zzcjk)object).zzawy().zzazd().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzclq.zzs(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcme2.zzcn);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing raw event metadata. appId", zzchm.zzjk(zzcme2.zzcn), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzayk() {
        return this.zzb("select count(1) > 0 from raw_events", null) != 0L;
    }

    public final boolean zzayl() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", null) != 0L;
    }

    public final void zzah(List<Long> list) {
        zzbq.checkNotNull(list);
        this.zzve();
        this.zzxf();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzawy().zzazd().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzjf(String string) {
        zzbq.zzgm((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzba(long l) {
        this.zzve();
        this.zzxf();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzawy().zzazj().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzaym() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final boolean zza(zzcgv zzcgv2, long l, boolean bl) {
        Object object;
        zzcmc zzcmc2;
        String string2;
        this.zzve();
        this.zzxf();
        zzbq.checkNotNull((Object)zzcgv2);
        zzbq.zzgm((String)zzcgv2.mAppId);
        zzcmb zzcmb2 = new zzcmb();
        new zzcmb().zzjlj = zzcgv2.zzizi;
        zzcmb2.zzjlh = new zzcmc[zzcgv2.zzizj.size()];
        int n = 0;
        for (String string2 : zzcgv2.zzizj) {
            zzcmc2 = new zzcmc();
            zzcmb2.zzjlh[n++] = zzcmc2;
            zzcmc2.name = string2;
            Object object2 = zzcgv2.zzizj.get(string2);
            this.zzawu().zza(zzcmc2, object2);
        }
        try {
            byte[] byArray = new byte[zzcmb2.zzho()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzcmc2 = zzfjk.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzcmb2.zza((zzfjk)zzcmc2);
            zzcmc2.zzcwt();
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zze("Data loss. Failed to serialize event params/data. appId", zzchm.zzjk(zzcgv2.mAppId), iOException);
            return false;
        }
        this.zzawy().zzazj().zze("Saving event, name, data size", this.zzawt().zzjh(zzcgv2.mName), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzcgv2.mAppId);
        string2.put("name", zzcgv2.mName);
        string2.put("timestamp", Long.valueOf(zzcgv2.zzfij));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzawy().zzazd().zzj("Failed to insert raw event (got -1). appId", zzchm.zzjk(zzcgv2.mAppId));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzawy().zzazd().zze("Error storing raw event. appId", zzchm.zzjk(zzcgv2.mAppId), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzayn() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    @WorkerThread
    private static boolean zza(zzchm zzchm2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzchm2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzchm zzchm2, SQLiteDatabase sQLiteDatabase, String string, String string2, String[] stringArray) throws SQLiteException {
        if (zzchm2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcgo.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (set.remove(stringArray[i])) continue;
                sQLiteDatabase.execSQL(stringArray[i + 1]);
            }
        }
        if (!set.isEmpty()) {
            zzchm2.zzazf().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzchm zzchm2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, String[] stringArray) throws SQLiteException {
        if (zzchm2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcgo.zza(zzchm2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcgo.zza(zzchm2, sQLiteDatabase, string, string3, stringArray);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzchm2.zzazd().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzchm zzchm2, SQLiteDatabase sQLiteDatabase) {
        if (zzchm2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzchm2.zzazf().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzchm2.zzazf().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzchm2.zzazf().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzchm2.zzazf().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzclk zza(zzcgo zzcgo2) {
        return zzcgo2.zziyw;
    }

    static /* synthetic */ String[] zzayo() {
        return zziyp;
    }

    static /* synthetic */ String[] zzayp() {
        return zziyq;
    }

    static /* synthetic */ String[] zzayq() {
        return zziyr;
    }

    static /* synthetic */ String[] zzayr() {
        return zziyt;
    }

    static /* synthetic */ String[] zzays() {
        return zziys;
    }

    static /* synthetic */ String[] zzayt() {
        return zziyu;
    }
}

