/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.internal.zzbhd;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzchh
extends zzcjl {
    private String mAppId;
    private String zzdra;
    private int zzjbk;
    private String zzixc;
    private String zzdqz;
    private long zzjbl;
    private long zzixg;
    private int zzjbm;
    private String zzcwz;

    zzchh(zzcim zzcim2) {
        super(zzcim2);
    }

    @Override
    protected final boolean zzaxz() {
        return true;
    }

    @Override
    protected final void zzayy() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcjk)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcjk)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcjk)this).zzawy().zzazd().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzchm.zzjk(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcjk)this).zzawy().zzazd().zzj("Error retrieving app installer package name. appId", zzchm.zzjk(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcjk)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcjk)this).zzawy().zzazd().zze("Error retrieving package info. appId, appName", zzchm.zzjk(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zzixc = string;
        this.zzdra = string2;
        this.zzjbk = n;
        this.zzdqz = string3;
        this.zzjbl = 0L;
        packageInfo = zzbz.zzck((Context)((zzcjk)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzchh zzchh2 = this;
            if (packageInfo2 == null) {
                ((zzcjk)zzchh2).zzawy().zzazd().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzcjk)zzchh2).zzawy().zzazd().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcjk)this).zzaxa().zziy("firebase_analytics_collection_enabled");
            if (((zzcjk)this).zzaxa().zzaya()) {
                ((zzcjk)this).zzawy().zzazh().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzcjk)this).zzawy().zzazh().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzbz.zzaji()) {
                ((zzcjk)this).zzawy().zzazh().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcjk)this).zzawy().zzazj().log("Collection enabled");
            }
        }
        this.zzcwz = "";
        this.zzixg = 0L;
        try {
            object = zzbz.zzajh();
            Object object2 = this.zzcwz = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzcjk)this).zzawy().zzazj().zze("App package, google app id", this.mAppId, this.zzcwz);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcjk)this).zzawy().zzazd().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzchm.zzjk(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzjbm = zzbhd.zzcz((Context)((zzcjk)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzjbm = 0;
    }

    @WorkerThread
    final zzcgi zzjg(String string) {
        ((zzcjk)this).zzve();
        String string2 = this.getAppId();
        String string3 = this.getGmpAppId();
        zzchh zzchh2 = this;
        zzchh2.zzxf();
        String string4 = zzchh2.zzdra;
        long l = this.zzaza();
        zzchh2 = this;
        zzchh2.zzxf();
        String string5 = zzchh2.zzixc;
        zzchh2 = this;
        zzchh2.zzxf();
        ((zzcjk)zzchh2).zzve();
        if (zzchh2.zzjbl == 0L) {
            zzchh2.zzjbl = zzchh2.zziwf.zzawu().zzaf(((zzcjk)zzchh2).getContext(), ((zzcjk)zzchh2).getContext().getPackageName());
        }
        long l2 = zzchh2.zzjbl;
        boolean bl = this.zziwf.isEnabled();
        boolean bl2 = !((zzcjk)this).zzawz().zzjdj;
        String string6 = this.zzaxd();
        this.zzxf();
        Boolean bl3 = ((zzcjk)this).zzaxa().zziy("google_analytics_adid_collection_enabled");
        return new zzcgi(string2, string3, string4, l, string5, 11910L, l2, string, bl, bl2, string6, 0L, this.zziwf.zzbaf(), this.zzazb(), bl3 == null || bl3 != false);
    }

    @WorkerThread
    final String zzayz() {
        byte[] byArray = new byte[16];
        ((zzcjk)this).zzawu().zzbaz().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzaxd() {
        ((zzcjk)this).zzve();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcjk)this).zzawy().zzazf().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String getAppId() {
        this.zzxf();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzxf();
        return this.zzcwz;
    }

    final int zzaza() {
        this.zzxf();
        return this.zzjbk;
    }

    final int zzazb() {
        this.zzxf();
        return this.zzjbm;
    }
}

