/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.common.zzp;
import com.google.android.gms.common.zzq;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchf;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzciw;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciy;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcja;
import com.google.android.gms.internal.zzcjb;
import com.google.android.gms.internal.zzcjc;
import com.google.android.gms.internal.zzcjd;
import com.google.android.gms.internal.zzcje;
import com.google.android.gms.internal.zzcjf;
import com.google.android.gms.internal.zzcjg;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.internal.zzclp;
import com.google.android.gms.internal.zzclq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcir
extends zzchf {
    private final zzcim zziwf;
    private Boolean zzjgl;
    @Nullable
    private String zzjgm;

    public zzcir(zzcim zzcim2) {
        this(zzcim2, null);
    }

    private zzcir(zzcim zzcim2, @Nullable String string) {
        zzbq.checkNotNull((Object)zzcim2);
        this.zziwf = zzcim2;
        this.zzjgm = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzcgi zzcgi2) {
        this.zzb(zzcgi2, false);
        this.zziwf.zzawx().zzg(new zzcis(this, zzcgi2));
    }

    @Override
    @BinderThread
    public final void zza(zzcha zzcha2, zzcgi zzcgi2) {
        zzbq.checkNotNull((Object)((Object)zzcha2));
        this.zzb(zzcgi2, false);
        this.zziwf.zzawx().zzg(new zzcjc(this, zzcha2, zzcgi2));
    }

    @Override
    @BinderThread
    public final void zza(zzcha zzcha2, String string, String string2) {
        zzbq.checkNotNull((Object)((Object)zzcha2));
        zzbq.zzgm((String)string);
        this.zzf(string, true);
        this.zziwf.zzawx().zzg(new zzcjd(this, zzcha2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcha zzcha2, String string) {
        zzbq.zzgm((String)string);
        zzbq.checkNotNull((Object)((Object)zzcha2));
        this.zzf(string, true);
        this.zziwf.zzawy().zzazi().zzj("Log and bundle. event", this.zziwf.zzawt().zzjh(zzcha2.name));
        long l = this.zziwf.zzws().nanoTime() / 1000000L;
        Future<byte[]> future = this.zziwf.zzawx().zzd(new zzcje(this, zzcha2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zziwf.zzawy().zzazd().zzj("Log and bundle returned null. appId", zzchm.zzjk(string));
                byArray = new byte[]{};
            }
            long l2 = this.zziwf.zzws().nanoTime() / 1000000L;
            this.zziwf.zzawy().zzazi().zzd("Log and bundle processed. event, size, time_ms", this.zziwf.zzawt().zzjh(zzcha2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zziwf.zzawy().zzazd().zzd("Failed to log and bundle. appId, event, error", zzchm.zzjk(string), this.zziwf.zzawt().zzjh(zzcha2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcln zzcln2, zzcgi zzcgi2) {
        zzbq.checkNotNull((Object)((Object)zzcln2));
        this.zzb(zzcgi2, false);
        if (zzcln2.getValue() == null) {
            this.zziwf.zzawx().zzg(new zzcjf(this, zzcln2, zzcgi2));
            return;
        }
        this.zziwf.zzawx().zzg(new zzcjg(this, zzcln2, zzcgi2));
    }

    @Override
    @BinderThread
    public final List<zzcln> zza(zzcgi zzcgi2, boolean bl) {
        this.zzb(zzcgi2, false);
        Future<List<zzclp>> future = this.zziwf.zzawx().zzc(new zzcjh(this, zzcgi2));
        try {
            List<zzclp> list = future.get();
            ArrayList<zzcln> arrayList = new ArrayList<zzcln>(list.size());
            for (zzclp zzclp2 : list) {
                if (!bl && zzclq.zzki(zzclp2.mName)) continue;
                arrayList.add(new zzcln(zzclp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zziwf.zzawy().zzazd().zze("Failed to get user attributes. appId", zzchm.zzjk(zzcgi2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcgi zzcgi2) {
        this.zzb(zzcgi2, false);
        zzcji zzcji2 = new zzcji(this, zzcgi2);
        if (this.zziwf.zzawx().zzazs()) {
            zzcji2.run();
            return;
        }
        this.zziwf.zzawx().zzg(zzcji2);
    }

    @BinderThread
    private final void zzb(zzcgi zzcgi2, boolean bl) {
        zzbq.checkNotNull((Object)((Object)zzcgi2));
        this.zzf(zzcgi2.packageName, false);
        this.zziwf.zzawu().zzkg(zzcgi2.zzixs);
    }

    @BinderThread
    private final void zzf(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zziwf.zzawy().zzazd().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcir zzcir2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcir2 = this;
                    if (!bl2) break block9;
                    if (zzcir2.zzjgl == null) {
                        zzcir2.zzjgl = "com.google.android.gms".equals(zzcir2.zzjgm) || zzx.zzf((Context)zzcir2.zziwf.getContext(), (int)Binder.getCallingUid()) || zzq.zzci((Context)zzcir2.zziwf.getContext()).zzbq(Binder.getCallingUid());
                    }
                    if (zzcir2.zzjgl.booleanValue()) break block10;
                }
                if (zzcir2.zzjgm == null && zzp.zzb((Context)zzcir2.zziwf.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcir2.zzjgm = string2;
                }
                if (!string2.equals(zzcir2.zzjgm)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zziwf.zzawy().zzazd().zzj("Measurement Service called with invalid calling package. appId", zzchm.zzjk(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zziwf.zzawx().zzg(new zzcjj(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzcgi zzcgi2) {
        this.zzb(zzcgi2, false);
        return this.zziwf.zzjx(zzcgi2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcgl zzcgl2, zzcgi zzcgi2) {
        zzbq.checkNotNull((Object)((Object)zzcgl2));
        zzbq.checkNotNull((Object)((Object)zzcgl2.zziyg));
        this.zzb(zzcgi2, false);
        zzcgl zzcgl3 = new zzcgl(zzcgl2);
        new zzcgl(zzcgl2).packageName = zzcgi2.packageName;
        if (zzcgl2.zziyg.getValue() == null) {
            this.zziwf.zzawx().zzg(new zzcit(this, zzcgl3, zzcgi2));
            return;
        }
        this.zziwf.zzawx().zzg(new zzciu(this, zzcgl3, zzcgi2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcgl zzcgl2) {
        zzbq.checkNotNull((Object)((Object)zzcgl2));
        zzbq.checkNotNull((Object)((Object)zzcgl2.zziyg));
        this.zzf(zzcgl2.packageName, true);
        zzcgl zzcgl3 = new zzcgl(zzcgl2);
        if (zzcgl2.zziyg.getValue() == null) {
            this.zziwf.zzawx().zzg(new zzciv(this, zzcgl3));
            return;
        }
        this.zziwf.zzawx().zzg(new zzciw(this, zzcgl3));
    }

    @Override
    @BinderThread
    public final List<zzcln> zza(String string, String string2, boolean bl, zzcgi zzcgi2) {
        this.zzb(zzcgi2, false);
        Future<List<zzclp>> future = this.zziwf.zzawx().zzc(new zzcix(this, zzcgi2, string, string2));
        try {
            List<zzclp> list = future.get();
            ArrayList<zzcln> arrayList = new ArrayList<zzcln>(list.size());
            for (zzclp zzclp2 : list) {
                if (!bl && zzclq.zzki(zzclp2.mName)) continue;
                arrayList.add(new zzcln(zzclp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zziwf.zzawy().zzazd().zze("Failed to get user attributes. appId", zzchm.zzjk(zzcgi2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcln> zza(String string, String string2, String string3, boolean bl) {
        this.zzf(string, true);
        Future<List<zzclp>> future = this.zziwf.zzawx().zzc(new zzciy(this, string, string2, string3));
        try {
            List<zzclp> list = future.get();
            ArrayList<zzcln> arrayList = new ArrayList<zzcln>(list.size());
            for (zzclp zzclp2 : list) {
                if (!bl && zzclq.zzki(zzclp2.mName)) continue;
                arrayList.add(new zzcln(zzclp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zziwf.zzawy().zzazd().zze("Failed to get user attributes. appId", zzchm.zzjk(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcgl> zza(String string, String string2, zzcgi zzcgi2) {
        this.zzb(zzcgi2, false);
        Future<List<zzcgl>> future = this.zziwf.zzawx().zzc(new zzciz(this, zzcgi2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zziwf.zzawy().zzazd().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcgl> zzj(String string, String string2, String string3) {
        this.zzf(string, true);
        Future<List<zzcgl>> future = this.zziwf.zzawx().zzc(new zzcja(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zziwf.zzawy().zzazd().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final void zzd(zzcgi zzcgi2) {
        this.zzf(zzcgi2.packageName, false);
        this.zziwf.zzawx().zzg(new zzcjb(this, zzcgi2));
    }

    static /* synthetic */ zzcim zza(zzcir zzcir2) {
        return zzcir2.zziwf;
    }
}

