/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcgd;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzckd;
import com.google.android.gms.internal.zzcke;
import com.google.android.gms.internal.zzckf;
import com.google.android.gms.internal.zzclq;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzckc
extends zzcjl {
    protected zzckf zzjhn;
    private volatile AppMeasurement.zzb zzjho;
    private AppMeasurement.zzb zzjhp;
    private long zzjhq;
    private final Map<Activity, zzckf> zzjhr = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzjhs = new CopyOnWriteArrayList();
    private boolean zzjht;
    private AppMeasurement.zzb zzjhu;
    private String zzjhv;

    public zzckc(zzcim zzcim2) {
        super(zzcim2);
    }

    @Override
    protected final boolean zzaxz() {
        return false;
    }

    @WorkerThread
    public final zzckf zzbao() {
        this.zzxf();
        ((zzcjk)this).zzve();
        return this.zzjhn;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            ((zzcjk)this).zzawy().zzazf().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        ((zzcjk)this).zzawx();
        if (!zzcih.zzau()) {
            ((zzcjk)this).zzawy().zzazf().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzjht) {
            ((zzcjk)this).zzawy().zzazf().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzjho == null) {
            ((zzcjk)this).zzawy().zzazf().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzjhr.get(activity) == null) {
            ((zzcjk)this).zzawy().zzazf().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzckc.zzjy(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzjho.zziwl.equals(string2);
        boolean bl2 = zzclq.zzas(this.zzjho.zziwk, string);
        if (bl && bl2) {
            ((zzcjk)this).zzawy().zzazg().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzcjk)this).zzawy().zzazf().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzcjk)this).zzawy().zzazf().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcjk)this).zzawy().zzazj().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzckf zzckf2 = new zzckf(string, string2, ((zzcjk)this).zzawu().zzbay());
        this.zzjhr.put(activity, zzckf2);
        this.zza(activity, zzckf2, true);
    }

    public final AppMeasurement.zzb zzbap() {
        AppMeasurement.zzb zzb2 = this.zzjho;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        if (zza2 == null) {
            ((zzcjk)this).zzawy().zzazf().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzjhs.remove(zza2);
        this.zzjhs.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        this.zzjhs.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzckf zzckf2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzjho != null) {
            zzb2 = this.zzjho;
        } else if (this.zzjhp != null && Math.abs(((zzcjk)this).zzws().elapsedRealtime() - this.zzjhq) < 1000L) {
            zzb2 = this.zzjhp;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzjht = true;
        try {
            object2 = this.zzjhs.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzckf2);
                }
                catch (Exception exception) {
                    ((zzcjk)this).zzawy().zzazd().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzcjk)this).zzawy().zzazd().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzjht = false;
        }
        Object object3 = object2 = this.zzjho == null ? this.zzjhp : this.zzjho;
        if (bl2) {
            if (zzckf2.zziwl == null) {
                zzckf2.zziwl = zzckc.zzjy(activity.getClass().getCanonicalName());
            }
            object = new zzckf(zzckf2);
            this.zzjhp = this.zzjho;
            this.zzjhq = ((zzcjk)this).zzws().elapsedRealtime();
            this.zzjho = object;
            ((zzcjk)this).zzawx().zzg(new zzckd(this, bl, (AppMeasurement.zzb)object2, (zzckf)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzckf zzckf2) {
        ((zzcjk)this).zzawk().zzaj(((zzcjk)this).zzws().elapsedRealtime());
        if (((zzcjk)this).zzaww().zzbs(zzckf2.zzjib)) {
            zzckf2.zzjib = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zziwk != null) {
                bundle.putString("_sn", zzb2.zziwk);
            }
            bundle.putString("_sc", zzb2.zziwl);
            bundle.putLong("_si", zzb2.zziwm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        ((zzcjk)this).zzve();
        zzckc zzckc2 = this;
        synchronized (zzckc2) {
            if (this.zzjhv == null || this.zzjhv.equals(string) || zzb2 != null) {
                this.zzjhv = string;
                this.zzjhu = zzb2;
            }
            return;
        }
    }

    private static String zzjy(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzckf zzq(@NonNull Activity activity) {
        zzbq.checkNotNull((Object)activity);
        zzckf zzckf2 = this.zzjhr.get(activity);
        if (zzckf2 == null) {
            String string = zzckc.zzjy(activity.getClass().getCanonicalName());
            zzckf2 = new zzckf(null, string, ((zzcjk)this).zzawu().zzbay());
            this.zzjhr.put(activity, zzckf2);
        }
        return zzckf2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzckf zzckf2 = this.zzq(activity);
        this.zza(activity, zzckf2, false);
        zzcgd zzcgd2 = ((zzcjk)this).zzawk();
        long l = ((zzcjk)zzcgd2).zzws().elapsedRealtime();
        ((zzcjk)zzcgd2).zzawx().zzg(new zzcgg(zzcgd2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzckf zzckf2 = this.zzq(activity);
        this.zzjhp = this.zzjho;
        this.zzjhq = ((zzcjk)this).zzws().elapsedRealtime();
        this.zzjho = null;
        ((zzcjk)this).zzawx().zzg(new zzcke(this, zzckf2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzckf zzckf2 = this.zzjhr.get(activity);
        if (zzckf2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzckf2.zziwm);
        bundle2.putString("name", zzckf2.zziwk);
        bundle2.putString("referrer_name", zzckf2.zziwl);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzjhr.remove(activity);
    }

    static /* synthetic */ void zza(zzckc zzckc2, zzckf zzckf2) {
        zzckc2.zza(zzckf2);
    }
}

