/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.support.annotation.GuardedBy;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbr;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzq;

public final class zzas
extends zzcs {
    private char zzalu = '\u0000';
    private long zzade = -1L;
    @GuardedBy(value="this")
    private String zzalv;
    private final zzau zzalw = new zzau(this, 6, false, false);
    private final zzau zzalx = new zzau(this, 6, true, false);
    private final zzau zzaly = new zzau(this, 6, false, true);
    private final zzau zzalz = new zzau(this, 5, false, false);
    private final zzau zzama = new zzau(this, 5, true, false);
    private final zzau zzamb = new zzau(this, 5, false, true);
    private final zzau zzamc = new zzau(this, 4, false, false);
    private final zzau zzamd = new zzau(this, 3, false, false);
    private final zzau zzame = new zzau(this, 2, false, false);

    zzas(zzbw zzbw2) {
        super(zzbw2);
    }

    public final zzau zzjg() {
        return this.zzalw;
    }

    public final zzau zzjh() {
        return this.zzalx;
    }

    public final zzau zzji() {
        return this.zzaly;
    }

    public final zzau zzjj() {
        return this.zzalz;
    }

    public final zzau zzjk() {
        return this.zzama;
    }

    public final zzau zzjl() {
        return this.zzamb;
    }

    public final zzau zzjm() {
        return this.zzamc;
    }

    public final zzau zzjn() {
        return this.zzamd;
    }

    public final zzau zzjo() {
        return this.zzame;
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    protected static Object zzbw(String string) {
        if (string == null) {
            return null;
        }
        return new zzav(string);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && this.isLoggable(n)) {
            String string2 = zzas.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzas zzas2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzbr zzbr2 = zzas2.zzada.zzkl();
            if (zzbr2 == null) {
                zzas2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzbr2.isInitialized()) {
                zzas2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzbr2.zzc(new zzat(zzas2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final boolean isLoggable(int n) {
        return Log.isLoggable((String)this.zzjp(), (int)n);
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzjp(), (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final String zzjp() {
        zzas zzas2 = this;
        synchronized (zzas2) {
            if (this.zzalv == null) {
                this.zzalv = this.zzada.zzkq() != null ? this.zzada.zzkq() : zzq.zzhy();
            }
            return this.zzalv;
        }
    }

    static String zza(boolean bl, String string, Object object, Object object2, Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzas.zza(bl, object);
        String string3 = zzas.zza(bl, object2);
        String string4 = zzas.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length() - 1));
            long l2 = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            return new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string).length()).append(string).append(l).append("...").append(string).append(l2).toString();
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzas.zzbx(AppMeasurement.class.getCanonicalName());
            String string3 = zzas.zzbx(zzbw.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string4;
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !(string4 = zzas.zzbx(string5)).equals(string) && !string4.equals(string3)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzav) {
            return zzav.zza((zzav)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    private static String zzbx(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public final String zzjq() {
        Pair<String, Long> pair = ((zzcr)this).zzgu().zzanb.zzfm();
        if (pair == null || pair == zzbd.zzana) {
            return null;
        }
        String string = String.valueOf(pair.second);
        String string2 = (String)pair.first;
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }

    static /* synthetic */ char zza(zzas zzas2) {
        return zzas2.zzalu;
    }

    static /* synthetic */ char zza(zzas zzas2, char c) {
        zzas2.zzalu = c;
        return zzas2.zzalu;
    }

    static /* synthetic */ long zzb(zzas zzas2) {
        return zzas2.zzade;
    }

    static /* synthetic */ long zza(zzas zzas2, long l) {
        zzas2.zzade = l;
        return zzas2.zzade;
    }
}

