/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzbo;
import com.google.android.gms.measurement.internal.zzbp;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzn;

public final class zzbm {
    private final zzbp zzaog;

    public zzbm(zzbp zzbp2) {
        Preconditions.checkNotNull((Object)zzbp2);
        this.zzaog = zzbp2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzbw zzbw2 = zzbw.zza(context, null);
        zzas zzas2 = zzbw2.zzgt();
        if (intent == null) {
            zzas2.zzjj().zzby("Receiver called with null intent");
            return;
        }
        zzn zzn2 = zzbw2.zzgw();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzas2.zzjo().zzg("Device receiver got", string);
        } else {
            zzas2.zzjo().zzg("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzas2.zzjo().zzby("Starting wakeful intent.");
            this.zzaog.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzbw2.zzgs().zzc(new zzbn(this, zzbw2, zzas2));
            }
            catch (Exception exception) {
                zzas2.zzjj().zzg("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzaog.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzas2.zzjo().zzby("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzas2.zzjm().zzg("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzbw2.zzgr().zza(uri);
            if (bundle == null) {
                zzas2.zzjo().zzby("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzas2.zzjj().zzby("Install referrer is missing timestamp");
                }
                zzbw2.zzgs().zzc(new zzbo(this, zzbw2, l, bundle, context, zzas2, pendingResult));
            }
        }
    }
}

