/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzbv;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcs;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzbr
extends zzcs {
    private ExecutorService zzadl;
    private zzbv zzaot;
    private zzbv zzaou;
    private final PriorityBlockingQueue<zzbu<?>> zzaov;
    private final BlockingQueue<zzbu<?>> zzaow;
    private final Thread.UncaughtExceptionHandler zzaox;
    private final Thread.UncaughtExceptionHandler zzaoy;
    private final Object zzaoz = new Object();
    private final Semaphore zzapa = new Semaphore(2);
    private volatile boolean zzapb;
    private static final AtomicLong zzapc = new AtomicLong(Long.MIN_VALUE);

    zzbr(zzbw zzbw2) {
        super(zzbw2);
        this.zzaov = new PriorityBlockingQueue();
        this.zzaow = new LinkedBlockingQueue();
        this.zzaox = new zzbt(this, "Thread death: Uncaught exception on worker thread");
        this.zzaoy = new zzbt(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @Override
    public final void zzaf() {
        if (Thread.currentThread() != this.zzaot) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzgh() {
        if (Thread.currentThread() != this.zzaou) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzkf() {
        return Thread.currentThread() == this.zzaot;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull(callable);
        zzbu zzbu2 = new zzbu(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzaot) {
            if (!this.zzaov.isEmpty()) {
                ((zzcr)this).zzgt().zzjj().zzby("Callable skipped the worker queue.");
            }
            zzbu2.run();
        } else {
            this.zza(zzbu2);
        }
        return zzbu2;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull(callable);
        zzbu zzbu2 = new zzbu(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzaot) {
            zzbu2.run();
        } else {
            this.zza(zzbu2);
        }
        return zzbu2;
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzbu(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzcr)this).zzgs().zzc(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzcr)this).zzgt().zzjj().zzby(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzcr)this).zzgt().zzjj().zzby(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzbu<?> zzbu2) {
        Object object = this.zzaoz;
        synchronized (object) {
            this.zzaov.add(zzbu2);
            if (this.zzaot == null) {
                this.zzaot = new zzbv(this, "Measurement Worker", this.zzaov);
                this.zzaot.setUncaughtExceptionHandler(this.zzaox);
                this.zzaot.start();
            } else {
                this.zzaot.zzki();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd(Runnable runnable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull((Object)runnable);
        zzbu zzbu2 = new zzbu(this, runnable, false, "Task exception on network thread");
        zzbr zzbr2 = this;
        Object object = zzbr2.zzaoz;
        synchronized (object) {
            zzbr2.zzaow.add(zzbu2);
            if (zzbr2.zzaou == null) {
                zzbr2.zzaou = new zzbv(zzbr2, "Measurement Network", zzbr2.zzaow);
                zzbr2.zzaou.setUncaughtExceptionHandler(zzbr2.zzaoy);
                zzbr2.zzaou.start();
            } else {
                zzbr2.zzaou.zzki();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutorService zzkg() {
        Object object = this.zzaoz;
        synchronized (object) {
            if (this.zzadl == null) {
                this.zzadl = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzadl;
        }
    }

    static /* synthetic */ Semaphore zza(zzbr zzbr2) {
        return zzbr2.zzapa;
    }

    static /* synthetic */ boolean zzb(zzbr zzbr2) {
        return zzbr2.zzapb;
    }

    static /* synthetic */ Object zzc(zzbr zzbr2) {
        return zzbr2.zzaoz;
    }

    static /* synthetic */ zzbv zzd(zzbr zzbr2) {
        return zzbr2.zzaot;
    }

    static /* synthetic */ zzbv zza(zzbr zzbr2, zzbv zzbv2) {
        zzbr2.zzaot = null;
        return null;
    }

    static /* synthetic */ zzbv zze(zzbr zzbr2) {
        return zzbr2.zzaou;
    }

    static /* synthetic */ zzbv zzb(zzbr zzbr2, zzbv zzbv2) {
        zzbr2.zzaou = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzkh() {
        return zzapc;
    }
}

