/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfx;
import java.util.Map;

public final class zzdy
extends zzf {
    @VisibleForTesting
    protected zzdx zzart;
    private volatile zzdx zzaru;
    private zzdx zzarv;
    private final Map<Activity, zzdx> zzarw = new ArrayMap();
    private zzdx zzarx;
    private String zzary;

    public zzdy(zzbw zzbw2) {
        super(zzbw2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @WorkerThread
    public final zzdx zzle() {
        this.zzcl();
        ((zzcr)this).zzaf();
        return this.zzart;
    }

    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzaru == null) {
            ((zzcr)this).zzgt().zzjj().zzby("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzarw.get(activity) == null) {
            ((zzcr)this).zzgt().zzjj().zzby("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzdy.zzcq(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzaru.zzarq.equals(string2);
        boolean bl2 = zzfx.zzv(this.zzaru.zzuw, string);
        if (bl && bl2) {
            ((zzcr)this).zzgt().zzjl().zzby("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzcr)this).zzgt().zzjj().zzg("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzcr)this).zzgt().zzjj().zzg("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcr)this).zzgt().zzjo().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzdx zzdx2 = new zzdx(string, string2, ((zzcr)this).zzgr().zzmj());
        this.zzarw.put(activity, zzdx2);
        this.zza(activity, zzdx2, true);
    }

    public final zzdx zzlf() {
        ((zzcr)this).zzgg();
        return this.zzaru;
    }

    @MainThread
    private final void zza(Activity activity, zzdx zzdx2, boolean bl) {
        zzdx zzdx3;
        zzdx zzdx4 = zzdx3 = this.zzaru == null ? this.zzarv : this.zzaru;
        if (zzdx2.zzarq == null) {
            zzdx2 = new zzdx(zzdx2.zzuw, zzdy.zzcq(activity.getClass().getCanonicalName()), zzdx2.zzarr);
        }
        zzdx zzdx5 = zzdx2;
        this.zzarv = this.zzaru;
        this.zzaru = zzdx5;
        ((zzcr)this).zzgs().zzc(new zzdz(this, bl, zzdx3, zzdx5));
    }

    @WorkerThread
    private final void zza(@NonNull zzdx zzdx2, boolean bl) {
        ((zze)this).zzgi().zzm(((zzcr)this).zzbx().elapsedRealtime());
        if (((zze)this).zzgo().zza(zzdx2.zzars, bl)) {
            zzdx2.zzars = false;
        }
    }

    public static void zza(zzdx zzdx2, Bundle bundle, boolean bl) {
        if (bundle != null && zzdx2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzdx2.zzuw != null) {
                bundle.putString("_sn", zzdx2.zzuw);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzdx2.zzarq);
            bundle.putLong("_si", zzdx2.zzarr);
            return;
        }
        if (bundle != null && zzdx2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzdx zzdx2) {
        ((zzcr)this).zzaf();
        zzdy zzdy2 = this;
        synchronized (zzdy2) {
            if (this.zzary == null || this.zzary.equals(string) || zzdx2 != null) {
                this.zzary = string;
                this.zzarx = zzdx2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzcq(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzdx zze(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzdx zzdx2 = this.zzarw.get(activity);
        if (zzdx2 == null) {
            String string = zzdy.zzcq(activity.getClass().getCanonicalName());
            zzdx2 = new zzdx(null, string, ((zzcr)this).zzgr().zzmj());
            this.zzarw.put(activity, zzdx2);
        }
        return zzdx2;
    }

    @MainThread
    public final void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzdx zzdx2 = new zzdx(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzarw.put(activity, zzdx2);
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzdx zzdx2 = this.zze(activity);
        this.zza(activity, zzdx2, false);
        zza zza2 = ((zze)this).zzgi();
        long l = ((zzcr)zza2).zzbx().elapsedRealtime();
        ((zzcr)zza2).zzgs().zzc(new zzd(zza2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzdx zzdx2 = this.zze(activity);
        this.zzarv = this.zzaru;
        this.zzaru = null;
        ((zzcr)this).zzgs().zzc(new zzea(this, zzdx2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzdx zzdx2 = this.zzarw.get(activity);
        if (zzdx2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzdx2.zzarr);
        bundle2.putString("name", zzdx2.zzuw);
        bundle2.putString("referrer_name", zzdx2.zzarq);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzarw.remove(activity);
    }

    static /* synthetic */ void zza(zzdy zzdy2, zzdx zzdx2, boolean bl) {
        zzdy2.zza(zzdx2, bl);
    }
}

