/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzs;
import java.lang.reflect.InvocationTargetException;

public final class zzq
extends zzcr {
    private Boolean zzagw;
    @NonNull
    private zzs zzagx = zzr.zzagy;
    private Boolean zzyk;

    zzq(zzbw zzbw2) {
        super(zzbw2);
        zzai.zza(zzbw2);
    }

    final void zza(@NonNull zzs zzs2) {
        this.zzagx = zzs2;
    }

    static String zzhy() {
        return zzai.zzaiu.get();
    }

    @WorkerThread
    public final int zzaq(@Size(min=1L) String string) {
        return this.zzb(string, zzai.zzaji);
    }

    public final long zzhh() {
        zzn zzn2 = ((zzcr)this).zzgw();
        return 14711L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzdw() {
        if (this.zzyk == null) {
            zzq zzq2 = this;
            synchronized (zzq2) {
                if (this.zzyk == null) {
                    ApplicationInfo applicationInfo = ((zzcr)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzyk = string2 != null && string2.equals(string);
                    }
                    if (this.zzyk == null) {
                        this.zzyk = Boolean.TRUE;
                        ((zzcr)this).zzgt().zzjg().zzby("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzyk;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzai.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzagx.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.parseLong(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzai.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzagx.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.parseInt(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzai.zza<Double> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzagx.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            double d = Double.parseDouble(string2);
            return zza2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzai.zza<Boolean> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzagx.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zza2.get(bl);
    }

    public final boolean zze(String string, zzai.zza<Boolean> zza2) {
        return this.zzd(string, zza2);
    }

    public final boolean zza(zzai.zza<Boolean> zza2) {
        zzai.zza<Boolean> zza3 = zza2;
        return this.zzd(null, zza3);
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzar(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            if (((zzcr)this).getContext().getPackageManager() == null) {
                ((zzcr)this).zzgt().zzjg().zzby("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzcr)this).getContext()).getApplicationInfo(((zzcr)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzcr)this).zzgt().zzjg().zzby("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzcr)this).zzgt().zzjg().zzby("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzcr)this).zzgt().zzjg().zzg("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzhz() {
        zzn zzn2 = ((zzcr)this).zzgw();
        Boolean bl = this.zzar("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzia() {
        zzn zzn2 = ((zzcr)this).zzgw();
        return this.zzar("firebase_analytics_collection_enabled");
    }

    public static long zzib() {
        return zzai.zzajx.get();
    }

    public static long zzic() {
        return zzai.zzaix.get();
    }

    public final String zzid() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzcr)this).zzgt().zzjg().zzg("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzcr)this).zzgt().zzjg().zzg("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzcr)this).zzgt().zzjg().zzg("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzcr)this).zzgt().zzjg().zzg("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzie() {
        return zzai.zzait.get();
    }

    public final boolean zzas(String string) {
        return "1".equals(this.zzagx.zzf(string, "gaia_collection_enabled"));
    }

    public final boolean zzat(String string) {
        return "1".equals(this.zzagx.zzf(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzau(String string) {
        return this.zzd(string, zzai.zzakh);
    }

    @WorkerThread
    final boolean zzav(String string) {
        return this.zzd(string, zzai.zzakj);
    }

    @WorkerThread
    final boolean zzaw(String string) {
        return this.zzd(string, zzai.zzakk);
    }

    @WorkerThread
    final boolean zzax(String string) {
        return this.zzd(string, zzai.zzakb);
    }

    @WorkerThread
    final String zzay(String string) {
        zzai.zza<String> zza2 = zzai.zzakc;
        String string2 = string;
        zzq zzq2 = this;
        if (string2 == null) {
            return zza2.get();
        }
        return zza2.get(zzq2.zzagx.zzf(string2, zza2.getKey()));
    }

    final boolean zzaz(String string) {
        return this.zzd(string, zzai.zzakl);
    }

    @WorkerThread
    final boolean zzba(String string) {
        return this.zzd(string, zzai.zzakm);
    }

    final boolean zzbb(String string) {
        return this.zzd(string, zzai.zzako);
    }

    @WorkerThread
    final boolean zzbc(String string) {
        return this.zzd(string, zzai.zzakp);
    }

    @WorkerThread
    final boolean zzbd(String string) {
        return this.zzd(string, zzai.zzakq);
    }

    @WorkerThread
    final boolean zzbe(String string) {
        return this.zzd(string, zzai.zzaks);
    }

    @WorkerThread
    final boolean zzif() {
        if (this.zzagw == null) {
            this.zzagw = this.zzar("app_measurement_lite");
            if (this.zzagw == null) {
                this.zzagw = false;
            }
        }
        return this.zzagw != false || !this.zzada.zzkr();
    }

    @WorkerThread
    final boolean zzbf(String string) {
        return this.zzd(string, zzai.zzakr);
    }

    @WorkerThread
    static boolean zzig() {
        return zzai.zzakt.get();
    }

    @WorkerThread
    final boolean zzbg(String string) {
        return this.zzd(string, zzai.zzaku);
    }

    @WorkerThread
    final boolean zzbh(String string) {
        return this.zzd(string, zzai.zzakv);
    }

    @WorkerThread
    final boolean zzbi(String string) {
        return this.zzd(string, zzai.zzakw);
    }

    @WorkerThread
    final boolean zzbj(String string) {
        return this.zzd(string, zzai.zzakx);
    }

    @WorkerThread
    final boolean zzbk(String string) {
        return this.zzd(string, zzai.zzalb);
    }
}

