/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.playintegrity.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.android.play.core.integrity.IntegrityManager;
import com.google.android.play.core.integrity.IntegrityManagerFactory;
import com.google.android.play.core.integrity.IntegrityTokenRequest;
import com.google.android.play.core.integrity.IntegrityTokenResponse;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.appcheck.AppCheckProvider;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.internal.AppCheckTokenResponse;
import com.google.firebase.appcheck.internal.DefaultAppCheckToken;
import com.google.firebase.appcheck.internal.NetworkClient;
import com.google.firebase.appcheck.internal.RetryManager;
import com.google.firebase.appcheck.playintegrity.internal.ExchangePlayIntegrityTokenRequest;
import com.google.firebase.appcheck.playintegrity.internal.GeneratePlayIntegrityChallengeRequest;
import com.google.firebase.appcheck.playintegrity.internal.GeneratePlayIntegrityChallengeResponse;
import java.util.concurrent.Executor;

public class PlayIntegrityAppCheckProvider
implements AppCheckProvider {
    private static final String UTF_8 = "UTF-8";
    private final String projectNumber;
    private final IntegrityManager integrityManager;
    private final NetworkClient networkClient;
    private final Executor liteExecutor;
    private final Executor blockingExecutor;
    private final RetryManager retryManager;

    public PlayIntegrityAppCheckProvider(@NonNull FirebaseApp firebaseApp, @Lightweight Executor liteExecutor, @Blocking Executor blockingExecutor) {
        this(firebaseApp.getOptions().getGcmSenderId(), IntegrityManagerFactory.create((Context)firebaseApp.getApplicationContext()), new NetworkClient(firebaseApp), liteExecutor, blockingExecutor, new RetryManager());
    }

    @VisibleForTesting
    PlayIntegrityAppCheckProvider(@NonNull String projectNumber, @NonNull IntegrityManager integrityManager, @NonNull NetworkClient networkClient, @NonNull Executor liteExecutor, @NonNull Executor blockingExecutor, @NonNull RetryManager retryManager) {
        this.projectNumber = projectNumber;
        this.integrityManager = integrityManager;
        this.networkClient = networkClient;
        this.liteExecutor = liteExecutor;
        this.blockingExecutor = blockingExecutor;
        this.retryManager = retryManager;
    }

    @NonNull
    public Task<AppCheckToken> getToken() {
        return this.getPlayIntegrityAttestation().onSuccessTask(this.liteExecutor, integrityTokenResponse -> {
            ExchangePlayIntegrityTokenRequest request = new ExchangePlayIntegrityTokenRequest(integrityTokenResponse.token());
            return Tasks.call((Executor)this.blockingExecutor, () -> this.networkClient.exchangeAttestationForAppCheckToken(request.toJsonString().getBytes(UTF_8), 3, this.retryManager));
        }).onSuccessTask(this.liteExecutor, appCheckTokenResponse -> Tasks.forResult((Object)DefaultAppCheckToken.constructFromAppCheckTokenResponse((AppCheckTokenResponse)appCheckTokenResponse)));
    }

    @NonNull
    private Task<IntegrityTokenResponse> getPlayIntegrityAttestation() {
        GeneratePlayIntegrityChallengeRequest generateChallengeRequest = new GeneratePlayIntegrityChallengeRequest();
        return Tasks.call((Executor)this.blockingExecutor, () -> GeneratePlayIntegrityChallengeResponse.fromJsonString(this.networkClient.generatePlayIntegrityChallenge(generateChallengeRequest.toJsonString().getBytes(UTF_8), this.retryManager))).onSuccessTask(this.liteExecutor, generatePlayIntegrityChallengeResponse -> this.integrityManager.requestIntegrityToken(IntegrityTokenRequest.builder().setCloudProjectNumber(Long.parseLong(this.projectNumber)).setNonce(generatePlayIntegrityChallengeResponse.getChallenge()).build()));
    }
}

