/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzca;
import com.google.android.gms.internal.icing.zzdl;
import com.google.android.gms.internal.icing.zzdq;
import com.google.android.gms.internal.icing.zzfb;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzcc
extends zzca<Boolean>
implements zzdq<Boolean>,
zzfb,
RandomAccess {
    private static final zzcc zzfv = new zzcc();
    private boolean[] zzfw;
    private int size;

    public static zzcc zzan() {
        return zzfv;
    }

    zzcc() {
        this(new boolean[10], 0);
    }

    private zzcc(boolean[] blArray, int n) {
        this.zzfw = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzak();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzfw, n2, this.zzfw, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzcc)) {
            return super.equals(object);
        }
        zzcc zzcc2 = (zzcc)object;
        if (this.size != zzcc2.size) {
            return false;
        }
        boolean[] blArray = zzcc2.zzfw;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzfw[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdl.zzi(this.zzfw[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzak();
        zzdl.checkNotNull(collection);
        if (!(collection instanceof zzcc)) {
            return super.addAll(collection);
        }
        zzcc zzcc2 = (zzcc)collection;
        if (zzcc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzcc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzcc2.size;
        if (n > this.zzfw.length) {
            this.zzfw = Arrays.copyOf(this.zzfw, n);
        }
        System.arraycopy(zzcc2.zzfw, 0, this.zzfw, this.size, zzcc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzak();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzfw[i])) continue;
            System.arraycopy(this.zzfw, i + 1, this.zzfw, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzcc zzcc2 = this;
        zzcc2.zzak();
        zzcc2.zzh(n);
        boolean bl3 = zzcc2.zzfw[n];
        zzcc2.zzfw[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzcc zzcc2 = this;
        zzcc2.zzak();
        zzcc2.zzh(n);
        boolean bl = zzcc2.zzfw[n];
        if (n < zzcc2.size - 1) {
            System.arraycopy(zzcc2.zzfw, n + 1, zzcc2.zzfw, n, zzcc2.size - n);
        }
        --zzcc2.size;
        ++zzcc2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        int n2 = n;
        zzcc zzcc2 = this;
        zzcc2.zzak();
        if (n2 < 0 || n2 > zzcc2.size) {
            throw new IndexOutOfBoundsException(zzcc2.zzi(n2));
        }
        if (zzcc2.size < zzcc2.zzfw.length) {
            System.arraycopy(zzcc2.zzfw, n2, zzcc2.zzfw, n2 + 1, zzcc2.size - n2);
        } else {
            boolean[] blArray = new boolean[zzcc2.size * 3 / 2 + 1];
            System.arraycopy(zzcc2.zzfw, 0, blArray, 0, n2);
            System.arraycopy(zzcc2.zzfw, n2, blArray, n2 + 1, zzcc2.size - n2);
            zzcc2.zzfw = blArray;
        }
        zzcc2.zzfw[n2] = bl2;
        ++zzcc2.size;
        ++zzcc2.modCount;
    }

    @Override
    public final /* synthetic */ zzdq zzj(int n) {
        int n2 = n;
        zzcc zzcc2 = this;
        if (n2 < zzcc2.size) {
            throw new IllegalArgumentException();
        }
        return new zzcc(Arrays.copyOf(zzcc2.zzfw, n2), zzcc2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzcc zzcc2 = this;
        zzcc2.zzh(n);
        return zzcc2.zzfw[n];
    }

    static {
        zzfv.zzaj();
    }
}

