/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzca;
import com.google.android.gms.internal.icing.zzdl;
import com.google.android.gms.internal.icing.zzdq;
import com.google.android.gms.internal.icing.zzfb;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdk
extends zzca<Integer>
implements zzdq<Integer>,
zzfb,
RandomAccess {
    private static final zzdk zzko = new zzdk();
    private int[] zzkp;
    private int size;

    zzdk() {
        this(new int[10], 0);
    }

    private zzdk(int[] nArray, int n) {
        this.zzkp = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzak();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzkp, n2, this.zzkp, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdk)) {
            return super.equals(object);
        }
        zzdk zzdk2 = (zzdk)object;
        if (this.size != zzdk2.size) {
            return false;
        }
        int[] nArray = zzdk2.zzkp;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzkp[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzkp[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzh(n);
        return this.zzkp[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzak();
        zzdl.checkNotNull(collection);
        if (!(collection instanceof zzdk)) {
            return super.addAll(collection);
        }
        zzdk zzdk2 = (zzdk)collection;
        if (zzdk2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdk2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdk2.size;
        if (n > this.zzkp.length) {
            this.zzkp = Arrays.copyOf(this.zzkp, n);
        }
        System.arraycopy(zzdk2.zzkp, 0, this.zzkp, this.size, zzdk2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzak();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzkp[i])) continue;
            System.arraycopy(this.zzkp, i + 1, this.zzkp, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdk zzdk2 = this;
        zzdk2.zzak();
        zzdk2.zzh(n);
        int n4 = zzdk2.zzkp[n];
        zzdk2.zzkp[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdk zzdk2 = this;
        zzdk2.zzak();
        zzdk2.zzh(n);
        int n2 = zzdk2.zzkp[n];
        if (n < zzdk2.size - 1) {
            System.arraycopy(zzdk2.zzkp, n + 1, zzdk2.zzkp, n, zzdk2.size - n);
        }
        --zzdk2.size;
        ++zzdk2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        int n4 = n;
        zzdk zzdk2 = this;
        zzdk2.zzak();
        if (n4 < 0 || n4 > zzdk2.size) {
            throw new IndexOutOfBoundsException(zzdk2.zzi(n4));
        }
        if (zzdk2.size < zzdk2.zzkp.length) {
            System.arraycopy(zzdk2.zzkp, n4, zzdk2.zzkp, n4 + 1, zzdk2.size - n4);
        } else {
            int[] nArray = new int[zzdk2.size * 3 / 2 + 1];
            System.arraycopy(zzdk2.zzkp, 0, nArray, 0, n4);
            System.arraycopy(zzdk2.zzkp, n4, nArray, n4 + 1, zzdk2.size - n4);
            zzdk2.zzkp = nArray;
        }
        zzdk2.zzkp[n4] = n3;
        ++zzdk2.size;
        ++zzdk2.modCount;
    }

    @Override
    public final /* synthetic */ zzdq zzj(int n) {
        int n2 = n;
        zzdk zzdk2 = this;
        if (n2 < zzdk2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdk(Arrays.copyOf(zzdk2.zzkp, n2), zzdk2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzko.zzaj();
    }
}

