/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.icing.zzak;
import com.google.android.gms.internal.icing.zzdj;
import com.google.android.gms.internal.icing.zzg;
import com.google.android.gms.internal.icing.zzh;
import com.google.android.gms.internal.icing.zzj;
import com.google.android.gms.internal.icing.zzl;
import com.google.android.gms.internal.icing.zzt;
import com.google.android.gms.internal.icing.zzz;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.zip.CRC32;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="UsageInfoCreator")
@ShowFirstParty
public final class zzx
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzx> CREATOR = new zzz();
    @SafeParcelable.Field(id=1)
    private final zzj zzaj;
    @SafeParcelable.Field(id=2)
    private final long zzak;
    @SafeParcelable.Field(id=3)
    private int zzal;
    @SafeParcelable.Field(id=4)
    private final String zzam;
    @SafeParcelable.Field(id=5)
    private final zzg zzan;
    @SafeParcelable.Field(id=6, defaultValue="false")
    private final boolean zzao;
    @SafeParcelable.Field(id=7, defaultValue="-1")
    private int zzap;
    @SafeParcelable.Field(id=8)
    private int zzaq;
    @SafeParcelable.Field(id=9)
    private final String zzar;

    @VisibleForTesting
    public zzx(String string, Intent intent, String string2, Uri uri, String string3, List<AppIndexApi.AppIndexingLink> list, int n) {
        this(zzx.zza(string, intent), System.currentTimeMillis(), 0, null, zzx.zza(intent, string2, uri, null, list).zzb(), false, -1, 1, null);
    }

    @SafeParcelable.Constructor
    zzx(@SafeParcelable.Param(id=1) zzj zzj2, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) String string, @SafeParcelable.Param(id=5) zzg zzg2, @SafeParcelable.Param(id=6) boolean bl, @SafeParcelable.Param(id=7) int n2, @SafeParcelable.Param(id=8) int n3, @SafeParcelable.Param(id=9) String string2) {
        this.zzaj = zzj2;
        this.zzak = l;
        this.zzal = n;
        this.zzam = string;
        this.zzan = zzg2;
        this.zzao = bl;
        this.zzap = n2;
        this.zzaq = n3;
        this.zzar = string2;
    }

    public static zzj zza(String string, Intent intent) {
        String string2 = zzx.zza(intent);
        String string3 = string;
        return new zzj(string3, "", string2);
    }

    private static zzl zza(String string, String string2) {
        return new zzl(string2, new zzt(string).zzb(true).zzc(), string);
    }

    private static String zza(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    @VisibleForTesting
    public static zzh zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        zzh zzh2 = new zzh();
        Object object = string;
        zzh2.zza(new zzl((String)object, new zzt("title").zzc(true).zzd("name").zzc(), "text1"));
        if (uri != null) {
            object = uri;
            zzh2.zza(new zzl(object.toString(), new zzt("web_url").zzb(true).zzd("url").zzc()));
        }
        if (list != null) {
            object = list;
            zzak.zza.zza zza2 = zzak.zza.zzf();
            zzak.zza.zzb[] zzbArray = new zzak.zza.zzb[object.size()];
            for (int i = 0; i < zzbArray.length; ++i) {
                zzak.zza.zzb.zza zza3 = zzak.zza.zzb.zzh();
                AppIndexApi.AppIndexingLink appIndexingLink = (AppIndexApi.AppIndexingLink)object.get(i);
                zza3.zzg(appIndexingLink.appIndexingUrl.toString()).zze(appIndexingLink.viewId);
                if (appIndexingLink.webUrl != null) {
                    zza3.zzh(appIndexingLink.webUrl.toString());
                }
                zzbArray[i] = (zzak.zza.zzb)((zzdj)zza3.zzca());
            }
            zza2.zzb(Arrays.asList(zzbArray));
            zzh2.zza(new zzl(((zzak.zza)((zzdj)zza2.zzca())).toByteArray(), new zzt("outlinks").zzb(true).zzd(".private:outLinks").zzc("blob").zzc()));
        }
        if ((string5 = intent.getAction()) != null) {
            zzh2.zza(zzx.zza("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zzh2.zza(zzx.zza("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zzh2.zza(zzx.zza("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zzh2.zza(zzx.zza("intent_extra_data", string3));
        }
        return zzh2.zza(string2).zza(true);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzx zzx2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)zzx2.zzaj, (int)n, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)2, (long)zzx2.zzak);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zzx2.zzal);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzx2.zzam, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)zzx2.zzan, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)6, (boolean)zzx2.zzao);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzx2.zzap);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)8, (int)zzx2.zzaq);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)zzx2.zzar, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        return String.format(Locale.US, "UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", new Object[]{this.zzaj, this.zzak, this.zzal, this.zzaq});
    }
}

