/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.builders.IndexableBuilder;
import com.google.firebase.appindexing.internal.zza;
import com.google.firebase.appindexing.internal.zzb;
import com.google.firebase.appindexing.internal.zzu;
import java.util.Arrays;

public interface Action {

    public static class Builder {
        public static final String ACTIVATE_ACTION = "ActivateAction";
        public static final String ADD_ACTION = "AddAction";
        public static final String BOOKMARK_ACTION = "BookmarkAction";
        public static final String COMMENT_ACTION = "CommentAction";
        public static final String LIKE_ACTION = "LikeAction";
        public static final String LISTEN_ACTION = "ListenAction";
        public static final String SEND_ACTION = "SendAction";
        public static final String SHARE_ACTION = "ShareAction";
        public static final String VIEW_ACTION = "ViewAction";
        public static final String WATCH_ACTION = "WatchAction";
        public static final String STATUS_TYPE_ACTIVE = "http://schema.org/ActiveActionStatus";
        public static final String STATUS_TYPE_COMPLETED = "http://schema.org/CompletedActionStatus";
        public static final String STATUS_TYPE_FAILED = "http://schema.org/FailedActionStatus";
        private final Bundle zzax = new Bundle();
        private final String zzar;
        private String zzea;
        private String zzeb;
        private String zzec;
        private zzb zzed;
        private String zzee;

        public Builder(@NonNull String string) {
            this.zzar = string;
        }

        public Builder put(@NonNull String string, String ... stringArray) {
            IndexableBuilder.zza(this.zzax, string, stringArray);
            return this;
        }

        public Builder put(@NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
            IndexableBuilder.zza(this.zzax, string, indexableArray);
            return this;
        }

        public Builder put(@NonNull String string, boolean ... blArray) {
            IndexableBuilder.zza(this.zzax, string, blArray);
            return this;
        }

        public Builder put(@NonNull String string, long ... lArray) {
            IndexableBuilder.zza(this.zzax, string, lArray);
            return this;
        }

        public Builder put(@NonNull String string, double ... dArray) {
            double[] dArray2 = dArray;
            String string2 = string;
            Bundle bundle = this.zzax;
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)dArray2);
            if (dArray2.length > 0) {
                double[] dArray3;
                double[] dArray4 = dArray2;
                if (dArray2.length < 100) {
                    dArray3 = dArray4;
                } else {
                    zzu.zzr("Input Array of elements is too big, cutting off.");
                    dArray3 = Arrays.copyOf(dArray4, 100);
                }
                bundle.putDoubleArray(string2, dArray3);
            } else {
                zzu.zzr("Double array is empty and is ignored by put method.");
            }
            return this;
        }

        public final Builder setUrl(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzeb = string;
            return this.put("url", string);
        }

        public Builder setObject(@NonNull String string, @NonNull String string2) {
            Preconditions.checkNotNull((Object)string);
            Preconditions.checkNotNull((Object)string2);
            this.zzea = string;
            this.zzeb = string2;
            return this;
        }

        public Builder setObject(@NonNull String string, @NonNull String string2, @NonNull String string3) {
            Preconditions.checkNotNull((Object)string);
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)string3);
            this.zzea = string;
            this.zzeb = string2;
            this.zzec = string3;
            return this;
        }

        public final Builder setName(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzea = string;
            return this.put("name", string);
        }

        public Builder setMetadata(@NonNull Metadata.Builder builder) {
            Preconditions.checkNotNull((Object)builder);
            this.zzed = builder.zzab();
            return this;
        }

        public Builder setActionStatus(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzee = string;
            return this;
        }

        public Action build() {
            Preconditions.checkNotNull((Object)this.zzea, (Object)"setObject is required before calling build().");
            Preconditions.checkNotNull((Object)this.zzeb, (Object)"setObject is required before calling build().");
            return new zza(this.zzar, this.zzea, this.zzeb, this.zzec, this.zzed == null ? new Metadata.Builder().zzab() : this.zzed, this.zzee, this.zzax);
        }
    }

    public static interface Metadata {

        public static class Builder {
            private boolean zzef = true;
            private boolean zzeg = false;

            public Builder() {
            }

            public Builder setUpload(boolean bl) {
                this.zzef = bl;
                return this;
            }

            public final zzb zzab() {
                return new zzb(this.zzef, null, null, null, false);
            }
        }
    }
}

