/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.internal;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.zzac;
import com.google.firebase.appindexing.internal.zzad;
import com.google.firebase.appindexing.internal.zzv;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

@SafeParcelable.Class(creator="ThingCreator")
public final class Thing
extends AbstractSafeParcelable
implements ReflectedParcelable,
Indexable {
    public static final Parcelable.Creator<Thing> CREATOR = new zzad();
    @SafeParcelable.Field(id=1000, getter="getVersionCode")
    private final int zzfm;
    @SafeParcelable.Field(id=1, getter="getPropertyBundle")
    private final Bundle zzax;
    @SafeParcelable.Field(id=2, getter="getMetadata")
    private final zza zzek;
    @SafeParcelable.Field(id=3, getter="getUrl")
    private final String zzfn;
    @SafeParcelable.Field(id=4, getter="getType")
    private final String type;

    @SafeParcelable.Constructor
    public Thing(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) Bundle bundle, @SafeParcelable.Param(id=2) zza zza2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2) {
        this.zzfm = n;
        this.zzax = bundle;
        this.zzek = zza2;
        this.zzfn = string;
        this.type = string2;
        this.zzax.setClassLoader(this.getClass().getClassLoader());
    }

    public Thing(@NonNull Bundle bundle, @NonNull zza zza2, String string, @NonNull String string2) {
        this.zzfm = 10;
        this.zzax = bundle;
        this.zzek = zza2;
        this.zzfn = string;
        this.type = string2;
    }

    public final zza zzae() {
        return this.zzek;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Thing thing = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)1, (Bundle)thing.zzax, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)thing.zzek, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)thing.zzfn, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)thing.type, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)thing.zzfm);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private static void zza(@NonNull Bundle bundle, @NonNull StringBuilder stringBuilder) {
        try {
            Set set = bundle.keySet();
            String[] stringArray = set.toArray(new String[set.size()]);
            Arrays.sort(stringArray, zzac.zzfo);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                stringBuilder.append("{ key: '").append(string).append("' value: ");
                Object object = bundle.get(string);
                if (object == null) {
                    stringBuilder.append("<null>");
                } else if (object.getClass().isArray()) {
                    stringBuilder.append("[ ");
                    for (int j = 0; j < Array.getLength(object); ++j) {
                        stringBuilder.append("'").append(Array.get(object, j)).append("' ");
                    }
                    stringBuilder.append("]");
                } else {
                    stringBuilder.append(object.toString());
                }
                stringBuilder.append(" } ");
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("<error>");
            return;
        }
    }

    public final String toString() {
        Thing thing = this;
        StringBuilder stringBuilder = new StringBuilder().append(thing.type.equals("Thing") ? "Indexable" : thing.type).append(" { { id: ");
        if (this.zzfn == null) {
            stringBuilder.append("<null>");
        } else {
            stringBuilder.append("'").append(this.zzfn).append("'");
        }
        stringBuilder.append(" } Properties { ");
        Thing.zza(this.zzax, stringBuilder);
        stringBuilder.append("} ");
        stringBuilder.append("Metadata { ");
        stringBuilder.append(this.zzek.toString());
        stringBuilder.append(" } ");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Thing)) {
            return false;
        }
        Thing thing = (Thing)object;
        return Objects.equal((Object)this.zzfm, (Object)thing.zzfm) && Objects.equal((Object)this.zzfn, (Object)thing.zzfn) && Objects.equal((Object)this.type, (Object)thing.type) && Objects.equal((Object)this.zzek, (Object)thing.zzek) && Thing.zza(this.zzax, thing.zzax);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzfm, this.zzfn, this.type, this.zzek.hashCode(), Thing.zzb(this.zzax)});
    }

    private static boolean zza(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            Object object2 = bundle2.get(string);
            if (object instanceof Bundle && object2 instanceof Bundle && !Thing.zza((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object != null || object2 == null && bundle2.containsKey(string))) {
                return false;
            }
            if (!(object instanceof boolean[] ? !(object2 instanceof boolean[]) || !Arrays.equals((boolean[])object, (boolean[])object2) : (object instanceof long[] ? !(object2 instanceof long[]) || !Arrays.equals((long[])object, (long[])object2) : (object instanceof double[] ? !(object2 instanceof double[]) || !Arrays.equals((double[])object, (double[])object2) : (object instanceof byte[] ? !(object2 instanceof byte[]) || !Arrays.equals((byte[])object, (byte[])object2) : object instanceof Object[] && (!(object2 instanceof Object[]) || !Arrays.equals((Object[])object, (Object[])object2))))))) continue;
            return false;
        }
        return true;
    }

    private static int zzb(Bundle bundle) {
        ArrayList arrayList = new ArrayList(bundle.keySet());
        Collections.sort(arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            String string = (String)e;
            Object object = bundle.get(string);
            if (object instanceof boolean[]) {
                arrayList2.add(Arrays.hashCode((boolean[])object));
                continue;
            }
            if (object instanceof long[]) {
                arrayList2.add(Arrays.hashCode((long[])object));
                continue;
            }
            if (object instanceof double[]) {
                arrayList2.add(Arrays.hashCode((double[])object));
                continue;
            }
            if (object instanceof byte[]) {
                arrayList2.add(Arrays.hashCode((byte[])object));
                continue;
            }
            if (object instanceof Object[]) {
                arrayList2.add(Arrays.hashCode((Object[])object));
                continue;
            }
            arrayList2.add(Objects.hashCode((Object[])new Object[]{object}));
        }
        return Objects.hashCode((Object[])arrayList2.toArray());
    }

    static final /* synthetic */ int zzb(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    @SafeParcelable.Reserved(value={1000})
    @SafeParcelable.Class(creator="MetadataCreator")
    public static final class zza
    extends AbstractSafeParcelable
    implements Indexable.Metadata {
        public static final Parcelable.Creator<zza> CREATOR = new zzv();
        @SafeParcelable.Field(id=1, getter="getWorksOffline")
        private final boolean zzei;
        @SafeParcelable.Field(id=2, getter="getScore")
        private final int score;
        @SafeParcelable.Field(id=3, getter="getAccountEmail")
        private final String zzej;
        @SafeParcelable.Field(id=4, getter="getPropertyBundle")
        private final Bundle zzax;

        @SafeParcelable.Constructor
        public zza(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) Bundle bundle) {
            this.zzei = bl;
            this.score = n;
            this.zzej = string;
            this.zzax = bundle == null ? new Bundle() : bundle;
        }

        public final Bundle zze() {
            return this.zzax;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            zza zza2 = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)zza2.zzei);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)zza2.score);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zza2.zzej, (boolean)false);
            SafeParcelWriter.writeBundle((Parcel)parcel2, (int)4, (Bundle)zza2.zzax, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("worksOffline: ").append(this.zzei).append(", score: ").append(this.score);
            if (!this.zzej.isEmpty()) {
                stringBuilder.append(", accountEmail: ").append(this.zzej);
            }
            if (this.zzax != null && !this.zzax.isEmpty()) {
                stringBuilder.append(", Properties { ");
                Thing.zza(this.zzax, stringBuilder);
                stringBuilder.append("}");
            }
            return stringBuilder.toString();
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return Objects.equal((Object)this.zzei, (Object)zza2.zzei) && Objects.equal((Object)this.score, (Object)zza2.score) && Objects.equal((Object)this.zzej, (Object)zza2.zzej) && Thing.zza(this.zzax, zza2.zzax);
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzei, this.score, this.zzej, Thing.zzb(this.zzax)});
        }
    }
}

