/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RequiresApi;
import com.google.firebase.Timestamp;
import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001#B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u0011\b\u0017\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u0006\u0010\u0013\u001a\u00020\nJ\b\u0010\u0014\u001a\u00020\rH\u0007J\u0011\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/google/firebase/Timestamp;", "", "Landroid/os/Parcelable;", "seconds", "", "nanoseconds", "", "<init>", "(JI)V", "date", "Ljava/util/Date;", "(Ljava/util/Date;)V", "time", "Ljava/time/Instant;", "(Ljava/time/Instant;)V", "getSeconds", "()J", "getNanoseconds", "()I", "toDate", "toInstant", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "describeContents", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "com.google.firebase-firebase-common"})
public final class Timestamp
implements Comparable<Timestamp>,
Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long seconds;
    private final int nanoseconds;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<Timestamp> CREATOR = (Parcelable.Creator)new Parcelable.Creator<Timestamp>(){

        public Timestamp createFromParcel(Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Timestamp(source.readLong(), source.readInt());
        }

        public Timestamp[] newArray(int size) {
            return new Timestamp[size];
        }
    };

    public final long getSeconds() {
        return this.seconds;
    }

    public final int getNanoseconds() {
        return this.nanoseconds;
    }

    public Timestamp(long seconds, int nanoseconds) {
        Timestamp.Companion.validateRange(seconds, nanoseconds);
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    public Timestamp(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Pair pair = Timestamp.Companion.toPreciseTime(date);
        long seconds = ((Number)pair.component1()).longValue();
        int nanoseconds = ((Number)pair.component2()).intValue();
        Timestamp.Companion.validateRange(seconds, nanoseconds);
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    @RequiresApi(value=26)
    public Timestamp(@NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(time.getEpochSecond(), time.getNano());
    }

    @NotNull
    public final Date toDate() {
        return new Date(this.seconds * (long)1000 + (long)(this.nanoseconds / 1000000));
    }

    @RequiresApi(value=26)
    @NotNull
    public final Instant toInstant() {
        Instant instant = Instant.ofEpochSecond(this.seconds, this.nanoseconds);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        return instant;
    }

    @Override
    public int compareTo(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE};
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof Timestamp && this.compareTo((Timestamp)other) == 0;
    }

    public int hashCode() {
        int prime = 37;
        int initialHash = prime * (int)this.seconds;
        int withHighOrderBits = prime * initialHash + (int)(this.seconds >> 32);
        return prime * withHighOrderBits + this.nanoseconds;
    }

    @NotNull
    public String toString() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ')';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeLong(this.seconds);
        dest.writeInt(this.nanoseconds);
    }

    @JvmStatic
    @NotNull
    public static final Timestamp now() {
        return Companion.now();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t*\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/google/firebase/Timestamp$Companion;", "", "<init>", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/google/firebase/Timestamp;", "now", "toPreciseTime", "Lkotlin/Pair;", "", "", "Ljava/util/Date;", "validateRange", "", "seconds", "nanoseconds", "com.google.firebase-firebase-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Timestamp now() {
            return new Timestamp(new Date());
        }

        private final Pair<Long, Integer> toPreciseTime(Date $this$toPreciseTime) {
            long seconds = $this$toPreciseTime.getTime() / (long)1000;
            int nanoseconds = (int)($this$toPreciseTime.getTime() % (long)1000 * (long)1000000);
            if (nanoseconds < 0) {
                return TuplesKt.to((Object)(seconds - 1L), (Object)(nanoseconds + 1000000000));
            }
            return TuplesKt.to((Object)seconds, (Object)nanoseconds);
        }

        private final void validateRange(long seconds, int nanoseconds) {
            if (!(0 <= nanoseconds ? nanoseconds < 1000000000 : false)) {
                boolean $i$a$-require-Timestamp$Companion$validateRange$32 = false;
                String $i$a$-require-Timestamp$Companion$validateRange$32 = "Timestamp nanoseconds out of range: " + nanoseconds;
                throw new IllegalArgumentException($i$a$-require-Timestamp$Companion$validateRange$32.toString());
            }
            if (!(-62135596800L <= seconds ? seconds < 253402300800L : false)) {
                boolean bl = false;
                String string = "Timestamp seconds out of range: " + seconds;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

