/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.logger;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000f\b&\u0018\u0000 (2\u00020\u0001:\u0004%&'(B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ9\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J9\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J9\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J9\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J9\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010 \u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J;\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00032\u0012\b\u0002\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010#J9\u0010$\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00032\u0010\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH&\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/google/firebase/logger/Logger;", "", "tag", "", "enabled", "", "minLevel", "Lcom/google/firebase/logger/Logger$Level;", "<init>", "(Ljava/lang/String;ZLcom/google/firebase/logger/Logger$Level;)V", "getTag", "()Ljava/lang/String;", "getEnabled", "()Z", "setEnabled", "(Z)V", "getMinLevel", "()Lcom/google/firebase/logger/Logger$Level;", "setMinLevel", "(Lcom/google/firebase/logger/Logger$Level;)V", "verbose", "", "format", "args", "", "throwable", "", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)I", "msg", "debug", "info", "warn", "error", "logIfAble", "level", "(Lcom/google/firebase/logger/Logger$Level;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)I", "log", "AndroidLogger", "FakeLogger", "Level", "Companion", "com.google.firebase-firebase-common"})
public abstract class Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    private boolean enabled;
    @NotNull
    private Level minLevel;
    @NotNull
    private static final ConcurrentHashMap<String, Logger> loggers = new ConcurrentHashMap();

    private Logger(String tag, boolean enabled, Level minLevel) {
        this.tag = tag;
        this.enabled = enabled;
        this.minLevel = minLevel;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final Level getMinLevel() {
        return this.minLevel;
    }

    public final void setMinLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"<set-?>");
        this.minLevel = level;
    }

    @JvmOverloads
    public final int verbose(@NotNull String format, @NotNull Object[] args, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.logIfAble(Level.VERBOSE, format, args, throwable);
    }

    public static /* synthetic */ int verbose$default(Logger logger, String string, Object[] objectArray, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: verbose");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        return logger.verbose(string, objectArray, throwable);
    }

    @JvmOverloads
    public final int verbose(@NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.logIfAble$default(this, Level.VERBOSE, msg, null, throwable, 4, null);
    }

    public static /* synthetic */ int verbose$default(Logger logger, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: verbose");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        return logger.verbose(string, throwable);
    }

    @JvmOverloads
    public final int debug(@NotNull String format, @NotNull Object[] args, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.logIfAble(Level.DEBUG, format, args, throwable);
    }

    public static /* synthetic */ int debug$default(Logger logger, String string, Object[] objectArray, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: debug");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        return logger.debug(string, objectArray, throwable);
    }

    @JvmOverloads
    public final int debug(@NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.logIfAble$default(this, Level.DEBUG, msg, null, throwable, 4, null);
    }

    public static /* synthetic */ int debug$default(Logger logger, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: debug");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        return logger.debug(string, throwable);
    }

    @JvmOverloads
    public final int info(@NotNull String format, @NotNull Object[] args, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.logIfAble(Level.INFO, format, args, throwable);
    }

    public static /* synthetic */ int info$default(Logger logger, String string, Object[] objectArray, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: info");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        return logger.info(string, objectArray, throwable);
    }

    @JvmOverloads
    public final int info(@NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.logIfAble$default(this, Level.INFO, msg, null, throwable, 4, null);
    }

    public static /* synthetic */ int info$default(Logger logger, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: info");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        return logger.info(string, throwable);
    }

    @JvmOverloads
    public final int warn(@NotNull String format, @NotNull Object[] args, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.logIfAble(Level.WARN, format, args, throwable);
    }

    public static /* synthetic */ int warn$default(Logger logger, String string, Object[] objectArray, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warn");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        return logger.warn(string, objectArray, throwable);
    }

    @JvmOverloads
    public final int warn(@NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.logIfAble$default(this, Level.WARN, msg, null, throwable, 4, null);
    }

    public static /* synthetic */ int warn$default(Logger logger, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warn");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        return logger.warn(string, throwable);
    }

    @JvmOverloads
    public final int error(@NotNull String format, @NotNull Object[] args, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.logIfAble(Level.ERROR, format, args, throwable);
    }

    public static /* synthetic */ int error$default(Logger logger, String string, Object[] objectArray, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: error");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        return logger.error(string, objectArray, throwable);
    }

    @JvmOverloads
    public final int error(@NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.logIfAble$default(this, Level.ERROR, msg, null, throwable, 4, null);
    }

    public static /* synthetic */ int error$default(Logger logger, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: error");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        return logger.error(string, throwable);
    }

    private final int logIfAble(Level level, String format, Object[] args, Throwable throwable) {
        return this.enabled && (this.minLevel.getPriority$com_google_firebase_firebase_common() <= level.getPriority$com_google_firebase_firebase_common() || Log.isLoggable((String)this.tag, (int)level.getPriority$com_google_firebase_firebase_common())) ? this.log(level, format, args, throwable) : 0;
    }

    static /* synthetic */ int logIfAble$default(Logger logger, Level level, String string, Object[] objectArray, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logIfAble");
        }
        if ((n & 4) != 0) {
            objectArray = new Object[]{};
        }
        return logger.logIfAble(level, string, objectArray, throwable);
    }

    public abstract int log(@NotNull Level var1, @NotNull String var2, @NotNull Object[] var3, @Nullable Throwable var4);

    @JvmOverloads
    public final int verbose(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return Logger.verbose$default(this, format, args, null, 4, null);
    }

    @JvmOverloads
    public final int verbose(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.verbose$default(this, msg, null, 2, null);
    }

    @JvmOverloads
    public final int debug(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return Logger.debug$default(this, format, args, null, 4, null);
    }

    @JvmOverloads
    public final int debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.debug$default(this, msg, null, 2, null);
    }

    @JvmOverloads
    public final int info(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return Logger.info$default(this, format, args, null, 4, null);
    }

    @JvmOverloads
    public final int info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.info$default(this, msg, null, 2, null);
    }

    @JvmOverloads
    public final int warn(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return Logger.warn$default(this, format, args, null, 4, null);
    }

    @JvmOverloads
    public final int warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.warn$default(this, msg, null, 2, null);
    }

    @JvmOverloads
    public final int error(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return Logger.error$default(this, format, args, null, 4, null);
    }

    @JvmOverloads
    public final int error(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return Logger.error$default(this, msg, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Logger getLogger(@NotNull String tag, boolean enabled, @NotNull Level minLevel) {
        return Companion.getLogger(tag, enabled, minLevel);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final FakeLogger setupFakeLogger(@NotNull String tag, boolean enabled, @NotNull Level minLevel) {
        return Companion.setupFakeLogger(tag, enabled, minLevel);
    }

    public /* synthetic */ Logger(String tag, boolean enabled, Level minLevel, DefaultConstructorMarker $constructor_marker) {
        this(tag, enabled, minLevel);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ9\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/google/firebase/logger/Logger$AndroidLogger;", "Lcom/google/firebase/logger/Logger;", "tag", "", "enabled", "", "minLevel", "Lcom/google/firebase/logger/Logger$Level;", "<init>", "(Ljava/lang/String;ZLcom/google/firebase/logger/Logger$Level;)V", "log", "", "level", "format", "args", "", "", "throwable", "", "(Lcom/google/firebase/logger/Logger$Level;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)I", "com.google.firebase-firebase-common"})
    @SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\ncom/google/firebase/logger/Logger$AndroidLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
    private static final class AndroidLogger
    extends Logger {
        public AndroidLogger(@NotNull String tag, boolean enabled, @NotNull Level minLevel) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
            super(tag, enabled, minLevel, null);
        }

        @Override
        public int log(@NotNull Level level, @NotNull String format, @NotNull Object[] args, @Nullable Throwable throwable) {
            int n;
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length == 0) {
                string = format;
            } else {
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string2 = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            }
            String msg = string;
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    Throwable throwable2 = throwable;
                    if (throwable2 != null) {
                        Throwable it = throwable2;
                        boolean bl = false;
                        n = Log.v((String)this.getTag(), (String)msg, (Throwable)throwable);
                        break;
                    }
                    n = Log.v((String)this.getTag(), (String)msg);
                    break;
                }
                case 2: {
                    Throwable throwable3 = throwable;
                    if (throwable3 != null) {
                        Throwable it = throwable3;
                        boolean bl = false;
                        n = Log.d((String)this.getTag(), (String)msg, (Throwable)throwable);
                        break;
                    }
                    n = Log.d((String)this.getTag(), (String)msg);
                    break;
                }
                case 3: {
                    Throwable throwable4 = throwable;
                    if (throwable4 != null) {
                        Throwable it = throwable4;
                        boolean bl = false;
                        n = Log.i((String)this.getTag(), (String)msg, (Throwable)throwable);
                        break;
                    }
                    n = Log.i((String)this.getTag(), (String)msg);
                    break;
                }
                case 4: {
                    Throwable throwable5 = throwable;
                    if (throwable5 != null) {
                        Throwable it = throwable5;
                        boolean bl = false;
                        n = Log.w((String)this.getTag(), (String)msg, (Throwable)throwable);
                        break;
                    }
                    n = Log.w((String)this.getTag(), (String)msg);
                    break;
                }
                case 5: {
                    Throwable throwable6 = throwable;
                    if (throwable6 != null) {
                        Throwable it = throwable6;
                        boolean bl = false;
                        n = Log.e((String)this.getTag(), (String)msg, (Throwable)throwable);
                        break;
                    }
                    n = Log.e((String)this.getTag(), (String)msg);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Level.values().length];
                try {
                    nArray[Level.VERBOSE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.DEBUG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.INFO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.WARN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.ERROR.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/firebase/logger/Logger$Companion;", "", "<init>", "()V", "loggers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/google/firebase/logger/Logger;", "getLogger", "tag", "enabled", "", "minLevel", "Lcom/google/firebase/logger/Logger$Level;", "setupFakeLogger", "Lcom/google/firebase/logger/Logger$FakeLogger;", "com.google.firebase-firebase-common"})
    @SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\ncom/google/firebase/logger/Logger$Companion\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n72#2,2:197\n1#3:199\n*S KotlinDebug\n*F\n+ 1 Logger.kt\ncom/google/firebase/logger/Logger$Companion\n*L\n180#1:197,2\n180#1:199\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Logger getLogger(@NotNull String tag, boolean enabled, @NotNull Level minLevel) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
            ConcurrentMap $this$getOrPut$iv = loggers;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(tag);
            if (object == null) {
                boolean bl = false;
                Logger default$iv = new AndroidLogger(tag, enabled, minLevel);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(tag, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            return (Logger)object;
        }

        public static /* synthetic */ Logger getLogger$default(Companion companion, String string, boolean bl, Level level, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                level = Level.INFO;
            }
            return companion.getLogger(string, bl, level);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final FakeLogger setupFakeLogger(@NotNull String tag, boolean enabled, @NotNull Level minLevel) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
            FakeLogger fakeLogger = new FakeLogger(tag, enabled, minLevel);
            ((Map)loggers).put(tag, fakeLogger);
            return fakeLogger;
        }

        public static /* synthetic */ FakeLogger setupFakeLogger$default(Companion companion, String string, boolean bl, Level level, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                level = Level.DEBUG;
            }
            return companion.setupFakeLogger(string, bl, level);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ9\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0010\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0003H\u0007J\u001c\u0010\u001a\u001a\u00020\u00052\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u001cH\u0007J9\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0010\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/google/firebase/logger/Logger$FakeLogger;", "Lcom/google/firebase/logger/Logger;", "tag", "", "enabled", "", "minLevel", "Lcom/google/firebase/logger/Logger$Level;", "<init>", "(Ljava/lang/String;ZLcom/google/firebase/logger/Logger$Level;)V", "record", "", "log", "", "level", "format", "args", "", "", "throwable", "", "(Lcom/google/firebase/logger/Logger$Level;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)I", "clearLogMessages", "", "hasLogMessage", "message", "hasLogMessageThat", "predicate", "Lkotlin/Function1;", "toLogMessage", "(Lcom/google/firebase/logger/Logger$Level;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)Ljava/lang/String;", "com.google.firebase-firebase-common"})
    @VisibleForTesting
    @SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\ncom/google/firebase/logger/Logger$FakeLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1755#2,3:197\n1755#2,3:200\n1#3:203\n*S KotlinDebug\n*F\n+ 1 Logger.kt\ncom/google/firebase/logger/Logger$FakeLogger\n*L\n144#1:197,3\n148#1:200,3\n*E\n"})
    public static final class FakeLogger
    extends Logger {
        @NotNull
        private final List<String> record;

        public FakeLogger(@NotNull String tag, boolean enabled, @NotNull Level minLevel) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
            super(tag, enabled, minLevel, null);
            this.record = new ArrayList();
        }

        @Override
        public int log(@NotNull Level level, @NotNull String format, @NotNull Object[] args, @Nullable Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            String logMessage = this.toLogMessage(level, format, args, throwable);
            System.out.println((Object)("Log: " + logMessage));
            this.record.add(logMessage);
            return logMessage.length();
        }

        @VisibleForTesting
        public final void clearLogMessages() {
            this.record.clear();
        }

        @VisibleForTesting
        public final boolean hasLogMessage(@NotNull String message) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Iterable $this$any$iv = this.record;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)message, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @VisibleForTesting
        public final boolean hasLogMessageThat(@NotNull Function1<? super String, Boolean> predicate) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                Iterable $this$any$iv = this.record;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final String toLogMessage(Level level, String format, Object[] args, Throwable throwable) {
            Object object;
            block6: {
                String msg;
                block5: {
                    String string;
                    if (args.length == 0) {
                        string = format;
                    } else {
                        Object[] objectArray = Arrays.copyOf(args, args.length);
                        String string2 = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    }
                    msg = string;
                    object = throwable;
                    if (object == null) break block5;
                    Throwable it = object;
                    boolean bl = false;
                    String string3 = (Object)((Object)level) + ' ' + msg + ' ' + Log.getStackTraceString((Throwable)throwable);
                    object = string3;
                    if (string3 != null) break block6;
                }
                object = (Object)((Object)level) + ' ' + msg;
            }
            return object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/google/firebase/logger/Logger$Level;", "", "priority", "", "<init>", "(Ljava/lang/String;II)V", "getPriority$com_google_firebase_firebase_common", "()I", "VERBOSE", "DEBUG", "INFO", "WARN", "ERROR", "com.google.firebase-firebase-common"})
    public static final class Level
    extends Enum<Level> {
        private final int priority;
        public static final /* enum */ Level VERBOSE = new Level(2);
        public static final /* enum */ Level DEBUG = new Level(3);
        public static final /* enum */ Level INFO = new Level(4);
        public static final /* enum */ Level WARN = new Level(5);
        public static final /* enum */ Level ERROR = new Level(6);
        private static final /* synthetic */ Level[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Level(int priority) {
            this.priority = priority;
        }

        public final int getPriority$com_google_firebase_firebase_common() {
            return this.priority;
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String value) {
            return Enum.valueOf(Level.class, value);
        }

        @NotNull
        public static EnumEntries<Level> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = levelArray = new Level[]{Level.VERBOSE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

