/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.ndk;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.NativeSessionFileProvider;
import com.google.firebase.crashlytics.ndk.BreakpadController;
import com.google.firebase.crashlytics.ndk.JniNativeApi;
import com.google.firebase.crashlytics.ndk.NativeComponentController;
import com.google.firebase.crashlytics.ndk.NdkCrashFilesManager;
import com.google.firebase.crashlytics.ndk.SessionFilesProvider;
import java.io.File;

class FirebaseCrashlyticsNdk
implements CrashlyticsNativeComponent {
    private static final String FILES_PATH = ".com.google.firebase.crashlytics-ndk";
    private final NativeComponentController controller;

    static FirebaseCrashlyticsNdk create(@NonNull Context context) {
        File rootDir = new File(context.getFilesDir(), FILES_PATH);
        BreakpadController controller = new BreakpadController(context, new JniNativeApi(), new NdkCrashFilesManager(rootDir));
        return new FirebaseCrashlyticsNdk(controller);
    }

    FirebaseCrashlyticsNdk(@NonNull NativeComponentController controller) {
        this.controller = controller;
    }

    public boolean hasCrashDataForSession(@NonNull String sessionId) {
        return this.controller.hasCrashDataForSession(sessionId);
    }

    public boolean openSession(String sessionId) {
        boolean initSuccess = this.controller.initialize(sessionId);
        Logger.getLogger().i("Crashlytics NDK initialization " + (initSuccess ? "successful" : "FAILED"));
        return initSuccess;
    }

    public boolean finalizeSession(@NonNull String sessionId) {
        return this.controller.finalizeSession(sessionId);
    }

    @NonNull
    public NativeSessionFileProvider getSessionFileProvider(@NonNull String sessionId) {
        return new SessionFilesProvider(this.controller.getFilesForSession(sessionId));
    }

    public void writeBeginSession(@NonNull String sessionId, @NonNull String generator, long startedAtSeconds) {
        this.controller.writeBeginSession(sessionId, generator, startedAtSeconds);
    }

    public void writeSessionApp(@NonNull String sessionId, @NonNull String appIdentifier, @NonNull String versionCode, @NonNull String versionName, @NonNull String installUuid, int deliveryMechanism, @NonNull String unityVersion) {
        this.controller.writeSessionApp(sessionId, appIdentifier, versionCode, versionName, installUuid, deliveryMechanism, unityVersion);
    }

    public void writeSessionOs(@NonNull String sessionId, @NonNull String osRelease, @NonNull String osCodeName, boolean isRooted) {
        this.controller.writeSessionOs(sessionId, osRelease, osCodeName, isRooted);
    }

    public void writeSessionDevice(@NonNull String sessionId, int arch, @NonNull String model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, int state, @NonNull String manufacturer, @NonNull String modelClass) {
        this.controller.writeSessionDevice(sessionId, arch, model, availableProcessors, totalRam, diskSpace, isEmulator, state, manufacturer, modelClass);
    }
}

