/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.ndk;

import android.content.res.AssetManager;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.ndk.NativeApi;

class JniNativeApi
implements NativeApi {
    private static final boolean LIB_CRASHLYTICS_LOADED;

    JniNativeApi() {
    }

    @Override
    public boolean initialize(String dataPath, AssetManager assetManager) {
        return LIB_CRASHLYTICS_LOADED && this.nativeInit(dataPath, assetManager);
    }

    private native boolean nativeInit(String var1, Object var2);

    static {
        boolean loadSuccessful = false;
        try {
            System.loadLibrary("crashlytics");
            loadSuccessful = true;
        }
        catch (UnsatisfiedLinkError e) {
            Logger.getLogger().e("libcrashlytics could not be loaded. This APK may not have been compiled for this device's architecture. NDK crashes will not be reported to Crashlytics:\n" + e.getLocalizedMessage());
        }
        LIB_CRASHLYTICS_LOADED = loadSuccessful;
    }
}

