/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.ndk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.ndk.CrashFilesManager;
import java.io.File;

class NdkCrashFilesManager
implements CrashFilesManager {
    private final File rootPath;

    NdkCrashFilesManager(File rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public boolean hasSessionFileDirectory(String sessionId) {
        return new File(this.rootPath, sessionId).exists();
    }

    @Override
    public File getSessionFileDirectory(String sessionId) {
        return NdkCrashFilesManager.prepareDirectory(new File(this.rootPath, sessionId));
    }

    @Override
    public void deleteSessionFilesDirectory(String sessionId) {
        NdkCrashFilesManager.recursiveDelete(new File(this.rootPath, sessionId));
    }

    @Nullable
    private static File prepareDirectory(File file) {
        if (file != null && (file.exists() || file.mkdirs())) {
            return file;
        }
        return null;
    }

    private static void recursiveDelete(@NonNull File f) {
        if (f.isDirectory()) {
            for (File s : f.listFiles()) {
                NdkCrashFilesManager.recursiveDelete(s);
            }
        }
        f.delete();
    }
}

