/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.ndk;

import java.util.HashMap;
import org.json.JSONObject;

class SessionMetadataJsonSerializer {
    private SessionMetadataJsonSerializer() {
    }

    static String serializeBeginSession(String sessionId, String generator, long startedAtSeconds) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("session_id", sessionId);
        data.put("generator", generator);
        data.put("started_at_seconds", startedAtSeconds);
        return new JSONObject(data).toString();
    }

    static String serializeSessionApp(String appIdentifier, String versionCode, String versionName, String installUuid, int deliveryMechanism, String unityVersion) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("app_identifier", appIdentifier);
        data.put("version_code", versionCode);
        data.put("version_name", versionName);
        data.put("install_uuid", installUuid);
        data.put("delivery_mechanism", deliveryMechanism);
        data.put("unity_version", unityVersion);
        return new JSONObject(data).toString();
    }

    static String serializeSessionOs(String osRelease, String osCodeName, boolean isRooted) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("version", osRelease);
        data.put("build_version", osCodeName);
        data.put("is_rooted", isRooted);
        return new JSONObject(data).toString();
    }

    static String serializeSessionDevice(int arch, String model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, int state, String manufacturer, String modelClass) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("arch", arch);
        data.put("build_model", model);
        data.put("available_processors", availableProcessors);
        data.put("total_ram", totalRam);
        data.put("disk_space", diskSpace);
        data.put("is_emulator", isEmulator);
        data.put("state", state);
        data.put("build_manufacturer", manufacturer);
        data.put("build_product", modelClass);
        return new JSONObject(data).toString();
    }
}

