/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.ndk;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.ndk.CrashFilesManager;
import com.google.firebase.crashlytics.ndk.NativeApi;
import com.google.firebase.crashlytics.ndk.NativeComponentController;
import com.google.firebase.crashlytics.ndk.SessionFiles;
import com.google.firebase.crashlytics.ndk.SessionMetadataJsonSerializer;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

class BreakpadController
implements NativeComponentController {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String SESSION_METADATA_FILE = "session.json";
    private static final String APP_METADATA_FILE = "app.json";
    private static final String DEVICE_METADATA_FILE = "device.json";
    private static final String OS_METADATA_FILE = "os.json";
    private final Context context;
    private final NativeApi nativeApi;
    private final CrashFilesManager filesManager;

    BreakpadController(Context context, NativeApi nativeApi, CrashFilesManager filesManager) {
        this.context = context;
        this.nativeApi = nativeApi;
        this.filesManager = filesManager;
    }

    @Override
    public boolean initialize(String sessionId) {
        boolean initSuccess = false;
        File crashReportDirectory = this.filesManager.getSessionFileDirectory(sessionId);
        try {
            if (crashReportDirectory != null) {
                String crashReportPath = crashReportDirectory.getCanonicalPath();
                initSuccess = this.nativeApi.initialize(crashReportPath, this.context.getAssets());
            }
        }
        catch (IOException e) {
            Logger.getLogger().e("Error initializing CrashlyticsNdk", (Throwable)e);
        }
        return initSuccess;
    }

    @Override
    public boolean hasCrashDataForSession(String sessionId) {
        if (this.filesManager.hasSessionFileDirectory(sessionId)) {
            File crashFile = this.getFilesForSession((String)sessionId).minidump;
            return crashFile != null && crashFile.exists();
        }
        return false;
    }

    @Override
    public boolean finalizeSession(String sessionId) {
        this.filesManager.deleteSessionFilesDirectory(sessionId);
        return true;
    }

    @Override
    @NonNull
    public SessionFiles getFilesForSession(String sessionId) {
        File sessionFileDirectory = this.filesManager.getSessionFileDirectory(sessionId);
        File sessionFileDirectoryForMinidump = new File(sessionFileDirectory, "pending");
        Logger.getLogger().d("Minidump directory: " + sessionFileDirectoryForMinidump.getAbsolutePath());
        File minidump = BreakpadController.getSingleFileWithExtension(sessionFileDirectoryForMinidump, ".dmp");
        Logger.getLogger().d("Minidump " + (minidump != null && minidump.exists() ? "exists" : "does not exist"));
        SessionFiles.Builder builder = new SessionFiles.Builder();
        if (sessionFileDirectory != null && sessionFileDirectory.exists() && sessionFileDirectoryForMinidump.exists()) {
            builder.minidumpFile(BreakpadController.getSingleFileWithExtension(sessionFileDirectoryForMinidump, ".dmp")).metadataFile(BreakpadController.getSingleFileWithExtension(sessionFileDirectory, ".device_info")).sessionFile(new File(sessionFileDirectory, SESSION_METADATA_FILE)).appFile(new File(sessionFileDirectory, APP_METADATA_FILE)).deviceFile(new File(sessionFileDirectory, DEVICE_METADATA_FILE)).osFile(new File(sessionFileDirectory, OS_METADATA_FILE));
        }
        return builder.build();
    }

    @Override
    public void writeBeginSession(String sessionId, String generator, long startedAtSeconds) {
        String json = SessionMetadataJsonSerializer.serializeBeginSession(sessionId, generator, startedAtSeconds);
        this.writeSessionJsonFile(sessionId, json, SESSION_METADATA_FILE);
    }

    @Override
    public void writeSessionApp(String sessionId, String appIdentifier, String versionCode, String versionName, String installUuid, int deliveryMechanism, String unityVersion) {
        unityVersion = !TextUtils.isEmpty((CharSequence)unityVersion) ? unityVersion : "";
        String json = SessionMetadataJsonSerializer.serializeSessionApp(appIdentifier, versionCode, versionName, installUuid, deliveryMechanism, unityVersion);
        this.writeSessionJsonFile(sessionId, json, APP_METADATA_FILE);
    }

    @Override
    public void writeSessionOs(String sessionId, String osRelease, String osCodeName, boolean isRooted) {
        String json = SessionMetadataJsonSerializer.serializeSessionOs(osRelease, osCodeName, isRooted);
        this.writeSessionJsonFile(sessionId, json, OS_METADATA_FILE);
    }

    @Override
    public void writeSessionDevice(String sessionId, int arch, String model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, int state, String manufacturer, String modelClass) {
        String json = SessionMetadataJsonSerializer.serializeSessionDevice(arch, model, availableProcessors, totalRam, diskSpace, isEmulator, state, manufacturer, modelClass);
        this.writeSessionJsonFile(sessionId, json, DEVICE_METADATA_FILE);
    }

    private void writeSessionJsonFile(String sessionId, String json, String fileName) {
        File sessionDirectory = this.filesManager.getSessionFileDirectory(sessionId);
        File jsonFile = new File(sessionDirectory, fileName);
        BreakpadController.writeTextFile(jsonFile, json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTextFile(File file, String text) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8));
            writer.write(text);
        }
        catch (IOException iOException) {
        }
        finally {
            CommonUtils.closeOrLog((Closeable)writer, (String)("Failed to close " + file));
        }
    }

    @Nullable
    private static File getSingleFileWithExtension(File directory, String extension) {
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!file.getName().endsWith(extension)) continue;
            return file;
        }
        return null;
    }
}

