/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.ndk;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.NativeSessionFileProvider;
import com.google.firebase.crashlytics.internal.model.StaticSessionData;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.ndk.CrashpadController;
import com.google.firebase.crashlytics.ndk.JniNativeApi;
import com.google.firebase.crashlytics.ndk.SessionFilesProvider;

class FirebaseCrashlyticsNdk
implements CrashlyticsNativeComponent {
    private static FirebaseCrashlyticsNdk instance;
    private final CrashpadController controller;
    private boolean installHandlerDuringPrepareSession;
    private String currentSessionId;
    private SignalHandlerInstaller signalHandlerInstaller;

    static FirebaseCrashlyticsNdk create(@NonNull Context context, boolean installHandlerDuringPrepareSession) {
        CrashpadController controller = new CrashpadController(context, new JniNativeApi(context), new FileStore(context));
        instance = new FirebaseCrashlyticsNdk(controller, installHandlerDuringPrepareSession);
        return instance;
    }

    FirebaseCrashlyticsNdk(@NonNull CrashpadController controller, boolean installHandlerDuringPrepareSession) {
        this.controller = controller;
        this.installHandlerDuringPrepareSession = installHandlerDuringPrepareSession;
    }

    public boolean hasCrashDataForCurrentSession() {
        return this.currentSessionId != null && this.hasCrashDataForSession(this.currentSessionId);
    }

    public boolean hasCrashDataForSession(@NonNull String sessionId) {
        return this.controller.hasCrashDataForSession(sessionId);
    }

    public synchronized void prepareNativeSession(@NonNull String sessionId, @NonNull String generator, long startedAtSeconds, @NonNull StaticSessionData sessionData) {
        this.currentSessionId = sessionId;
        this.signalHandlerInstaller = () -> {
            Logger.getLogger().d("Initializing native session: " + sessionId);
            if (!this.controller.initialize(sessionId, generator, startedAtSeconds, sessionData)) {
                Logger.getLogger().w("Failed to initialize Crashlytics NDK for session " + sessionId);
            }
        };
        if (this.installHandlerDuringPrepareSession) {
            this.signalHandlerInstaller.installHandler();
        }
    }

    @NonNull
    public NativeSessionFileProvider getSessionFileProvider(@NonNull String sessionId) {
        return new SessionFilesProvider(this.controller.getFilesForSession(sessionId));
    }

    public synchronized void installSignalHandler() {
        if (this.signalHandlerInstaller != null) {
            this.signalHandlerInstaller.installHandler();
            return;
        }
        if (this.installHandlerDuringPrepareSession) {
            Logger.getLogger().w("Native signal handler already installed; skipping re-install.");
        } else {
            Logger.getLogger().d("Deferring signal handler installation until the FirebaseCrashlyticsNdk session has been prepared");
            this.installHandlerDuringPrepareSession = true;
        }
    }

    @NonNull
    public static FirebaseCrashlyticsNdk getInstance() {
        if (instance == null) {
            throw new NullPointerException("FirebaseCrashlyticsNdk component is not present.");
        }
        return instance;
    }

    private static interface SignalHandlerInstaller {
        public void installHandler();
    }
}

