/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.google.firebase.crashlytics.internal.DevelopmentPlatformProvider;
import com.google.firebase.crashlytics.internal.common.BuildIdInfo;
import com.google.firebase.crashlytics.internal.common.IdManager;
import java.util.List;

public class AppData {
    public final String googleAppId;
    public final String buildId;
    public final List<BuildIdInfo> buildIdInfoList;
    public final String installerPackageName;
    public final String packageName;
    public final String versionCode;
    public final String versionName;
    public final DevelopmentPlatformProvider developmentPlatformProvider;

    public static AppData create(Context context, IdManager idManager, String googleAppId, String buildId, List<BuildIdInfo> buildIdInfoList, DevelopmentPlatformProvider developmentPlatformProvider) throws PackageManager.NameNotFoundException {
        String packageName = context.getPackageName();
        String installerPackageName = idManager.getInstallerPackageName();
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
        String versionCode = AppData.getAppBuildVersion(packageInfo);
        String versionName = packageInfo.versionName == null ? "0.0" : packageInfo.versionName;
        return new AppData(googleAppId, buildId, buildIdInfoList, installerPackageName, packageName, versionCode, versionName, developmentPlatformProvider);
    }

    private static String getAppBuildVersion(PackageInfo packageInfo) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Long.toString(packageInfo.getLongVersionCode());
        }
        return Integer.toString(packageInfo.versionCode);
    }

    public AppData(String googleAppId, String buildId, List<BuildIdInfo> buildIdInfoList, String installerPackageName, String packageName, String versionCode, String versionName, DevelopmentPlatformProvider developmentPlatformProvider) {
        this.googleAppId = googleAppId;
        this.buildId = buildId;
        this.buildIdInfoList = buildIdInfoList;
        this.installerPackageName = installerPackageName;
        this.packageName = packageName;
        this.versionCode = versionCode;
        this.versionName = versionName;
        this.developmentPlatformProvider = developmentPlatformProvider;
    }
}

