/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.File;
import java.io.IOException;

class CrashlyticsFileMarker {
    private final String markerName;
    private final FileStore fileStore;

    public CrashlyticsFileMarker(String markerName, FileStore fileStore) {
        this.markerName = markerName;
        this.fileStore = fileStore;
    }

    public boolean create() {
        boolean wasCreated = false;
        try {
            wasCreated = this.getMarkerFile().createNewFile();
        }
        catch (IOException e) {
            Logger.getLogger().e("Error creating marker: " + this.markerName, e);
        }
        return wasCreated;
    }

    public boolean isPresent() {
        return this.getMarkerFile().exists();
    }

    public boolean remove() {
        return this.getMarkerFile().delete();
    }

    private File getMarkerFile() {
        return this.fileStore.getCommonFile(this.markerName);
    }
}

