/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.concurrency;

import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CrashlyticsWorker
implements Executor {
    private final ExecutorService executor;
    private final Object tailLock = new Object();
    private Task<?> tail = Tasks.forResult(null);

    CrashlyticsWorker(ExecutorService executor) {
        this.executor = executor;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    public <T> Task<T> submit(Callable<T> callable) {
        Object object = this.tailLock;
        synchronized (object) {
            Task result;
            this.tail = result = this.tail.continueWithTask((Executor)this.executor, task -> Tasks.forResult(callable.call()));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    public Task<Void> submit(Runnable runnable) {
        Object object = this.tailLock;
        synchronized (object) {
            Task result;
            this.tail = result = this.tail.continueWithTask((Executor)this.executor, task -> {
                runnable.run();
                return Tasks.forResult(null);
            });
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    public <T> Task<T> submitTask(Callable<Task<T>> callable) {
        Object object = this.tailLock;
        synchronized (object) {
            Task result;
            this.tail = result = this.tail.continueWithTask((Executor)this.executor, task -> (Task)callable.call());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    public <T, R> Task<R> submitTask(Callable<Task<T>> callable, Continuation<T, Task<R>> continuation) {
        Object object = this.tailLock;
        synchronized (object) {
            Task result;
            this.tail = result = this.tail.continueWithTask((Executor)this.executor, task -> (Task)callable.call()).continueWithTask((Executor)this.executor, continuation);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    public <T, R> Task<R> submitTaskOnSuccess(Callable<Task<T>> callable, SuccessContinuation<T, R> successContinuation) {
        Object object = this.tailLock;
        synchronized (object) {
            Task result;
            this.tail = result = this.tail.continueWithTask((Executor)this.executor, task -> (Task)callable.call()).continueWithTask((Executor)this.executor, task -> {
                if (task.isSuccessful()) {
                    return successContinuation.then(task.getResult());
                }
                if (task.getException() != null) {
                    return Tasks.forException((Exception)task.getException());
                }
                return Tasks.forCanceled();
            });
            return result;
        }
    }

    @Override
    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @VisibleForTesting
    public void await() throws ExecutionException, InterruptedException, TimeoutException {
        Tasks.await(this.submit(() -> {}), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        Thread.sleep(1L);
    }
}

