/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.concurrency;

import android.os.Build;
import android.os.Looper;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorker;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/firebase/crashlytics/internal/concurrency/CrashlyticsWorkers;", "", "backgroundExecutorService", "Ljava/util/concurrent/ExecutorService;", "blockingExecutorService", "<init>", "(Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;)V", "common", "Lcom/google/firebase/crashlytics/internal/concurrency/CrashlyticsWorker;", "diskWrite", "dataCollect", "network", "Companion", "com.google.firebase-firebase-crashlytics"})
public final class CrashlyticsWorkers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final CrashlyticsWorker common;
    @JvmField
    @NotNull
    public final CrashlyticsWorker diskWrite;
    @JvmField
    @NotNull
    public final CrashlyticsWorker dataCollect;
    @JvmField
    @NotNull
    public final CrashlyticsWorker network;
    private static boolean enforcement;

    public CrashlyticsWorkers(@NotNull ExecutorService backgroundExecutorService, @NotNull ExecutorService blockingExecutorService) {
        Intrinsics.checkNotNullParameter((Object)backgroundExecutorService, (String)"backgroundExecutorService");
        Intrinsics.checkNotNullParameter((Object)blockingExecutorService, (String)"blockingExecutorService");
        this.common = new CrashlyticsWorker(backgroundExecutorService);
        this.diskWrite = new CrashlyticsWorker(backgroundExecutorService);
        this.dataCollect = new CrashlyticsWorker(backgroundExecutorService);
        this.network = new CrashlyticsWorker(blockingExecutorService);
    }

    public static final boolean getEnforcement() {
        return Companion.getEnforcement();
    }

    public static final void setEnforcement(boolean bl) {
        Companion.setEnforcement(bl);
    }

    @JvmStatic
    public static final void checkNotMainThread() {
        Companion.checkNotMainThread();
    }

    @JvmStatic
    public static final void checkBlockingThread() {
        Companion.checkBlockingThread();
    }

    @JvmStatic
    public static final void checkBackgroundThread() {
        Companion.checkBackgroundThread();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0011H\u0007J\b\u0010\u0013\u001a\u00020\u0011H\u0007J\b\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\b\u0010\u0016\u001a\u00020\nH\u0002J$\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/google/firebase/crashlytics/internal/concurrency/CrashlyticsWorkers$Companion;", "", "<init>", "()V", "threadName", "", "kotlin.jvm.PlatformType", "getThreadName", "()Ljava/lang/String;", "enforcement", "", "getEnforcement$annotations", "getEnforcement", "()Z", "setEnforcement", "(Z)V", "checkNotMainThread", "", "checkBlockingThread", "checkBackgroundThread", "isNotMainThread", "isBlockingThread", "isBackgroundThread", "checkThread", "isCorrectThread", "Lkotlin/Function0;", "failureMessage", "com.google.firebase-firebase-crashlytics"})
    public static final class Companion {
        private Companion() {
        }

        private final String getThreadName() {
            return Thread.currentThread().getName();
        }

        public final boolean getEnforcement() {
            return enforcement;
        }

        public final void setEnforcement(boolean bl) {
            enforcement = bl;
        }

        @JvmStatic
        public static /* synthetic */ void getEnforcement$annotations() {
        }

        @JvmStatic
        public final void checkNotMainThread() {
            this.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                public final Boolean invoke() {
                    return com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers$Companion.access$isNotMainThread((Companion)this.receiver);
                }
            }), (Function0<String>)((Function0)Companion::checkNotMainThread$lambda$0));
        }

        @JvmStatic
        public final void checkBlockingThread() {
            this.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                public final Boolean invoke() {
                    return com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers$Companion.access$isBlockingThread((Companion)this.receiver);
                }
            }), (Function0<String>)((Function0)Companion::checkBlockingThread$lambda$1));
        }

        @JvmStatic
        public final void checkBackgroundThread() {
            this.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                public final Boolean invoke() {
                    return com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers$Companion.access$isBackgroundThread((Companion)this.receiver);
                }
            }), (Function0<String>)((Function0)Companion::checkBackgroundThread$lambda$2));
        }

        private final boolean isNotMainThread() {
            return Build.VERSION.SDK_INT >= 23 ? !Looper.getMainLooper().isCurrentThread() : !Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper());
        }

        private final boolean isBlockingThread() {
            String string = this.getThreadName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-threadName>(...)");
            return StringsKt.contains$default((CharSequence)string, (CharSequence)"Firebase Blocking Thread #", (boolean)false, (int)2, null);
        }

        private final boolean isBackgroundThread() {
            String string = this.getThreadName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-threadName>(...)");
            return StringsKt.contains$default((CharSequence)string, (CharSequence)"Firebase Background Thread #", (boolean)false, (int)2, null);
        }

        private final void checkThread(Function0<Boolean> isCorrectThread, Function0<String> failureMessage) {
            if (!((Boolean)isCorrectThread.invoke()).booleanValue()) {
                boolean bl;
                Logger.getLogger().d((String)failureMessage.invoke());
                boolean bl2 = bl = !this.getEnforcement();
                if (_Assertions.ENABLED && !bl) {
                    Object object = failureMessage.invoke();
                    throw new AssertionError(object);
                }
            }
        }

        private static final String checkNotMainThread$lambda$0() {
            return "Must not be called on a main thread, was called on " + Companion.getThreadName() + '.';
        }

        private static final String checkBlockingThread$lambda$1() {
            return "Must be called on a blocking thread, was called on " + Companion.getThreadName() + '.';
        }

        private static final String checkBackgroundThread$lambda$2() {
            return "Must be called on a background thread, was called on " + Companion.getThreadName() + '.';
        }

        public static final /* synthetic */ boolean access$isNotMainThread(Companion $this) {
            return $this.isNotMainThread();
        }

        public static final /* synthetic */ boolean access$isBlockingThread(Companion $this) {
            return $this.isBlockingThread();
        }

        public static final /* synthetic */ boolean access$isBackgroundThread(Companion $this) {
            return $this.isBackgroundThread();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

