/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.internal.ShortDynamicLinkImplCreator;
import com.google.firebase.dynamiclinks.internal.WarningImplCreator;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Class(creator="ShortDynamicLinkImplCreator")
public final class ShortDynamicLinkImpl
extends AbstractSafeParcelable
implements ShortDynamicLink {
    public static final Parcelable.Creator<ShortDynamicLinkImpl> CREATOR = new ShortDynamicLinkImplCreator();
    @SafeParcelable.Field(id=1, getter="getShortLink")
    @Nullable
    private final Uri shortLink;
    @SafeParcelable.Field(id=2, getter="getPreviewLink")
    @Nullable
    private final Uri previewLink;
    @SafeParcelable.Field(id=3, getter="getWarnings")
    private final List<WarningImpl> warnings;

    @SafeParcelable.Constructor
    public ShortDynamicLinkImpl(@Nullable @SafeParcelable.Param(id=1) Uri shortLink, @Nullable @SafeParcelable.Param(id=2) Uri previewLink, @Nullable @SafeParcelable.Param(id=3) List<WarningImpl> warnings) {
        this.shortLink = shortLink;
        this.previewLink = previewLink;
        this.warnings = warnings == null ? new ArrayList() : warnings;
    }

    @Override
    @Nullable
    public Uri getShortLink() {
        return this.shortLink;
    }

    @Override
    @Nullable
    public Uri getPreviewLink() {
        return this.previewLink;
    }

    public List<WarningImpl> getWarnings() {
        return this.warnings;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ShortDynamicLinkImplCreator.writeToParcel(this, dest, flags);
    }

    @SafeParcelable.Class(creator="WarningImplCreator")
    public static class WarningImpl
    extends AbstractSafeParcelable
    implements ShortDynamicLink.Warning {
        public static final Parcelable.Creator<WarningImpl> CREATOR = new WarningImplCreator();
        @SafeParcelable.Reserved(value={1})
        @SafeParcelable.Field(id=2, getter="getMessage")
        private final String message;

        @SafeParcelable.Constructor
        public WarningImpl(@SafeParcelable.Param(id=2) String message) {
            this.message = message;
        }

        @Override
        @Nullable
        public String getCode() {
            return null;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void writeToParcel(Parcel dest, int flags) {
            WarningImplCreator.writeToParcel(this, dest, flags);
        }
    }
}

