/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.firestore.AggregateField;
import com.google.firebase.firestore.AggregateQuery;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.Filter;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenSource;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.SnapshotListenOptions;
import com.google.firebase.firestore.Source;
import com.google.firebase.firestore.core.ActivityScope;
import com.google.firebase.firestore.core.AsyncEventListener;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.CompositeFilter;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.QueryListener;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.ServerTimestamps;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firebase.firestore.util.Util;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

public class Query {
    final com.google.firebase.firestore.core.Query query;
    final FirebaseFirestore firestore;

    Query(com.google.firebase.firestore.core.Query query, FirebaseFirestore firestore) {
        this.query = Preconditions.checkNotNull(query);
        this.firestore = Preconditions.checkNotNull(firestore);
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.firestore;
    }

    @NonNull
    public Query whereEqualTo(@NonNull String field, @Nullable Object value) {
        return this.where(Filter.equalTo(field, value));
    }

    @NonNull
    public Query whereEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return this.where(Filter.equalTo(fieldPath, value));
    }

    @NonNull
    public Query whereNotEqualTo(@NonNull String field, @Nullable Object value) {
        return this.where(Filter.notEqualTo(field, value));
    }

    @NonNull
    public Query whereNotEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return this.where(Filter.notEqualTo(fieldPath, value));
    }

    @NonNull
    public Query whereLessThan(@NonNull String field, @NonNull Object value) {
        return this.where(Filter.lessThan(field, value));
    }

    @NonNull
    public Query whereLessThan(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.where(Filter.lessThan(fieldPath, value));
    }

    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull String field, @NonNull Object value) {
        return this.where(Filter.lessThanOrEqualTo(field, value));
    }

    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.where(Filter.lessThanOrEqualTo(fieldPath, value));
    }

    @NonNull
    public Query whereGreaterThan(@NonNull String field, @NonNull Object value) {
        return this.where(Filter.greaterThan(field, value));
    }

    @NonNull
    public Query whereGreaterThan(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.where(Filter.greaterThan(fieldPath, value));
    }

    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull String field, @NonNull Object value) {
        return this.where(Filter.greaterThanOrEqualTo(field, value));
    }

    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.where(Filter.greaterThanOrEqualTo(fieldPath, value));
    }

    @NonNull
    public Query whereArrayContains(@NonNull String field, @NonNull Object value) {
        return this.where(Filter.arrayContains(field, value));
    }

    @NonNull
    public Query whereArrayContains(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.where(Filter.arrayContains(fieldPath, value));
    }

    @NonNull
    public Query whereArrayContainsAny(@NonNull String field, @NonNull List<? extends Object> values) {
        return this.where(Filter.arrayContainsAny(field, values));
    }

    @NonNull
    public Query whereArrayContainsAny(@NonNull FieldPath fieldPath, @NonNull List<? extends Object> values) {
        return this.where(Filter.arrayContainsAny(fieldPath, values));
    }

    @NonNull
    public Query whereIn(@NonNull String field, @NonNull List<? extends Object> values) {
        return this.where(Filter.inArray(field, values));
    }

    @NonNull
    public Query whereIn(@NonNull FieldPath fieldPath, @NonNull List<? extends Object> values) {
        return this.where(Filter.inArray(fieldPath, values));
    }

    @NonNull
    public Query whereNotIn(@NonNull String field, @NonNull List<? extends Object> values) {
        return this.where(Filter.notInArray(field, values));
    }

    @NonNull
    public Query whereNotIn(@NonNull FieldPath fieldPath, @NonNull List<? extends Object> values) {
        return this.where(Filter.notInArray(fieldPath, values));
    }

    @NonNull
    public Query where(@NonNull Filter filter) {
        com.google.firebase.firestore.core.Filter parsedFilter = this.parseFilter(filter);
        if (parsedFilter.getFilters().isEmpty()) {
            return this;
        }
        this.validateNewFilter(parsedFilter);
        return new Query(this.query.filter(parsedFilter), this.firestore);
    }

    private FieldFilter parseFieldFilter(Filter.UnaryFilter fieldFilterData) {
        Value fieldValue;
        FieldPath fieldPath = fieldFilterData.getField();
        FieldFilter.Operator op = fieldFilterData.getOperator();
        Object value = fieldFilterData.getValue();
        Preconditions.checkNotNull(fieldPath, "Provided field path must not be null.");
        Preconditions.checkNotNull(op, "Provided op must not be null.");
        com.google.firebase.firestore.model.FieldPath internalPath = fieldPath.getInternalPath();
        if (internalPath.isKeyField()) {
            if (op == FieldFilter.Operator.ARRAY_CONTAINS || op == FieldFilter.Operator.ARRAY_CONTAINS_ANY) {
                throw new IllegalArgumentException("Invalid query. You can't perform '" + op.toString() + "' queries on FieldPath.documentId().");
            }
            if (op == FieldFilter.Operator.IN || op == FieldFilter.Operator.NOT_IN) {
                this.validateDisjunctiveFilterElements(value, op);
                ArrayValue.Builder referenceList = ArrayValue.newBuilder();
                for (Object arrayValue : (List)value) {
                    referenceList.addValues(this.parseDocumentIdValue(arrayValue));
                }
                fieldValue = (Value)Value.newBuilder().setArrayValue(referenceList).build();
            } else {
                fieldValue = this.parseDocumentIdValue(value);
            }
        } else {
            if (op == FieldFilter.Operator.IN || op == FieldFilter.Operator.NOT_IN || op == FieldFilter.Operator.ARRAY_CONTAINS_ANY) {
                this.validateDisjunctiveFilterElements(value, op);
            }
            fieldValue = this.firestore.getUserDataReader().parseQueryValue(value, op == FieldFilter.Operator.IN || op == FieldFilter.Operator.NOT_IN);
        }
        FieldFilter filter = FieldFilter.create(fieldPath.getInternalPath(), op, fieldValue);
        return filter;
    }

    private com.google.firebase.firestore.core.Filter parseCompositeFilter(Filter.CompositeFilter compositeFilterData) {
        ArrayList<com.google.firebase.firestore.core.Filter> parsedFilters = new ArrayList<com.google.firebase.firestore.core.Filter>();
        for (Filter filter : compositeFilterData.getFilters()) {
            com.google.firebase.firestore.core.Filter parsedFilter = this.parseFilter(filter);
            if (parsedFilter.getFilters().isEmpty()) continue;
            parsedFilters.add(parsedFilter);
        }
        if (parsedFilters.size() == 1) {
            return (com.google.firebase.firestore.core.Filter)parsedFilters.get(0);
        }
        return new CompositeFilter(parsedFilters, compositeFilterData.getOperator());
    }

    private com.google.firebase.firestore.core.Filter parseFilter(Filter filter) {
        Assert.hardAssert(filter instanceof Filter.UnaryFilter || filter instanceof Filter.CompositeFilter, "Parsing is only supported for Filter.UnaryFilter and Filter.CompositeFilter.", new Object[0]);
        if (filter instanceof Filter.UnaryFilter) {
            return this.parseFieldFilter((Filter.UnaryFilter)filter);
        }
        return this.parseCompositeFilter((Filter.CompositeFilter)filter);
    }

    private Value parseDocumentIdValue(Object documentIdValue) {
        if (documentIdValue instanceof String) {
            String documentId = (String)documentIdValue;
            if (documentId.isEmpty()) {
                throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but it was an empty string.");
            }
            if (!this.query.isCollectionGroupQuery() && documentId.contains("/")) {
                throw new IllegalArgumentException("Invalid query. When querying a collection by FieldPath.documentId() you must provide a plain document ID, but '" + documentId + "' contains a '/' character.");
            }
            ResourcePath path = this.query.getPath().append(ResourcePath.fromString(documentId));
            if (!DocumentKey.isDocumentKey(path)) {
                throw new IllegalArgumentException("Invalid query. When querying a collection group by FieldPath.documentId(), the value provided must result in a valid document path, but '" + path + "' is not because it has an odd number of segments (" + path.length() + ").");
            }
            return Values.refValue(this.getFirestore().getDatabaseId(), DocumentKey.fromPath(path));
        }
        if (documentIdValue instanceof DocumentReference) {
            DocumentReference ref = (DocumentReference)documentIdValue;
            return Values.refValue(this.getFirestore().getDatabaseId(), ref.getKey());
        }
        throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: " + Util.typeName(documentIdValue));
    }

    private void validateDisjunctiveFilterElements(Object value, FieldFilter.Operator op) {
        if (!(value instanceof List) || ((List)value).size() == 0) {
            throw new IllegalArgumentException("Invalid Query. A non-empty array is required for '" + op.toString() + "' filters.");
        }
    }

    private List<FieldFilter.Operator> conflictingOps(FieldFilter.Operator op) {
        switch (op) {
            case NOT_EQUAL: {
                return Arrays.asList(FieldFilter.Operator.NOT_EQUAL, FieldFilter.Operator.NOT_IN);
            }
            case ARRAY_CONTAINS_ANY: 
            case IN: {
                return Arrays.asList(FieldFilter.Operator.NOT_IN);
            }
            case NOT_IN: {
                return Arrays.asList(FieldFilter.Operator.ARRAY_CONTAINS_ANY, FieldFilter.Operator.IN, FieldFilter.Operator.NOT_IN, FieldFilter.Operator.NOT_EQUAL);
            }
        }
        return new ArrayList<FieldFilter.Operator>();
    }

    private void validateNewFieldFilter(com.google.firebase.firestore.core.Query query, FieldFilter fieldFilter) {
        FieldFilter.Operator filterOp = fieldFilter.getOperator();
        FieldFilter.Operator conflictingOp = this.findOpInsideFilters(query.getFilters(), this.conflictingOps(filterOp));
        if (conflictingOp != null) {
            if (conflictingOp == filterOp) {
                throw new IllegalArgumentException("Invalid Query. You cannot use more than one '" + filterOp.toString() + "' filter.");
            }
            throw new IllegalArgumentException("Invalid Query. You cannot use '" + filterOp.toString() + "' filters with '" + conflictingOp.toString() + "' filters.");
        }
    }

    private void validateNewFilter(com.google.firebase.firestore.core.Filter filter) {
        com.google.firebase.firestore.core.Query testQuery = this.query;
        for (FieldFilter subfilter : filter.getFlattenedFilters()) {
            this.validateNewFieldFilter(testQuery, subfilter);
            testQuery = testQuery.filter(subfilter);
        }
    }

    @Nullable
    private FieldFilter.Operator findOpInsideFilters(List<com.google.firebase.firestore.core.Filter> filters, List<FieldFilter.Operator> operators) {
        for (com.google.firebase.firestore.core.Filter filter : filters) {
            for (FieldFilter fieldFilter : filter.getFlattenedFilters()) {
                if (!operators.contains((Object)fieldFilter.getOperator())) continue;
                return fieldFilter.getOperator();
            }
        }
        return null;
    }

    @NonNull
    public Query orderBy(@NonNull String field) {
        return this.orderBy(FieldPath.fromDotSeparatedPath(field), Direction.ASCENDING);
    }

    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath) {
        Preconditions.checkNotNull(fieldPath, "Provided field path must not be null.");
        return this.orderBy(fieldPath.getInternalPath(), Direction.ASCENDING);
    }

    @NonNull
    public Query orderBy(@NonNull String field, @NonNull Direction direction) {
        return this.orderBy(FieldPath.fromDotSeparatedPath(field), direction);
    }

    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath, @NonNull Direction direction) {
        Preconditions.checkNotNull(fieldPath, "Provided field path must not be null.");
        return this.orderBy(fieldPath.getInternalPath(), direction);
    }

    private Query orderBy(@NonNull com.google.firebase.firestore.model.FieldPath fieldPath, @NonNull Direction direction) {
        Preconditions.checkNotNull(direction, "Provided direction must not be null.");
        if (this.query.getStartAt() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.startAt() or Query.startAfter() before calling Query.orderBy().");
        }
        if (this.query.getEndAt() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.endAt() or Query.endBefore() before calling Query.orderBy().");
        }
        OrderBy.Direction dir = direction == Direction.ASCENDING ? OrderBy.Direction.ASCENDING : OrderBy.Direction.DESCENDING;
        return new Query(this.query.orderBy(OrderBy.getInstance(dir, fieldPath)), this.firestore);
    }

    @NonNull
    public Query limit(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid Query. Query limit (" + limit + ") is invalid. Limit must be positive.");
        }
        return new Query(this.query.limitToFirst(limit), this.firestore);
    }

    @NonNull
    public Query limitToLast(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid Query. Query limitToLast (" + limit + ") is invalid. Limit must be positive.");
        }
        return new Query(this.query.limitToLast(limit), this.firestore);
    }

    @NonNull
    public Query startAt(@NonNull DocumentSnapshot snapshot) {
        Bound bound = this.boundFromDocumentSnapshot("startAt", snapshot, true);
        return new Query(this.query.startAt(bound), this.firestore);
    }

    @NonNull
    public Query startAt(Object ... fieldValues) {
        Bound bound = this.boundFromFields("startAt", fieldValues, true);
        return new Query(this.query.startAt(bound), this.firestore);
    }

    @NonNull
    public Query startAfter(@NonNull DocumentSnapshot snapshot) {
        Bound bound = this.boundFromDocumentSnapshot("startAfter", snapshot, false);
        return new Query(this.query.startAt(bound), this.firestore);
    }

    @NonNull
    public Query startAfter(Object ... fieldValues) {
        Bound bound = this.boundFromFields("startAfter", fieldValues, false);
        return new Query(this.query.startAt(bound), this.firestore);
    }

    @NonNull
    public Query endBefore(@NonNull DocumentSnapshot snapshot) {
        Bound bound = this.boundFromDocumentSnapshot("endBefore", snapshot, false);
        return new Query(this.query.endAt(bound), this.firestore);
    }

    @NonNull
    public Query endBefore(Object ... fieldValues) {
        Bound bound = this.boundFromFields("endBefore", fieldValues, false);
        return new Query(this.query.endAt(bound), this.firestore);
    }

    @NonNull
    public Query endAt(@NonNull DocumentSnapshot snapshot) {
        Bound bound = this.boundFromDocumentSnapshot("endAt", snapshot, true);
        return new Query(this.query.endAt(bound), this.firestore);
    }

    @NonNull
    public Query endAt(Object ... fieldValues) {
        Bound bound = this.boundFromFields("endAt", fieldValues, true);
        return new Query(this.query.endAt(bound), this.firestore);
    }

    private Bound boundFromDocumentSnapshot(String methodName, DocumentSnapshot snapshot, boolean inclusive) {
        Preconditions.checkNotNull(snapshot, "Provided snapshot must not be null.");
        if (!snapshot.exists()) {
            throw new IllegalArgumentException("Can't use a DocumentSnapshot for a document that doesn't exist for " + methodName + "().");
        }
        Document document = snapshot.getDocument();
        ArrayList<Value> components = new ArrayList<Value>();
        for (OrderBy orderBy : this.query.getNormalizedOrderBy()) {
            if (orderBy.getField().equals(com.google.firebase.firestore.model.FieldPath.KEY_PATH)) {
                components.add(Values.refValue(this.firestore.getDatabaseId(), document.getKey()));
                continue;
            }
            Value value = document.getField(orderBy.getField());
            if (ServerTimestamps.isServerTimestamp(value)) {
                throw new IllegalArgumentException("Invalid query. You are trying to start or end a query using a document for which the field '" + orderBy.getField() + "' is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)");
            }
            if (value != null) {
                components.add(value);
                continue;
            }
            throw new IllegalArgumentException("Invalid query. You are trying to start or end a query using a document for which the field '" + orderBy.getField() + "' (used as the orderBy) does not exist.");
        }
        return new Bound(components, inclusive);
    }

    private Bound boundFromFields(String methodName, Object[] values, boolean inclusive) {
        List<OrderBy> explicitOrderBy = this.query.getExplicitOrderBy();
        if (values.length > explicitOrderBy.size()) {
            throw new IllegalArgumentException("Too many arguments provided to " + methodName + "(). The number of arguments must be less than or equal to the number of orderBy() clauses.");
        }
        ArrayList<Value> components = new ArrayList<Value>();
        for (int i = 0; i < values.length; ++i) {
            Object rawValue = values[i];
            OrderBy orderBy = explicitOrderBy.get(i);
            if (orderBy.getField().equals(com.google.firebase.firestore.model.FieldPath.KEY_PATH)) {
                if (!(rawValue instanceof String)) {
                    throw new IllegalArgumentException("Invalid query. Expected a string for document ID in " + methodName + "(), but got " + rawValue + ".");
                }
                String documentId = (String)rawValue;
                if (!this.query.isCollectionGroupQuery() && documentId.contains("/")) {
                    throw new IllegalArgumentException("Invalid query. When querying a collection and ordering by FieldPath.documentId(), the value passed to " + methodName + "() must be a plain document ID, but '" + documentId + "' contains a slash.");
                }
                ResourcePath path = this.query.getPath().append(ResourcePath.fromString(documentId));
                if (!DocumentKey.isDocumentKey(path)) {
                    throw new IllegalArgumentException("Invalid query. When querying a collection group and ordering by FieldPath.documentId(), the value passed to " + methodName + "() must result in a valid document path, but '" + path + "' is not because it contains an odd number of segments.");
                }
                DocumentKey key = DocumentKey.fromPath(path);
                components.add(Values.refValue(this.firestore.getDatabaseId(), key));
                continue;
            }
            Value wrapped = this.firestore.getUserDataReader().parseQueryValue(rawValue);
            components.add(wrapped);
        }
        return new Bound(components, inclusive);
    }

    @NonNull
    public Task<QuerySnapshot> get() {
        return this.get(Source.DEFAULT);
    }

    @NonNull
    public Task<QuerySnapshot> get(@NonNull Source source) {
        this.validateHasExplicitOrderByForLimitToLast();
        if (source == Source.CACHE) {
            return ((Task)this.firestore.callClient(client -> client.getDocumentsFromLocalCache(this.query))).continueWith(Executors.DIRECT_EXECUTOR, viewSnap -> new QuerySnapshot(new Query(this.query, this.firestore), (ViewSnapshot)viewSnap.getResult(), this.firestore));
        }
        return this.getViaSnapshotListener(source);
    }

    private Task<QuerySnapshot> getViaSnapshotListener(Source source) {
        TaskCompletionSource res = new TaskCompletionSource();
        TaskCompletionSource registration = new TaskCompletionSource();
        EventManager.ListenOptions options = new EventManager.ListenOptions();
        options.includeDocumentMetadataChanges = true;
        options.includeQueryMetadataChanges = true;
        options.waitForSyncWhenOnline = true;
        ListenerRegistration listenerRegistration = this.addSnapshotListenerInternal(Executors.DIRECT_EXECUTOR, options, null, (snapshot, error) -> {
            if (error != null) {
                res.setException((Exception)((Object)error));
                return;
            }
            try {
                ListenerRegistration actualRegistration = (ListenerRegistration)Tasks.await((Task)registration.getTask());
                actualRegistration.remove();
                if (snapshot.getMetadata().isFromCache() && source == Source.SERVER) {
                    res.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to SERVER to retrieve the cached documents.)", FirebaseFirestoreException.Code.UNAVAILABLE)));
                } else {
                    res.setResult(snapshot);
                }
            }
            catch (ExecutionException e) {
                throw Assert.fail(e, "Failed to register a listener for a query result", new Object[0]);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Assert.fail(e, "Failed to register a listener for a query result", new Object[0]);
            }
        });
        registration.setResult((Object)listenerRegistration);
        return res.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(executor, MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(activity, MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(Executors.DEFAULT_CALLBACK_EXECUTOR, metadataChanges, listener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        Preconditions.checkNotNull(executor, "Provided executor must not be null.");
        Preconditions.checkNotNull(metadataChanges, "Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, "Provided EventListener must not be null.");
        return this.addSnapshotListenerInternal(executor, Query.internalOptions(metadataChanges), null, listener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        Preconditions.checkNotNull(activity, "Provided activity must not be null.");
        Preconditions.checkNotNull(metadataChanges, "Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, "Provided EventListener must not be null.");
        return this.addSnapshotListenerInternal(Executors.DEFAULT_CALLBACK_EXECUTOR, Query.internalOptions(metadataChanges), activity, listener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull SnapshotListenOptions options, @NonNull EventListener<QuerySnapshot> listener) {
        Preconditions.checkNotNull(options, "Provided options value must not be null.");
        Preconditions.checkNotNull(listener, "Provided EventListener must not be null.");
        return this.addSnapshotListenerInternal(options.getExecutor(), Query.internalOptions(options.getMetadataChanges(), options.getSource()), options.getActivity(), listener);
    }

    private ListenerRegistration addSnapshotListenerInternal(Executor executor, EventManager.ListenOptions options, @Nullable Activity activity, EventListener<QuerySnapshot> userListener) {
        this.validateHasExplicitOrderByForLimitToLast();
        EventListener<ViewSnapshot> viewListener = (snapshot, error) -> {
            if (error != null) {
                userListener.onEvent(null, error);
                return;
            }
            Assert.hardAssert(snapshot != null, "Got event without value or error set", new Object[0]);
            QuerySnapshot querySnapshot = new QuerySnapshot(this, (ViewSnapshot)snapshot, this.firestore);
            userListener.onEvent(querySnapshot, null);
        };
        AsyncEventListener<ViewSnapshot> asyncListener = new AsyncEventListener<ViewSnapshot>(executor, viewListener);
        return (ListenerRegistration)this.firestore.callClient(client -> {
            QueryListener queryListener = client.listen(this.query, options, asyncListener);
            return ActivityScope.bind(activity, () -> {
                asyncListener.mute();
                client.stopListening(queryListener);
            });
        });
    }

    private void validateHasExplicitOrderByForLimitToLast() {
        if (this.query.getLimitType().equals((Object)Query.LimitType.LIMIT_TO_LAST) && this.query.getExplicitOrderBy().isEmpty()) {
            throw new IllegalStateException("limitToLast() queries require specifying at least one orderBy() clause");
        }
    }

    @NonNull
    public AggregateQuery count() {
        return new AggregateQuery(this, Collections.singletonList(AggregateField.count()));
    }

    @NonNull
    public AggregateQuery aggregate(final @NonNull AggregateField aggregateField, AggregateField ... aggregateFields) {
        ArrayList<AggregateField> fields = new ArrayList<AggregateField>(){
            {
                this.add(aggregateField);
            }
        };
        fields.addAll(Arrays.asList(aggregateFields));
        return new AggregateQuery(this, (List<AggregateField>)fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query that = (Query)o;
        return this.query.equals(that.query) && this.firestore.equals(that.firestore);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + this.firestore.hashCode();
        return result;
    }

    private static EventManager.ListenOptions internalOptions(MetadataChanges metadataChanges) {
        return Query.internalOptions(metadataChanges, ListenSource.DEFAULT);
    }

    private static EventManager.ListenOptions internalOptions(MetadataChanges metadataChanges, ListenSource source) {
        EventManager.ListenOptions internalOptions = new EventManager.ListenOptions();
        internalOptions.includeDocumentMetadataChanges = metadataChanges == MetadataChanges.INCLUDE;
        internalOptions.includeQueryMetadataChanges = metadataChanges == MetadataChanges.INCLUDE;
        internalOptions.waitForSyncWhenOnline = false;
        internalOptions.source = source;
        return internalOptions;
    }

    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

