/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;

public class KeyFieldFilter
extends FieldFilter {
    private final DocumentKey key;

    KeyFieldFilter(FieldPath field, FieldFilter.Operator operator, Value value) {
        super(field, operator, value);
        Assert.hardAssert(Values.isReferenceValue(value), "KeyFieldFilter expects a ReferenceValue", new Object[0]);
        this.key = DocumentKey.fromName(this.getValue().getReferenceValue());
    }

    @Override
    public boolean matches(Document doc) {
        int comparator = doc.getKey().compareTo(this.key);
        return this.matchesComparison(comparator);
    }
}

