/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.DocumentViewChange;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.DocumentSet;
import java.util.ArrayList;
import java.util.List;

public class ViewSnapshot {
    private final Query query;
    private final DocumentSet documents;
    private final DocumentSet oldDocuments;
    private final List<DocumentViewChange> changes;
    private final boolean isFromCache;
    private final ImmutableSortedSet<DocumentKey> mutatedKeys;
    private final boolean didSyncStateChange;
    private boolean excludesMetadataChanges;
    private boolean hasCachedResults;

    public ViewSnapshot(Query query, DocumentSet documents, DocumentSet oldDocuments, List<DocumentViewChange> changes, boolean isFromCache, ImmutableSortedSet<DocumentKey> mutatedKeys, boolean didSyncStateChange, boolean excludesMetadataChanges, boolean hasCachedResults) {
        this.query = query;
        this.documents = documents;
        this.oldDocuments = oldDocuments;
        this.changes = changes;
        this.isFromCache = isFromCache;
        this.mutatedKeys = mutatedKeys;
        this.didSyncStateChange = didSyncStateChange;
        this.excludesMetadataChanges = excludesMetadataChanges;
        this.hasCachedResults = hasCachedResults;
    }

    public static ViewSnapshot fromInitialDocuments(Query query, DocumentSet documents, ImmutableSortedSet<DocumentKey> mutatedKeys, boolean fromCache, boolean excludesMetadataChanges, boolean hasCachedResults) {
        ArrayList<DocumentViewChange> viewChanges = new ArrayList<DocumentViewChange>();
        for (Document doc : documents) {
            viewChanges.add(DocumentViewChange.create(DocumentViewChange.Type.ADDED, doc));
        }
        return new ViewSnapshot(query, documents, DocumentSet.emptySet(query.comparator()), viewChanges, fromCache, mutatedKeys, true, excludesMetadataChanges, hasCachedResults);
    }

    public Query getQuery() {
        return this.query;
    }

    public DocumentSet getDocuments() {
        return this.documents;
    }

    public DocumentSet getOldDocuments() {
        return this.oldDocuments;
    }

    public List<DocumentViewChange> getChanges() {
        return this.changes;
    }

    public boolean isFromCache() {
        return this.isFromCache;
    }

    public boolean hasPendingWrites() {
        return !this.mutatedKeys.isEmpty();
    }

    public ImmutableSortedSet<DocumentKey> getMutatedKeys() {
        return this.mutatedKeys;
    }

    public boolean didSyncStateChange() {
        return this.didSyncStateChange;
    }

    public boolean excludesMetadataChanges() {
        return this.excludesMetadataChanges;
    }

    public boolean hasCachedResults() {
        return this.hasCachedResults;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ViewSnapshot)) {
            return false;
        }
        ViewSnapshot that = (ViewSnapshot)o;
        if (this.isFromCache != that.isFromCache) {
            return false;
        }
        if (this.didSyncStateChange != that.didSyncStateChange) {
            return false;
        }
        if (this.excludesMetadataChanges != that.excludesMetadataChanges) {
            return false;
        }
        if (!this.query.equals(that.query)) {
            return false;
        }
        if (!this.mutatedKeys.equals(that.mutatedKeys)) {
            return false;
        }
        if (!this.documents.equals(that.documents)) {
            return false;
        }
        if (!this.oldDocuments.equals(that.oldDocuments)) {
            return false;
        }
        if (this.hasCachedResults != that.hasCachedResults) {
            return false;
        }
        return this.changes.equals(that.changes);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + this.documents.hashCode();
        result = 31 * result + this.oldDocuments.hashCode();
        result = 31 * result + this.changes.hashCode();
        result = 31 * result + this.mutatedKeys.hashCode();
        result = 31 * result + (this.isFromCache ? 1 : 0);
        result = 31 * result + (this.didSyncStateChange ? 1 : 0);
        result = 31 * result + (this.excludesMetadataChanges ? 1 : 0);
        result = 31 * result + (this.hasCachedResults ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ViewSnapshot(" + this.query + ", " + this.documents + ", " + this.oldDocuments + ", " + this.changes + ", isFromCache=" + this.isFromCache + ", mutatedKeys=" + this.mutatedKeys.size() + ", didSyncStateChange=" + this.didSyncStateChange + ", excludesMetadataChanges=" + this.excludesMetadataChanges + ", hasCachedResults=" + this.hasCachedResults + ")";
    }

    public static enum SyncState {
        NONE,
        LOCAL,
        SYNCED;

    }
}

