/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.local.GlobalsCache;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.protobuf.ByteString;

public class SQLiteGlobalsCache
implements GlobalsCache {
    private static final String SESSION_TOKEN = "sessionToken";
    private final SQLitePersistence db;

    public SQLiteGlobalsCache(SQLitePersistence persistence) {
        this.db = persistence;
    }

    @Override
    @NonNull
    public ByteString getSessionsToken() {
        byte[] bytes = this.get(SESSION_TOKEN);
        return bytes == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    @Override
    public void setSessionToken(@NonNull ByteString value) {
        this.set(SESSION_TOKEN, value.toByteArray());
    }

    private byte[] get(@NonNull String name) {
        return (byte[])this.db.query("SELECT value FROM globals WHERE name = ?").binding(name).firstValue(row -> row.getBlob(0));
    }

    private void set(@NonNull String name, @NonNull byte[] value) {
        this.db.execute("INSERT OR REPLACE INTO globals (name, value) VALUES (?, ?)", name, value);
    }
}

