/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.annotation.SuppressLint;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.auto.value.AutoValue;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.remote.AutoValue_TestingHooks_ExistenceFilterBloomFilterInfo;
import com.google.firebase.firestore.remote.AutoValue_TestingHooks_ExistenceFilterMismatchInfo;
import com.google.firebase.firestore.remote.BloomFilter;
import com.google.firebase.firestore.remote.ExistenceFilter;
import com.google.firebase.firestore.remote.WatchChangeAggregator;
import com.google.firebase.firestore.util.Preconditions;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

@SuppressLint(value={"SupportAnnotationUsage"})
@VisibleForTesting
final class TestingHooks {
    private static final TestingHooks instance = new TestingHooks();
    private final CopyOnWriteArrayList<AtomicReference<ExistenceFilterMismatchListener>> existenceFilterMismatchListeners = new CopyOnWriteArrayList();

    private TestingHooks() {
    }

    @NonNull
    static TestingHooks getInstance() {
        return instance;
    }

    void notifyOnExistenceFilterMismatch(@NonNull ExistenceFilterMismatchInfo info) {
        for (AtomicReference<ExistenceFilterMismatchListener> listenerRef : this.existenceFilterMismatchListeners) {
            ExistenceFilterMismatchListener listener = listenerRef.get();
            if (listener == null) continue;
            listener.onExistenceFilterMismatch(info);
        }
    }

    ListenerRegistration addExistenceFilterMismatchListener(@NonNull ExistenceFilterMismatchListener listener) {
        Preconditions.checkNotNull(listener, "a null listener is not allowed");
        AtomicReference<ExistenceFilterMismatchListener> listenerRef = new AtomicReference<ExistenceFilterMismatchListener>(listener);
        this.existenceFilterMismatchListeners.add(listenerRef);
        return () -> {
            listenerRef.set(null);
            this.existenceFilterMismatchListeners.remove(listenerRef);
        };
    }

    static interface ExistenceFilterMismatchListener {
        @AnyThread
        public void onExistenceFilterMismatch(@NonNull ExistenceFilterMismatchInfo var1);
    }

    @AutoValue
    static abstract class ExistenceFilterMismatchInfo {
        ExistenceFilterMismatchInfo() {
        }

        static ExistenceFilterMismatchInfo create(int localCacheCount, int existenceFilterCount, String projectId, String databaseId, @Nullable ExistenceFilterBloomFilterInfo bloomFilter) {
            return new AutoValue_TestingHooks_ExistenceFilterMismatchInfo(localCacheCount, existenceFilterCount, projectId, databaseId, bloomFilter);
        }

        abstract int localCacheCount();

        abstract int existenceFilterCount();

        abstract String projectId();

        abstract String databaseId();

        @Nullable
        abstract ExistenceFilterBloomFilterInfo bloomFilter();

        static ExistenceFilterMismatchInfo from(int localCacheCount, ExistenceFilter existenceFilter, DatabaseId databaseId, @Nullable BloomFilter bloomFilter, WatchChangeAggregator.BloomFilterApplicationStatus bloomFilterStatus) {
            return ExistenceFilterMismatchInfo.create(localCacheCount, existenceFilter.getCount(), databaseId.getProjectId(), databaseId.getDatabaseId(), ExistenceFilterBloomFilterInfo.from(bloomFilter, bloomFilterStatus, existenceFilter));
        }
    }

    @AutoValue
    static abstract class ExistenceFilterBloomFilterInfo {
        ExistenceFilterBloomFilterInfo() {
        }

        static ExistenceFilterBloomFilterInfo create(@Nullable BloomFilter bloomFilter, boolean applied, int hashCount, int bitmapLength, int padding) {
            return new AutoValue_TestingHooks_ExistenceFilterBloomFilterInfo(bloomFilter, applied, hashCount, bitmapLength, padding);
        }

        @Nullable
        abstract BloomFilter bloomFilter();

        abstract boolean applied();

        abstract int hashCount();

        abstract int bitmapLength();

        abstract int padding();

        @Nullable
        static ExistenceFilterBloomFilterInfo from(@Nullable BloomFilter bloomFilter, WatchChangeAggregator.BloomFilterApplicationStatus bloomFilterStatus, ExistenceFilter existenceFilter) {
            com.google.firestore.v1.BloomFilter unchangedNames = existenceFilter.getUnchangedNames();
            if (unchangedNames == null) {
                return null;
            }
            return ExistenceFilterBloomFilterInfo.create(bloomFilter, bloomFilterStatus == WatchChangeAggregator.BloomFilterApplicationStatus.SUCCESS, unchangedNames.getHashCount(), unchangedNames.getBits().getBitmap().size(), unchangedNames.getBits().getPadding());
        }
    }
}

