/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.database.Cursor;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.local.DocumentOverlayCache;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.Overlay;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.BackgroundQueue;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firestore.v1.Write;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class SQLiteDocumentOverlayCache
implements DocumentOverlayCache {
    private final SQLitePersistence db;
    private final LocalSerializer serializer;
    private final String uid;

    public SQLiteDocumentOverlayCache(SQLitePersistence db, LocalSerializer serializer, User user) {
        this.db = db;
        this.serializer = serializer;
        this.uid = user.isAuthenticated() ? user.getUid() : "";
    }

    @Override
    @Nullable
    public Overlay getOverlay(DocumentKey key) {
        String collectionPath = EncodedPath.encode((ResourcePath)key.getPath().popLast());
        String documentId = key.getPath().getLastSegment();
        return (Overlay)this.db.query("SELECT overlay_mutation, largest_batch_id FROM document_overlays WHERE uid = ? AND collection_path = ? AND document_id = ?").binding(this.uid, collectionPath, documentId).firstValue(row -> this.decodeOverlay(row.getBlob(0), row.getInt(1)));
    }

    @Override
    public Map<DocumentKey, Overlay> getOverlays(SortedSet<DocumentKey> keys) {
        Assert.hardAssert(keys.comparator() == null, "getOverlays() requires natural order", new Object[0]);
        HashMap<DocumentKey, Overlay> result = new HashMap<DocumentKey, Overlay>();
        BackgroundQueue backgroundQueue = new BackgroundQueue();
        ResourcePath currentCollection = ResourcePath.EMPTY;
        ArrayList<Object> accumulatedDocumentIds = new ArrayList<Object>();
        for (DocumentKey key : keys) {
            if (!currentCollection.equals(key.getCollectionPath())) {
                this.processSingleCollection(result, backgroundQueue, currentCollection, accumulatedDocumentIds);
                currentCollection = key.getCollectionPath();
                accumulatedDocumentIds.clear();
            }
            accumulatedDocumentIds.add(key.getDocumentId());
        }
        this.processSingleCollection(result, backgroundQueue, currentCollection, accumulatedDocumentIds);
        backgroundQueue.drain();
        return result;
    }

    private void processSingleCollection(Map<DocumentKey, Overlay> result, BackgroundQueue backgroundQueue, ResourcePath collectionPath, List<Object> documentIds) {
        if (documentIds.isEmpty()) {
            return;
        }
        SQLitePersistence.LongQuery longQuery = new SQLitePersistence.LongQuery(this.db, "SELECT overlay_mutation, largest_batch_id FROM document_overlays WHERE uid = ? AND collection_path = ? AND document_id IN (", Arrays.asList(this.uid, EncodedPath.encode(collectionPath)), documentIds, ")");
        while (longQuery.hasMoreSubqueries()) {
            longQuery.performNextSubquery().forEach(row -> this.processOverlaysInBackground(backgroundQueue, result, (Cursor)row));
        }
    }

    private void saveOverlay(int largestBatchId, DocumentKey key, Mutation mutation) {
        String group = key.getCollectionGroup();
        String collectionPath = EncodedPath.encode((ResourcePath)key.getPath().popLast());
        String documentId = key.getPath().getLastSegment();
        this.db.execute("INSERT OR REPLACE INTO document_overlays (uid, collection_group, collection_path, document_id, largest_batch_id, overlay_mutation) VALUES (?, ?, ?, ?, ?, ?)", this.uid, group, collectionPath, documentId, largestBatchId, this.serializer.encodeMutation(mutation).toByteArray());
    }

    @Override
    public void saveOverlays(int largestBatchId, Map<DocumentKey, Mutation> overlays) {
        for (Map.Entry<DocumentKey, Mutation> entry : overlays.entrySet()) {
            DocumentKey key = entry.getKey();
            Mutation overlay = Preconditions.checkNotNull(entry.getValue(), "null value for key: %s", key);
            this.saveOverlay(largestBatchId, key, overlay);
        }
    }

    @Override
    public void removeOverlaysForBatchId(int batchId) {
        this.db.execute("DELETE FROM document_overlays WHERE uid = ? AND largest_batch_id = ?", this.uid, batchId);
    }

    @Override
    public Map<DocumentKey, Overlay> getOverlays(ResourcePath collection, int sinceBatchId) {
        HashMap<DocumentKey, Overlay> result = new HashMap<DocumentKey, Overlay>();
        BackgroundQueue backgroundQueue = new BackgroundQueue();
        this.db.query("SELECT overlay_mutation, largest_batch_id FROM document_overlays WHERE uid = ? AND collection_path = ? AND largest_batch_id > ?").binding(this.uid, EncodedPath.encode(collection), sinceBatchId).forEach(row -> this.processOverlaysInBackground(backgroundQueue, (Map<DocumentKey, Overlay>)result, (Cursor)row));
        backgroundQueue.drain();
        return result;
    }

    @Override
    public Map<DocumentKey, Overlay> getOverlays(String collectionGroup, int sinceBatchId, int count) {
        HashMap<DocumentKey, Overlay> result = new HashMap<DocumentKey, Overlay>();
        String[] lastCollectionPath = new String[1];
        String[] lastDocumentPath = new String[1];
        int[] lastLargestBatchId = new int[1];
        BackgroundQueue backgroundQueue = new BackgroundQueue();
        this.db.query("SELECT overlay_mutation, largest_batch_id, collection_path, document_id  FROM document_overlays WHERE uid = ? AND collection_group = ? AND largest_batch_id > ? ORDER BY largest_batch_id, collection_path, document_id LIMIT ?").binding(this.uid, collectionGroup, sinceBatchId, count).forEach(row -> {
            lastLargestBatchId[0] = row.getInt(1);
            lastCollectionPath[0] = row.getString(2);
            lastDocumentPath[0] = row.getString(3);
            this.processOverlaysInBackground(backgroundQueue, (Map<DocumentKey, Overlay>)result, (Cursor)row);
        });
        if (lastCollectionPath[0] == null) {
            return result;
        }
        this.db.query("SELECT overlay_mutation, largest_batch_id FROM document_overlays WHERE uid = ? AND collection_group = ? AND (collection_path > ? OR (collection_path = ? AND document_id > ?)) AND largest_batch_id = ?").binding(this.uid, collectionGroup, lastCollectionPath[0], lastCollectionPath[0], lastDocumentPath[0], lastLargestBatchId[0]).forEach(row -> this.processOverlaysInBackground(backgroundQueue, (Map<DocumentKey, Overlay>)result, (Cursor)row));
        backgroundQueue.drain();
        return result;
    }

    private void processOverlaysInBackground(BackgroundQueue backgroundQueue, Map<DocumentKey, Overlay> results, Cursor row) {
        byte[] rawMutation = row.getBlob(0);
        int largestBatchId = row.getInt(1);
        Runnable runnable = () -> {
            Overlay overlay = this.decodeOverlay(rawMutation, largestBatchId);
            Map map2 = results;
            synchronized (map2) {
                results.put(overlay.getKey(), overlay);
            }
        };
        if (row.isFirst() && row.isLast()) {
            runnable.run();
        } else {
            backgroundQueue.submit(runnable);
        }
    }

    private Overlay decodeOverlay(byte[] rawMutation, int largestBatchId) {
        try {
            Write write = Write.parseFrom(rawMutation);
            Mutation mutation = this.serializer.decodeMutation(write);
            return Overlay.create(largestBatchId, mutation);
        }
        catch (InvalidProtocolBufferException e) {
            throw Assert.fail("Overlay failed to parse: %s", new Object[]{e});
        }
    }
}

