/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Util;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePath<B extends BasePath<B>>
implements Comparable<B> {
    final List<String> segments;

    BasePath(List<String> segments) {
        this.segments = segments;
    }

    public String getSegment(int index) {
        return this.segments.get(index);
    }

    public B append(String segment) {
        ArrayList<String> newPath = new ArrayList<String>(this.segments);
        newPath.add(segment);
        return this.createPathWithSegments(newPath);
    }

    public B append(B path) {
        ArrayList<String> newPath = new ArrayList<String>(this.segments);
        newPath.addAll(((BasePath)path).segments);
        return this.createPathWithSegments(newPath);
    }

    public B popFirst() {
        return this.popFirst(1);
    }

    public B popFirst(int count) {
        int length = this.length();
        Assert.hardAssert(length >= count, "Can't call popFirst with count > length() (%d > %d)", count, length);
        return this.createPathWithSegments(this.segments.subList(count, length));
    }

    public B popLast() {
        return this.createPathWithSegments(this.segments.subList(0, this.length() - 1));
    }

    public B keepFirst(int count) {
        return this.createPathWithSegments(this.segments.subList(0, count));
    }

    @Override
    public int compareTo(@NonNull B o) {
        int myLength = this.length();
        int theirLength = ((BasePath)o).length();
        for (int i = 0; i < myLength && i < theirLength; ++i) {
            int localCompare = BasePath.compareSegments(this.getSegment(i), ((BasePath)o).getSegment(i));
            if (localCompare == 0) continue;
            return localCompare;
        }
        return Integer.compare(myLength, theirLength);
    }

    private static int compareSegments(String lhs, String rhs) {
        boolean isLhsNumeric = BasePath.isNumericId(lhs);
        boolean isRhsNumeric = BasePath.isNumericId(rhs);
        if (isLhsNumeric && !isRhsNumeric) {
            return -1;
        }
        if (!isLhsNumeric && isRhsNumeric) {
            return 1;
        }
        if (isLhsNumeric && isRhsNumeric) {
            return Long.compare(BasePath.extractNumericId(lhs), BasePath.extractNumericId(rhs));
        }
        return Util.compareUtf8Strings(lhs, rhs);
    }

    private static boolean isNumericId(String segment) {
        return segment.startsWith("__id") && segment.endsWith("__");
    }

    private static long extractNumericId(String segment) {
        return Long.parseLong(segment.substring(4, segment.length() - 2));
    }

    public String getLastSegment() {
        return this.segments.get(this.length() - 1);
    }

    public String getFirstSegment() {
        return this.segments.get(0);
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public boolean isPrefixOf(B path) {
        if (this.length() > ((BasePath)path).length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.getSegment(i).equals(((BasePath)path).getSegment(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isImmediateParentOf(B potentialChild) {
        if (this.length() + 1 != ((BasePath)potentialChild).length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.getSegment(i).equals(((BasePath)potentialChild).getSegment(i))) continue;
            return false;
        }
        return true;
    }

    public abstract String canonicalString();

    public String toString() {
        return this.canonicalString();
    }

    abstract B createPathWithSegments(List<String> var1);

    public int length() {
        return this.segments.size();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof BasePath && this.compareTo((B)((BasePath)o)) == 0;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = prime * result + this.getClass().hashCode();
        result = prime * result + this.segments.hashCode();
        return result;
    }
}

