/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ServerTimestamps;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ObjectValue
implements Cloneable {
    private final Object lock = new Object();
    @Nullable
    private volatile Value mergedValue;
    @GuardedBy(value="lock")
    private Value partialValue;
    @GuardedBy(value="lock")
    private final Map<String, Object> overlayMap = new HashMap<String, Object>();

    public static ObjectValue fromMap(Map<String, Value> value) {
        return new ObjectValue((Value)Value.newBuilder().setMapValue(MapValue.newBuilder().putAllFields(value)).build());
    }

    public ObjectValue(Value value) {
        Assert.hardAssert(value.getValueTypeCase() == Value.ValueTypeCase.MAP_VALUE, "ObjectValues should be backed by a MapValue", new Object[0]);
        Assert.hardAssert(!ServerTimestamps.isServerTimestamp(value), "ServerTimestamps should not be used as an ObjectValue", new Object[0]);
        this.mergedValue = value;
    }

    public ObjectValue() {
        this((Value)Value.newBuilder().setMapValue(MapValue.getDefaultInstance()).build());
    }

    public Map<String, Value> getFieldsMap() {
        return this.buildProto().getMapValue().getFieldsMap();
    }

    public FieldMask getFieldMask() {
        return this.extractFieldMask(this.buildProto().getMapValue());
    }

    private FieldMask extractFieldMask(MapValue value) {
        HashSet<FieldPath> fields = new HashSet<FieldPath>();
        for (Map.Entry<String, Value> entry : value.getFieldsMap().entrySet()) {
            FieldPath currentPath = FieldPath.fromSingleSegment(entry.getKey());
            if (Values.isMapValue(entry.getValue())) {
                FieldMask nestedMask = this.extractFieldMask(entry.getValue().getMapValue());
                Set<FieldPath> nestedFields = nestedMask.getMask();
                if (nestedFields.isEmpty()) {
                    fields.add(currentPath);
                    continue;
                }
                for (FieldPath nestedPath : nestedFields) {
                    fields.add(currentPath.append(nestedPath));
                }
                continue;
            }
            fields.add(currentPath);
        }
        return FieldMask.fromSet(fields);
    }

    @Nullable
    public Value get(FieldPath fieldPath) {
        return ObjectValue.extractNestedValue(this.buildProto(), fieldPath);
    }

    @Nullable
    private static Value extractNestedValue(Value value, FieldPath fieldPath) {
        if (fieldPath.isEmpty()) {
            return value;
        }
        for (int i = 0; i < fieldPath.length() - 1; ++i) {
            if (Values.isMapValue(value = value.getMapValue().getFieldsOrDefault(fieldPath.getSegment(i), null))) continue;
            return null;
        }
        return value.getMapValue().getFieldsOrDefault(fieldPath.getLastSegment(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value buildProto() {
        Value value = this.mergedValue;
        if (value == null) {
            Object object = this.lock;
            synchronized (object) {
                value = this.mergedValue;
                if (value == null) {
                    MapValue mergedResult;
                    assert (this.partialValue != null);
                    value = this.overlayMap.isEmpty() ? this.partialValue : ((mergedResult = ObjectValue.applyOverlay(this.partialValue, FieldPath.EMPTY_PATH, this.overlayMap)) == null ? this.partialValue : (Value)Value.newBuilder().setMapValue(mergedResult).build());
                    assert (value != null);
                    this.mergedValue = value;
                    this.partialValue = null;
                    this.overlayMap.clear();
                }
            }
        }
        return value;
    }

    public void delete(FieldPath path) {
        Assert.hardAssert(!path.isEmpty(), "Cannot delete field for empty path on ObjectValue", new Object[0]);
        this.setOverlay(path, null);
    }

    public void set(FieldPath path, Value value) {
        Assert.hardAssert(!path.isEmpty(), "Cannot set field for empty path on ObjectValue", new Object[0]);
        this.setOverlay(path, value);
    }

    public void setAll(Map<FieldPath, Value> data) {
        for (Map.Entry<FieldPath, Value> entry : data.entrySet()) {
            FieldPath path = entry.getKey();
            if (entry.getValue() == null) {
                this.delete(path);
                continue;
            }
            this.set(path, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOverlay(FieldPath path, @Nullable Value value) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mergedValue != null) {
                this.partialValue = this.mergedValue;
                this.mergedValue = null;
            }
            ObjectValue.setOverlay(this.overlayMap, path, value);
        }
    }

    private static void setOverlay(Map<String, Object> overlayMap, FieldPath path, @Nullable Value value) {
        HashMap<String, Object> currentLevel = overlayMap;
        for (int i = 0; i < path.length() - 1; ++i) {
            HashMap<String, Object> nextLevel;
            String currentSegment = path.getSegment(i);
            Object currentValue = currentLevel.get(currentSegment);
            if (currentValue instanceof Map) {
                currentLevel = (HashMap<String, Object>)currentValue;
                continue;
            }
            if (currentValue instanceof Value && ((Value)currentValue).getValueTypeCase() == Value.ValueTypeCase.MAP_VALUE) {
                nextLevel = new HashMap<String, Value>(((Value)currentValue).getMapValue().getFieldsMap());
                currentLevel.put(currentSegment, nextLevel);
                currentLevel = nextLevel;
                continue;
            }
            nextLevel = new HashMap<String, Object>();
            currentLevel.put(currentSegment, nextLevel);
            currentLevel = nextLevel;
        }
        currentLevel.put(path.getLastSegment(), value);
    }

    @Nullable
    private static MapValue applyOverlay(Value partialValue, FieldPath currentPath, Map<String, Object> currentOverlays) {
        boolean modified = false;
        Value existingValue = ObjectValue.extractNestedValue(partialValue, currentPath);
        MapValue.Builder resultAtPath = Values.isMapValue(existingValue) ? (MapValue.Builder)existingValue.getMapValue().toBuilder() : MapValue.newBuilder();
        for (Map.Entry<String, Object> entry : currentOverlays.entrySet()) {
            String pathSegment = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                MapValue nested = ObjectValue.applyOverlay(partialValue, (FieldPath)((Object)currentPath.append(pathSegment)), (Map)value);
                if (nested == null) continue;
                resultAtPath.putFields(pathSegment, (Value)Value.newBuilder().setMapValue(nested).build());
                modified = true;
                continue;
            }
            if (value instanceof Value) {
                resultAtPath.putFields(pathSegment, (Value)value);
                modified = true;
                continue;
            }
            if (!resultAtPath.containsFields(pathSegment)) continue;
            Assert.hardAssert(value == null, "Expected entry to be a Map, a Value or null", new Object[0]);
            resultAtPath.removeFields(pathSegment);
            modified = true;
        }
        return modified ? (MapValue)resultAtPath.build() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectValue) {
            return Values.equals(this.buildProto(), ((ObjectValue)o).buildProto());
        }
        return false;
    }

    public int hashCode() {
        return this.buildProto().hashCode();
    }

    @NonNull
    public String toString() {
        return "ObjectValue{internalValue=" + Values.canonicalId(this.buildProto()) + '}';
    }

    @NonNull
    public ObjectValue clone() {
        return new ObjectValue(this.buildProto());
    }
}

