/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/firebase/firestore/util/BackgroundQueue;", "", "<init>", "()V", "state", "Lcom/google/firebase/firestore/util/BackgroundQueue$State;", "submit", "", "runnable", "Ljava/lang/Runnable;", "drain", "State", "Companion", "com.google.firebase-firebase-firestore"})
@SourceDebugExtension(value={"SMAP\nBackgroundQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundQueue.kt\ncom/google/firebase/firestore/util/BackgroundQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class BackgroundQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state = new State.Submitting();
    private static final int maxParallelism = RangesKt.coerceAtLeast((int)Runtime.getRuntime().availableProcessors(), (int)2);
    @NotNull
    private static final Executor executor = ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO().limitedParallelism(maxParallelism, "firestore.BackgroundQueue"));

    public final void submit(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        State submittingState = this.state;
        if (!(submittingState instanceof State.Submitting)) {
            boolean bl = false;
            String string = "submit() may not be called after drain()";
            throw new IllegalStateException(string.toString());
        }
        State.Submitting submitting = (State.Submitting)submittingState;
        int n = submitting.getTaskCount();
        submitting.setTaskCount(n + 1);
        executor.execute(() -> BackgroundQueue.submit$lambda$1(runnable, submittingState));
    }

    public final void drain() {
        State submittingState = this.state;
        if (!(submittingState instanceof State.Submitting)) {
            boolean bl = false;
            String string = "drain() may not be called more than once";
            throw new IllegalStateException(string.toString());
        }
        this.state = State.Draining.INSTANCE;
        ((State.Submitting)submittingState).getCompletedTasks().acquire(((State.Submitting)submittingState).getTaskCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void submit$lambda$1(Runnable $runnable, State $submittingState) {
        try {
            $runnable.run();
        }
        finally {
            ((State.Submitting)$submittingState).getCompletedTasks().release();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/firebase/firestore/util/BackgroundQueue$Companion;", "", "<init>", "()V", "maxParallelism", "", "getMaxParallelism", "()I", "executor", "Ljava/util/concurrent/Executor;", "com.google.firebase-firebase-firestore"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMaxParallelism() {
            return maxParallelism;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/firestore/util/BackgroundQueue$State;", "", "Submitting", "Draining", "Lcom/google/firebase/firestore/util/BackgroundQueue$State$Draining;", "Lcom/google/firebase/firestore/util/BackgroundQueue$State$Submitting;", "com.google.firebase-firebase-firestore"})
    private static interface State {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/firebase/firestore/util/BackgroundQueue$State$Draining;", "Lcom/google/firebase/firestore/util/BackgroundQueue$State;", "<init>", "()V", "com.google.firebase-firebase-firestore"})
        public static final class Draining
        implements State {
            @NotNull
            public static final Draining INSTANCE = new Draining();

            private Draining() {
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/google/firebase/firestore/util/BackgroundQueue$State$Submitting;", "Lcom/google/firebase/firestore/util/BackgroundQueue$State;", "<init>", "()V", "completedTasks", "Ljava/util/concurrent/Semaphore;", "getCompletedTasks", "()Ljava/util/concurrent/Semaphore;", "taskCount", "", "getTaskCount", "()I", "setTaskCount", "(I)V", "com.google.firebase-firebase-firestore"})
        public static final class Submitting
        implements State {
            @NotNull
            private final Semaphore completedTasks = new Semaphore(0);
            private int taskCount;

            @NotNull
            public final Semaphore getCompletedTasks() {
                return this.completedTasks;
            }

            public final int getTaskCount() {
                return this.taskCount;
            }

            public final void setTaskCount(int n) {
                this.taskCount = n;
            }
        }
    }
}

