/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class Store {
    final SharedPreferences store;
    final Context context;
    @GuardedBy(value="this")
    private final Map<String, Long> subtypeCreationTimes;

    public Store(Context context) {
        ArrayMap arrayMap;
        this.subtypeCreationTimes = arrayMap = new ArrayMap();
        this.context = context;
        this.store = context.getSharedPreferences("com.google.android.gms.appid", 0);
        this.checkForRestore("com.google.android.gms.appid-no-backup");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForRestore(String object) {
        object = this.context;
        File file = new File((File)(object = ContextCompat.getNoBackupFilesDir((Context)object)), "com.google.android.gms.appid-no-backup");
        if (file.exists()) {
            return;
        }
        try {
            boolean bl = file.createNewFile();
            if (!bl || (bl = this.isEmpty())) return;
            Log.i((String)"FirebaseInstanceId", (String)"App restored, clearing state");
            this.deleteAll();
            return;
        }
        catch (IOException iOException) {
            if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                return;
            }
            String string = String.valueOf(iOException.getMessage());
            object = "Error creating file in no backup dir: ";
            string = string.length() != 0 ? ((String)object).concat(string) : new String((String)object);
            Log.d((String)"FirebaseInstanceId", (String)string);
            return;
        }
    }

    public synchronized boolean isEmpty() {
        return this.store.getAll().isEmpty();
    }

    private String createTokenKey(String string, String string2, String string3) {
        String string4 = String.valueOf(string);
        int n = string4.length();
        String string5 = String.valueOf(string2);
        int n2 = string5.length();
        String string6 = String.valueOf(string3);
        int n3 = string6.length();
        StringBuilder stringBuilder = new StringBuilder(n + 4 + n2 + n3);
        stringBuilder.append(string);
        stringBuilder.append("|T|");
        stringBuilder.append(string2);
        stringBuilder.append("|");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    static String createSubtypeInfoKey(String string, String string2) {
        string2 = String.valueOf(string);
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 6);
        stringBuilder.append(string);
        stringBuilder.append("|S|cre");
        return stringBuilder.toString();
    }

    public synchronized void deleteAll() {
        this.subtypeCreationTimes.clear();
        this.store.edit().clear().commit();
    }

    public synchronized Token getToken(String string, String string2, String string3) {
        return Token.parse(this.store.getString(this.createTokenKey(string, string2, string3), null));
    }

    public synchronized void saveToken(String string, String string2, String string3, String string4, String string5) {
        if ((string4 = Token.encode(string4, string5, System.currentTimeMillis())) == null) {
            return;
        }
        string5 = this.store.edit();
        string5.putString(this.createTokenKey(string, string2, string3), string4);
        string5.commit();
    }

    public synchronized void deleteToken(String string, String string2, String string3) {
        string = store.createTokenKey(string, string2, string3);
        Store store = store.store.edit();
        store.remove(string);
        store.commit();
    }

    public synchronized long getCreationTime(String string) {
        Long l = this.subtypeCreationTimes.get(string);
        if (l != null) {
            return l;
        }
        return this.getCreationTimeFromSharedPreferences(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getCreationTimeFromSharedPreferences(String string) {
        String string2 = ((Store)((Object)string2)).store.getString(Store.createSubtypeInfoKey(string, "cre"), null);
        if (string2 == null) return 0L;
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public synchronized long setCreationTime(String string) {
        long l = this.writeCreationTimeToSharedPreferences(string);
        this.subtypeCreationTimes.put(string, l);
        return l;
    }

    private long writeCreationTimeToSharedPreferences(String string) {
        long l = System.currentTimeMillis();
        String string2 = Store.createSubtypeInfoKey(string, "cre");
        if (!store.store.contains(string2)) {
            Store store = store.store.edit();
            store.putString(Store.createSubtypeInfoKey(string, "cre"), String.valueOf(l));
            store.commit();
            return l;
        }
        return store.getCreationTimeFromSharedPreferences(string);
    }

    static class Token {
        private static final long REFRESH_PERIOD_MILLIS = TimeUnit.DAYS.toMillis(7L);
        final String token;
        final String appVersion;
        final long timestamp;

        private Token(String string, String string2, long l) {
            this.token = string;
            this.appVersion = string2;
            this.timestamp = l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Token parse(String object) {
            if (TextUtils.isEmpty((CharSequence)object)) {
                return null;
            }
            if (!((String)object).startsWith("{")) return new Token((String)object, null, 0L);
            try {
                JSONObject jSONObject = new JSONObject((String)object);
                return new Token(jSONObject.getString("token"), jSONObject.getString("appVersion"), jSONObject.getLong("timestamp"));
            }
            catch (JSONException jSONException) {
                String string = String.valueOf((Object)jSONException);
                String string2 = String.valueOf(string);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 23);
                stringBuilder.append("Failed to parse token: ");
                stringBuilder.append(string);
                Log.w((String)"FirebaseInstanceId", (String)stringBuilder.toString());
                return null;
            }
        }

        static String encode(String string, String string2, long l) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("token", (Object)string);
                jSONObject.put("appVersion", (Object)string2);
                jSONObject.put("timestamp", l);
                string = jSONObject.toString();
                return string;
            }
            catch (JSONException jSONException) {
                String string3 = String.valueOf((Object)jSONException);
                string2 = String.valueOf(string3);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 24);
                stringBuilder.append("Failed to encode token: ");
                stringBuilder.append(string3);
                Log.w((String)"FirebaseInstanceId", (String)stringBuilder.toString());
                return null;
            }
        }

        static String getTokenOrNull(@Nullable Token token) {
            if (token == null) {
                return null;
            }
            return token.token;
        }

        boolean needsRefresh(String string) {
            return System.currentTimeMillis() > this.timestamp + REFRESH_PERIOD_MILLIS || !string.equals(this.appVersion);
        }
    }
}

