/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display;

import android.app.Application;
import androidx.annotation.Keep;
import com.google.firebase.FirebaseApp;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.inappmessaging.FirebaseInAppMessaging;
import com.google.firebase.inappmessaging.display.FirebaseInAppMessagingDisplay;
import com.google.firebase.inappmessaging.display.internal.injection.components.AppComponent;
import com.google.firebase.inappmessaging.display.internal.injection.components.DaggerAppComponent;
import com.google.firebase.inappmessaging.display.internal.injection.components.DaggerUniversalComponent;
import com.google.firebase.inappmessaging.display.internal.injection.components.UniversalComponent;
import com.google.firebase.inappmessaging.display.internal.injection.modules.ApplicationModule;
import com.google.firebase.inappmessaging.display.internal.injection.modules.HeadlessInAppMessagingModule;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import java.util.Arrays;
import java.util.List;

@Keep
public class FirebaseInAppMessagingDisplayRegistrar
implements ComponentRegistrar {
    @Keep
    public List<Component<?>> getComponents() {
        return Arrays.asList(Component.builder(FirebaseInAppMessagingDisplay.class).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(FirebaseInAppMessaging.class)).factory(this::buildFirebaseInAppMessagingUI).eagerInDefaultApp().build(), LibraryVersionComponent.create((String)"fire-fiamd", (String)"20.1.1"));
    }

    private FirebaseInAppMessagingDisplay buildFirebaseInAppMessagingUI(ComponentContainer container) {
        FirebaseApp firebaseApp = (FirebaseApp)container.get(FirebaseApp.class);
        FirebaseInAppMessaging headless = (FirebaseInAppMessaging)container.get(FirebaseInAppMessaging.class);
        Application firebaseApplication = (Application)firebaseApp.getApplicationContext();
        UniversalComponent universalComponent = DaggerUniversalComponent.builder().applicationModule(new ApplicationModule(firebaseApplication)).build();
        AppComponent instance = DaggerAppComponent.builder().universalComponent(universalComponent).headlessInAppMessagingModule(new HeadlessInAppMessagingModule(headless)).build();
        FirebaseInAppMessagingDisplay firebaseInAppMessagingDisplay = instance.providesFirebaseInAppMessagingUI();
        firebaseApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)firebaseInAppMessagingDisplay);
        return firebaseInAppMessagingDisplay;
    }
}

