/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import androidx.annotation.Nullable;

public class SwipeDismissTouchListener
implements View.OnTouchListener {
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private View mView;
    private DismissCallbacks mDismissCallbacks;
    private int mViewWidth = 1;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private int mSwipingSlop;
    private Object mToken;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;

    public SwipeDismissTouchListener(View view, Object token, DismissCallbacks callbacks) {
        ViewConfiguration vc = ViewConfiguration.get((Context)view.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = view.getContext().getResources().getInteger(0x10E0000);
        this.mView = view;
        this.mToken = token;
        this.mDismissCallbacks = callbacks;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View view, MotionEvent motionEvent) {
        motionEvent.offsetLocation(this.mTranslationX, 0.0f);
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mDownX = motionEvent.getRawX();
                this.mDownY = motionEvent.getRawY();
                if (this.mDismissCallbacks.canDismiss(this.mToken)) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                }
                return false;
            }
            case 1: {
                if (this.mVelocityTracker == null) break;
                float deltaX = motionEvent.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityX = this.mVelocityTracker.getXVelocity();
                float absVelocityX = Math.abs(velocityX);
                float absVelocityY = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean dismiss = false;
                boolean dismissRight = false;
                if (Math.abs(deltaX) > (float)(this.mViewWidth / 2) && this.mSwiping) {
                    dismiss = true;
                    dismissRight = deltaX > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= absVelocityX && absVelocityX <= (float)this.mMaxFlingVelocity && absVelocityY < absVelocityX && absVelocityY < absVelocityX && this.mSwiping) {
                    dismiss = velocityX < 0.0f == deltaX < 0.0f;
                    boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
                if (dismiss) {
                    this.startDismissAnimation(dismissRight);
                } else if (this.mSwiping) {
                    this.startCancelAnimation();
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                }
                this.mVelocityTracker = null;
                this.mTranslationX = 0.0f;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.startCancelAnimation();
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationX = 0.0f;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float deltaX = motionEvent.getRawX() - this.mDownX;
                float deltaY = motionEvent.getRawY() - this.mDownY;
                if (Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaY) < Math.abs(deltaX) / 2.0f) {
                    this.mSwiping = true;
                    this.mSwipingSlop = deltaX > 0.0f ? this.mSlop : -this.mSlop;
                    this.mView.getParent().requestDisallowInterceptTouchEvent(true);
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
                    this.mView.onTouchEvent(cancelEvent);
                    cancelEvent.recycle();
                }
                if (!this.mSwiping) break;
                this.mTranslationX = deltaX;
                this.setTranslationX(deltaX - (float)this.mSwipingSlop);
                this.setAlpha(Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
                return true;
            }
        }
        return false;
    }

    protected void setTranslationX(float translationX) {
        this.mView.setTranslationX(translationX);
    }

    protected float getTranslationX() {
        return this.mView.getTranslationX();
    }

    protected void setAlpha(float alpha) {
        this.mView.setAlpha(alpha);
    }

    protected void startDismissAnimation(boolean dismissRight) {
        float endTranslation = dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth);
        float endAlpha = 0.0f;
        this.animateTo(endTranslation, 0.0f, new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeDismissTouchListener.this.performDismiss();
            }
        });
    }

    protected void startCancelAnimation() {
        this.animateTo(0.0f, 1.0f, null);
    }

    private void animateTo(float translationX, float alpha, @Nullable AnimatorListenerAdapter listener) {
        final float beginTranslation = this.getTranslationX();
        final float translationDiff = translationX - beginTranslation;
        final float beginAlpha = this.mView.getAlpha();
        final float alphaDiff = alpha - beginAlpha;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(this.mAnimationTime);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float translationX = beginTranslation + valueAnimator.getAnimatedFraction() * translationDiff;
                float alpha = beginAlpha + valueAnimator.getAnimatedFraction() * alphaDiff;
                SwipeDismissTouchListener.this.setTranslationX(translationX);
                SwipeDismissTouchListener.this.setAlpha(alpha);
            }
        });
        if (listener != null) {
            animator.addListener((Animator.AnimatorListener)listener);
        }
        animator.start();
    }

    private void performDismiss() {
        final ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
        final int originalHeight = this.mView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeDismissTouchListener.this.mDismissCallbacks.onDismiss(SwipeDismissTouchListener.this.mView, SwipeDismissTouchListener.this.mToken);
                SwipeDismissTouchListener.this.mView.setAlpha(1.0f);
                SwipeDismissTouchListener.this.mView.setTranslationX(0.0f);
                lp.height = originalHeight;
                SwipeDismissTouchListener.this.mView.setLayoutParams(lp);
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                lp.height = (Integer)valueAnimator.getAnimatedValue();
                SwipeDismissTouchListener.this.mView.setLayoutParams(lp);
            }
        });
        animator.start();
    }

    public static interface DismissCallbacks {
        public boolean canDismiss(Object var1);

        public void onDismiss(View var1, Object var2);
    }
}

