/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.layout.util;

import android.view.View;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.display.internal.layout.util.ViewMeasure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class VerticalViewGroupMeasure {
    private List<ViewMeasure> vms = new ArrayList<ViewMeasure>();
    private int w;
    private int h;

    public VerticalViewGroupMeasure(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public VerticalViewGroupMeasure() {
        this.w = 0;
        this.h = 0;
    }

    public void reset(int w, int h) {
        this.w = w;
        this.h = h;
        this.vms = new ArrayList<ViewMeasure>();
    }

    public void add(View view, boolean flex) {
        ViewMeasure vm = new ViewMeasure(view, flex);
        vm.setMaxDimens(this.w, this.h);
        this.vms.add(vm);
    }

    public List<ViewMeasure> getViews() {
        return this.vms;
    }

    public int getTotalHeight() {
        int sum = 0;
        for (ViewMeasure vm : this.vms) {
            sum += vm.getDesiredHeight();
        }
        return sum;
    }

    public int getTotalFixedHeight() {
        int sum = 0;
        for (ViewMeasure vm : this.vms) {
            if (vm.isFlex()) continue;
            sum += vm.getDesiredHeight();
        }
        return sum;
    }

    public void allocateSpace(int flexAvail) {
        ArrayList<ViewMeasure> flexVms = new ArrayList<ViewMeasure>();
        for (ViewMeasure viewMeasure : this.vms) {
            if (!viewMeasure.isFlex()) continue;
            flexVms.add(viewMeasure);
        }
        Collections.sort(flexVms, new Comparator<ViewMeasure>(){

            @Override
            public int compare(ViewMeasure o1, ViewMeasure o2) {
                if (o1.getDesiredHeight() > o2.getDesiredHeight()) {
                    return -1;
                }
                if (o1.getDesiredHeight() < o2.getDesiredHeight()) {
                    return 1;
                }
                return 0;
            }
        });
        int flexSum = 0;
        for (ViewMeasure vm : flexVms) {
            flexSum += vm.getDesiredHeight();
        }
        int n = flexVms.size();
        if (n >= 6) {
            throw new IllegalStateException("VerticalViewGroupMeasure only supports up to 5 children");
        }
        float minFrac = 0.2f;
        float maxFrac = 1.0f - (float)(n - 1) * minFrac;
        Logging.logdPair("VVGM (minFrac, maxFrac)", minFrac, maxFrac);
        float extraFracPool = 0.0f;
        for (ViewMeasure vm : flexVms) {
            float desiredFrac;
            float grantedFrac = desiredFrac = (float)vm.getDesiredHeight() / (float)flexSum;
            if (desiredFrac > maxFrac) {
                extraFracPool += grantedFrac - maxFrac;
                grantedFrac = maxFrac;
            }
            if (desiredFrac < minFrac) {
                float remainder = minFrac - desiredFrac;
                float addOn = Math.min(remainder, extraFracPool);
                grantedFrac = desiredFrac + addOn;
                extraFracPool -= addOn;
            }
            Logging.logdPair("\t(desired, granted)", desiredFrac, grantedFrac);
            int maxHeight = (int)(grantedFrac * (float)flexAvail);
            vm.setMaxDimens(this.w, maxHeight);
        }
    }
}

