/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.os.Bundle;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.inappmessaging.CampaignAnalytics;
import com.google.firebase.inappmessaging.ClientAppInfo;
import com.google.firebase.inappmessaging.DismissType;
import com.google.firebase.inappmessaging.EventType;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayCallbacks;
import com.google.firebase.inappmessaging.RenderErrorReason;
import com.google.firebase.inappmessaging.internal.DeveloperListenerManager;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.BannerMessage;
import com.google.firebase.inappmessaging.model.CardMessage;
import com.google.firebase.inappmessaging.model.ImageOnlyMessage;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.ModalMessage;
import com.google.firebase.installations.FirebaseInstallationsApi;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class MetricsLoggerClient {
    private static final Map<FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason, RenderErrorReason> errorTransform = new HashMap<FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason, RenderErrorReason>();
    private static final Map<FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType, DismissType> dismissTransform = new HashMap<FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType, DismissType>();
    private final EngagementMetricsLoggerInterface engagementMetricsLogger;
    private final FirebaseApp firebaseApp;
    private final FirebaseInstallationsApi firebaseInstallations;
    private final Clock clock;
    private final AnalyticsConnector analyticsConnector;
    private final DeveloperListenerManager developerListenerManager;
    @Blocking
    private final Executor blockingExecutor;

    public MetricsLoggerClient(EngagementMetricsLoggerInterface engagementMetricsLogger, AnalyticsConnector analyticsConnector, FirebaseApp firebaseApp, FirebaseInstallationsApi firebaseInstallations, Clock clock, DeveloperListenerManager developerListenerManager, @Blocking Executor blockingExecutor) {
        this.engagementMetricsLogger = engagementMetricsLogger;
        this.analyticsConnector = analyticsConnector;
        this.firebaseApp = firebaseApp;
        this.firebaseInstallations = firebaseInstallations;
        this.clock = clock;
        this.developerListenerManager = developerListenerManager;
        this.blockingExecutor = blockingExecutor;
    }

    void logImpression(InAppMessage message) {
        if (!this.isTestCampaign(message)) {
            this.firebaseInstallations.getId().addOnSuccessListener(this.blockingExecutor, id -> this.engagementMetricsLogger.logEvent(this.createEventEntry(message, (String)id, EventType.IMPRESSION_EVENT_TYPE).toByteArray()));
            this.logEventAsync(message, "fiam_impression", this.impressionCountsAsConversion(message));
        }
        this.developerListenerManager.impressionDetected(message);
    }

    void logMessageClick(InAppMessage message, Action action) {
        if (!this.isTestCampaign(message)) {
            this.firebaseInstallations.getId().addOnSuccessListener(this.blockingExecutor, id -> this.engagementMetricsLogger.logEvent(this.createEventEntry(message, (String)id, EventType.CLICK_EVENT_TYPE).toByteArray()));
            this.logEventAsync(message, "fiam_action", true);
        }
        this.developerListenerManager.messageClicked(message, action);
    }

    void logRenderError(InAppMessage message, FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason errorReason) {
        if (!this.isTestCampaign(message)) {
            this.firebaseInstallations.getId().addOnSuccessListener(this.blockingExecutor, id -> this.engagementMetricsLogger.logEvent(this.createRenderErrorEntry(message, (String)id, errorTransform.get((Object)errorReason)).toByteArray()));
        }
        this.developerListenerManager.displayErrorEncountered(message, errorReason);
    }

    void logDismiss(InAppMessage message, FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType dismissType) {
        if (!this.isTestCampaign(message)) {
            this.firebaseInstallations.getId().addOnSuccessListener(this.blockingExecutor, id -> this.engagementMetricsLogger.logEvent(this.createDismissEntry(message, (String)id, dismissTransform.get((Object)dismissType)).toByteArray()));
            this.logEventAsync(message, "fiam_dismiss", false);
        }
        this.developerListenerManager.messageDismissed(message);
    }

    private CampaignAnalytics createEventEntry(InAppMessage message, String installationId, EventType eventType) {
        return (CampaignAnalytics)this.createCampaignAnalyticsBuilder(message, installationId).setEventType(eventType).build();
    }

    private CampaignAnalytics createDismissEntry(InAppMessage message, String installationId, DismissType dismissType) {
        return (CampaignAnalytics)this.createCampaignAnalyticsBuilder(message, installationId).setDismissType(dismissType).build();
    }

    private CampaignAnalytics createRenderErrorEntry(InAppMessage message, String installationId, RenderErrorReason reason) {
        return (CampaignAnalytics)this.createCampaignAnalyticsBuilder(message, installationId).setRenderErrorReason(reason).build();
    }

    private CampaignAnalytics.Builder createCampaignAnalyticsBuilder(InAppMessage message, String installationId) {
        return CampaignAnalytics.newBuilder().setFiamSdkVersion("22.0.1").setProjectNumber(this.firebaseApp.getOptions().getGcmSenderId()).setCampaignId(message.getCampaignMetadata().getCampaignId()).setClientApp(ClientAppInfo.newBuilder().setGoogleAppId(this.firebaseApp.getOptions().getApplicationId()).setFirebaseInstanceId(installationId)).setClientTimestampMillis(this.clock.now());
    }

    private void logEventAsync(InAppMessage message, String event, boolean updateConversionTracking) {
        String campaignId = message.getCampaignMetadata().getCampaignId();
        String campaignName = message.getCampaignMetadata().getCampaignName();
        Bundle params = this.collectAnalyticsParams(campaignName, campaignId);
        Logging.logd("Sending event=" + event + " params=" + params);
        if (this.analyticsConnector != null) {
            this.analyticsConnector.logEvent("fiam", event, params);
            if (updateConversionTracking) {
                this.analyticsConnector.setUserProperty("fiam", "_ln", (Object)("fiam:" + campaignId));
            }
        } else {
            Logging.logw("Unable to log event: analytics library is missing");
        }
    }

    Bundle collectAnalyticsParams(String campaignName, String campaignId) {
        Bundle params = new Bundle();
        params.putString("_nmid", campaignId);
        params.putString("_nmn", campaignName);
        try {
            int epochSeconds = (int)(this.clock.now() / 1000L);
            params.putInt("_ndt", epochSeconds);
        }
        catch (NumberFormatException e) {
            Logging.logw("Error while parsing use_device_time in FIAM event: " + e.getMessage());
        }
        return params;
    }

    private boolean impressionCountsAsConversion(InAppMessage message) {
        switch (message.getMessageType()) {
            case CARD: {
                CardMessage m = (CardMessage)message;
                boolean hasNoPrimaryAction = !this.isValidAction(m.getPrimaryAction());
                boolean hasNoSecondaryAction = !this.isValidAction(m.getSecondaryAction());
                return hasNoPrimaryAction && hasNoSecondaryAction;
            }
            case MODAL: {
                return !this.isValidAction(((ModalMessage)message).getAction());
            }
            case BANNER: {
                return !this.isValidAction(((BannerMessage)message).getAction());
            }
            case IMAGE_ONLY: {
                return !this.isValidAction(((ImageOnlyMessage)message).getAction());
            }
        }
        Logging.loge("Unable to determine if impression should be counted as conversion.");
        return false;
    }

    private boolean isTestCampaign(InAppMessage message) {
        return message.getCampaignMetadata().getIsTestMessage();
    }

    private boolean isValidAction(@Nullable Action action) {
        return action != null && action.getActionUrl() != null && !action.getActionUrl().isEmpty();
    }

    static {
        errorTransform.put(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason.UNSPECIFIED_RENDER_ERROR, RenderErrorReason.UNSPECIFIED_RENDER_ERROR);
        errorTransform.put(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason.IMAGE_FETCH_ERROR, RenderErrorReason.IMAGE_FETCH_ERROR);
        errorTransform.put(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason.IMAGE_DISPLAY_ERROR, RenderErrorReason.IMAGE_DISPLAY_ERROR);
        errorTransform.put(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason.IMAGE_UNSUPPORTED_FORMAT, RenderErrorReason.IMAGE_UNSUPPORTED_FORMAT);
        dismissTransform.put(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.AUTO, DismissType.AUTO);
        dismissTransform.put(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.CLICK, DismissType.CLICK);
        dismissTransform.put(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.SWIPE, DismissType.SWIPE);
        dismissTransform.put(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.UNKNOWN_DISMISS_TYPE, DismissType.UNKNOWN_DISMISS_TYPE);
    }

    public static interface EngagementMetricsLoggerInterface {
        public void logEvent(byte[] var1);
    }
}

