/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.google.firebase.inappmessaging.MessagesProto;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.BannerMessage;
import com.google.firebase.inappmessaging.model.Button;
import com.google.firebase.inappmessaging.model.CampaignMetadata;
import com.google.firebase.inappmessaging.model.CardMessage;
import com.google.firebase.inappmessaging.model.ImageData;
import com.google.firebase.inappmessaging.model.ImageOnlyMessage;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import com.google.firebase.inappmessaging.model.ModalMessage;
import com.google.firebase.inappmessaging.model.Text;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProtoMarshallerClient {
    @Inject
    ProtoMarshallerClient() {
    }

    @NonNull
    private static ModalMessage.Builder from(MessagesProto.ModalMessage in) {
        ModalMessage.Builder builder = ModalMessage.builder();
        if (!TextUtils.isEmpty((CharSequence)in.getBackgroundHexColor())) {
            builder.setBackgroundHexColor(in.getBackgroundHexColor());
        }
        if (!TextUtils.isEmpty((CharSequence)in.getImageUrl())) {
            builder.setImageData(ImageData.builder().setImageUrl(in.getImageUrl()).build());
        }
        if (in.hasAction()) {
            builder.setAction(ProtoMarshallerClient.decode(in.getAction(), in.getActionButton()));
        }
        if (in.hasBody()) {
            builder.setBody(ProtoMarshallerClient.decode(in.getBody()));
        }
        if (in.hasTitle()) {
            builder.setTitle(ProtoMarshallerClient.decode(in.getTitle()));
        }
        return builder;
    }

    @NonNull
    private static ImageOnlyMessage.Builder from(MessagesProto.ImageOnlyMessage in) {
        ImageOnlyMessage.Builder builder = ImageOnlyMessage.builder();
        if (!TextUtils.isEmpty((CharSequence)in.getImageUrl())) {
            builder.setImageData(ImageData.builder().setImageUrl(in.getImageUrl()).build());
        }
        if (in.hasAction()) {
            builder.setAction(ProtoMarshallerClient.decode(in.getAction()).build());
        }
        return builder;
    }

    @NonNull
    private static BannerMessage.Builder from(MessagesProto.BannerMessage in) {
        BannerMessage.Builder builder = BannerMessage.builder();
        if (!TextUtils.isEmpty((CharSequence)in.getBackgroundHexColor())) {
            builder.setBackgroundHexColor(in.getBackgroundHexColor());
        }
        if (!TextUtils.isEmpty((CharSequence)in.getImageUrl())) {
            builder.setImageData(ImageData.builder().setImageUrl(in.getImageUrl()).build());
        }
        if (in.hasAction()) {
            builder.setAction(ProtoMarshallerClient.decode(in.getAction()).build());
        }
        if (in.hasBody()) {
            builder.setBody(ProtoMarshallerClient.decode(in.getBody()));
        }
        if (in.hasTitle()) {
            builder.setTitle(ProtoMarshallerClient.decode(in.getTitle()));
        }
        return builder;
    }

    @NonNull
    private static CardMessage.Builder from(MessagesProto.CardMessage in) {
        CardMessage.Builder builder = CardMessage.builder();
        if (in.hasTitle()) {
            builder.setTitle(ProtoMarshallerClient.decode(in.getTitle()));
        }
        if (in.hasBody()) {
            builder.setBody(ProtoMarshallerClient.decode(in.getBody()));
        }
        if (!TextUtils.isEmpty((CharSequence)in.getBackgroundHexColor())) {
            builder.setBackgroundHexColor(in.getBackgroundHexColor());
        }
        if (in.hasPrimaryAction() || in.hasPrimaryActionButton()) {
            builder.setPrimaryAction(ProtoMarshallerClient.decode(in.getPrimaryAction(), in.getPrimaryActionButton()));
        }
        if (in.hasSecondaryAction() || in.hasSecondaryActionButton()) {
            builder.setSecondaryAction(ProtoMarshallerClient.decode(in.getSecondaryAction(), in.getSecondaryActionButton()));
        }
        if (!TextUtils.isEmpty((CharSequence)in.getPortraitImageUrl())) {
            builder.setPortraitImageData(ImageData.builder().setImageUrl(in.getPortraitImageUrl()).build());
        }
        if (!TextUtils.isEmpty((CharSequence)in.getLandscapeImageUrl())) {
            builder.setLandscapeImageData(ImageData.builder().setImageUrl(in.getLandscapeImageUrl()).build());
        }
        return builder;
    }

    private static Button decode(MessagesProto.Button in) {
        Button.Builder builder = Button.builder();
        if (!TextUtils.isEmpty((CharSequence)in.getButtonHexColor())) {
            builder.setButtonHexColor(in.getButtonHexColor());
        }
        if (in.hasText()) {
            builder.setText(ProtoMarshallerClient.decode(in.getText()));
        }
        return builder.build();
    }

    private static Action decode(MessagesProto.Action protoAction, MessagesProto.Button protoButton) {
        Action.Builder builder = ProtoMarshallerClient.decode(protoAction);
        if (!protoButton.equals(MessagesProto.Button.getDefaultInstance())) {
            Button.Builder buttonBuilder = Button.builder();
            if (!TextUtils.isEmpty((CharSequence)protoButton.getButtonHexColor())) {
                buttonBuilder.setButtonHexColor(protoButton.getButtonHexColor());
            }
            if (protoButton.hasText()) {
                Text.Builder buttonText = Text.builder();
                MessagesProto.Text text = protoButton.getText();
                if (!TextUtils.isEmpty((CharSequence)text.getText())) {
                    buttonText.setText(text.getText());
                }
                if (!TextUtils.isEmpty((CharSequence)text.getHexColor())) {
                    buttonText.setHexColor(text.getHexColor());
                }
                buttonBuilder.setText(buttonText.build());
            }
            builder.setButton(buttonBuilder.build());
        }
        return builder.build();
    }

    private static Action.Builder decode(MessagesProto.Action protoAction) {
        Action.Builder builder = Action.builder();
        if (!TextUtils.isEmpty((CharSequence)protoAction.getActionUrl())) {
            builder.setActionUrl(protoAction.getActionUrl());
        }
        return builder;
    }

    private static Text decode(MessagesProto.Text in) {
        Text.Builder builder = Text.builder();
        if (!TextUtils.isEmpty((CharSequence)in.getHexColor())) {
            builder.setHexColor(in.getHexColor());
        }
        if (!TextUtils.isEmpty((CharSequence)in.getText())) {
            builder.setText(in.getText());
        }
        return builder.build();
    }

    public static InAppMessage decode(@NonNull MessagesProto.Content in, @NonNull String campaignId, @NonNull String campaignName, boolean isTestMessage, @Nullable Map<String, String> data) {
        Preconditions.checkNotNull((Object)in, (Object)"FirebaseInAppMessaging content cannot be null.");
        Preconditions.checkNotNull((Object)campaignId, (Object)"FirebaseInAppMessaging campaign id cannot be null.");
        Preconditions.checkNotNull((Object)campaignName, (Object)"FirebaseInAppMessaging campaign name cannot be null.");
        Logging.logd("Decoding message: " + in.toString());
        CampaignMetadata campaignMetadata = new CampaignMetadata(campaignId, campaignName, isTestMessage);
        switch (in.getMessageDetailsCase()) {
            case BANNER: {
                return ProtoMarshallerClient.from(in.getBanner()).build(campaignMetadata, data);
            }
            case IMAGE_ONLY: {
                return ProtoMarshallerClient.from(in.getImageOnly()).build(campaignMetadata, data);
            }
            case MODAL: {
                return ProtoMarshallerClient.from(in.getModal()).build(campaignMetadata, data);
            }
            case CARD: {
                return ProtoMarshallerClient.from(in.getCard()).build(campaignMetadata, data);
            }
        }
        return new InAppMessage(new CampaignMetadata(campaignId, campaignName, isTestMessage), MessageType.UNSUPPORTED, (Map)data){

            @Override
            public Action getAction() {
                return null;
            }
        };
    }
}

