/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal.injection.components;

import android.app.Application;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inappmessaging.FirebaseInAppMessaging;
import com.google.firebase.inappmessaging.FirebaseInAppMessaging_Factory;
import com.google.firebase.inappmessaging.dagger.internal.DaggerGenerated;
import com.google.firebase.inappmessaging.dagger.internal.DoubleCheck;
import com.google.firebase.inappmessaging.dagger.internal.InstanceFactory;
import com.google.firebase.inappmessaging.dagger.internal.Preconditions;
import com.google.firebase.inappmessaging.dagger.internal.Provider;
import com.google.firebase.inappmessaging.internal.AbtIntegrationHelper;
import com.google.firebase.inappmessaging.internal.AnalyticsEventsManager;
import com.google.firebase.inappmessaging.internal.ApiClient;
import com.google.firebase.inappmessaging.internal.CampaignCacheClient;
import com.google.firebase.inappmessaging.internal.DataCollectionHelper;
import com.google.firebase.inappmessaging.internal.DeveloperListenerManager;
import com.google.firebase.inappmessaging.internal.DisplayCallbacksFactory;
import com.google.firebase.inappmessaging.internal.DisplayCallbacksFactory_Factory;
import com.google.firebase.inappmessaging.internal.GrpcClient;
import com.google.firebase.inappmessaging.internal.GrpcClient_Factory;
import com.google.firebase.inappmessaging.internal.ImpressionStorageClient;
import com.google.firebase.inappmessaging.internal.InAppMessageStreamManager;
import com.google.firebase.inappmessaging.internal.InAppMessageStreamManager_Factory;
import com.google.firebase.inappmessaging.internal.MetricsLoggerClient;
import com.google.firebase.inappmessaging.internal.ProgramaticContextualTriggers;
import com.google.firebase.inappmessaging.internal.ProviderInstaller;
import com.google.firebase.inappmessaging.internal.RateLimiterClient;
import com.google.firebase.inappmessaging.internal.Schedulers;
import com.google.firebase.inappmessaging.internal.SharedPreferencesUtils;
import com.google.firebase.inappmessaging.internal.TestDeviceHelper;
import com.google.firebase.inappmessaging.internal.injection.components.AppComponent;
import com.google.firebase.inappmessaging.internal.injection.components.UniversalComponent;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesApiClientFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesDataCollectionHelperFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesFirebaseAppFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesFirebaseInstallationsFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesSharedPreferencesUtilsFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesTestDeviceHelperFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcClientModule;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcClientModule_ProvidesApiKeyHeadersFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcClientModule_ProvidesInAppMessagingSdkServingStubFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.TransportClientModule_ProvidesMetricsLoggerClientFactory;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.firebase.inappmessaging.model.RateLimit;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.InAppMessagingSdkServingGrpc;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.reactivex.flowables.ConnectableFlowable;
import java.util.concurrent.Executor;

@DaggerGenerated
public final class DaggerAppComponent {
    private DaggerAppComponent() {
    }

    public static AppComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements AppComponent.Builder {
        private AbtIntegrationHelper abtIntegrationHelper;
        private ApiClientModule apiClientModule;
        private GrpcClientModule grpcClientModule;
        private UniversalComponent universalComponent;
        private TransportFactory transportFactory;

        private Builder() {
        }

        @Override
        public Builder abtIntegrationHelper(AbtIntegrationHelper integrationHelper) {
            this.abtIntegrationHelper = Preconditions.checkNotNull(integrationHelper);
            return this;
        }

        @Override
        public Builder apiClientModule(ApiClientModule module) {
            this.apiClientModule = Preconditions.checkNotNull(module);
            return this;
        }

        @Override
        public Builder grpcClientModule(GrpcClientModule module) {
            this.grpcClientModule = Preconditions.checkNotNull(module);
            return this;
        }

        @Override
        public Builder universalComponent(UniversalComponent component) {
            this.universalComponent = Preconditions.checkNotNull(component);
            return this;
        }

        @Override
        public Builder transportFactory(TransportFactory transportFactory) {
            this.transportFactory = Preconditions.checkNotNull(transportFactory);
            return this;
        }

        @Override
        public AppComponent build() {
            Preconditions.checkBuilderRequirement(this.abtIntegrationHelper, AbtIntegrationHelper.class);
            Preconditions.checkBuilderRequirement(this.apiClientModule, ApiClientModule.class);
            Preconditions.checkBuilderRequirement(this.grpcClientModule, GrpcClientModule.class);
            Preconditions.checkBuilderRequirement(this.universalComponent, UniversalComponent.class);
            Preconditions.checkBuilderRequirement(this.transportFactory, TransportFactory.class);
            return new AppComponentImpl(this.apiClientModule, this.grpcClientModule, this.universalComponent, this.abtIntegrationHelper, this.transportFactory);
        }
    }

    private static final class AppComponentImpl
    implements AppComponent {
        private final UniversalComponent universalComponent;
        private final ApiClientModule apiClientModule;
        private final AppComponentImpl appComponentImpl = this;
        private Provider<ConnectableFlowable<String>> appForegroundEventFlowableProvider;
        private Provider<ConnectableFlowable<String>> programmaticContextualTriggerFlowableProvider;
        private Provider<CampaignCacheClient> campaignCacheClientProvider;
        private Provider<Clock> clockProvider;
        private Provider<Channel> gRPCChannelProvider;
        private Provider<Metadata> providesApiKeyHeadersProvider;
        private Provider<InAppMessagingSdkServingGrpc.InAppMessagingSdkServingBlockingStub> providesInAppMessagingSdkServingStubProvider;
        private Provider<GrpcClient> grpcClientProvider;
        private Provider<Application> applicationProvider;
        private Provider<ProviderInstaller> providerInstallerProvider;
        private Provider<ApiClient> providesApiClientProvider;
        private Provider<AnalyticsEventsManager> analyticsEventsManagerProvider;
        private Provider<Schedulers> schedulersProvider;
        private Provider<ImpressionStorageClient> impressionStorageClientProvider;
        private Provider<RateLimiterClient> rateLimiterClientProvider;
        private Provider<RateLimit> appForegroundRateLimitProvider;
        private Provider<SharedPreferencesUtils> providesSharedPreferencesUtilsProvider;
        private Provider<TestDeviceHelper> providesTestDeviceHelperProvider;
        private Provider<FirebaseInstallationsApi> providesFirebaseInstallationsProvider;
        private Provider<Subscriber> firebaseEventsSubscriberProvider;
        private Provider<DataCollectionHelper> providesDataCollectionHelperProvider;
        private Provider<AbtIntegrationHelper> abtIntegrationHelperProvider;
        private Provider<Executor> blockingExecutorProvider;
        private Provider<InAppMessageStreamManager> inAppMessageStreamManagerProvider;
        private Provider<ProgramaticContextualTriggers> programmaticContextualTriggersProvider;
        private Provider<FirebaseApp> providesFirebaseAppProvider;
        private Provider<TransportFactory> transportFactoryProvider;
        private Provider<AnalyticsConnector> analyticsConnectorProvider;
        private Provider<DeveloperListenerManager> developerListenerManagerProvider;
        private Provider<MetricsLoggerClient> providesMetricsLoggerClientProvider;
        private Provider<DisplayCallbacksFactory> displayCallbacksFactoryProvider;
        private Provider<Executor> lightWeightExecutorProvider;
        private Provider<FirebaseInAppMessaging> firebaseInAppMessagingProvider;

        private AppComponentImpl(ApiClientModule apiClientModuleParam, GrpcClientModule grpcClientModuleParam, UniversalComponent universalComponentParam, AbtIntegrationHelper abtIntegrationHelperParam, TransportFactory transportFactoryParam) {
            this.universalComponent = universalComponentParam;
            this.apiClientModule = apiClientModuleParam;
            this.initialize(apiClientModuleParam, grpcClientModuleParam, universalComponentParam, abtIntegrationHelperParam, transportFactoryParam);
        }

        private DataCollectionHelper dataCollectionHelper() {
            return ApiClientModule_ProvidesDataCollectionHelperFactory.providesDataCollectionHelper(this.apiClientModule, ApiClientModule_ProvidesSharedPreferencesUtilsFactory.providesSharedPreferencesUtils(this.apiClientModule), Preconditions.checkNotNullFromComponent(this.universalComponent.firebaseEventsSubscriber()));
        }

        private void initialize(ApiClientModule apiClientModuleParam, GrpcClientModule grpcClientModuleParam, UniversalComponent universalComponentParam, AbtIntegrationHelper abtIntegrationHelperParam, TransportFactory transportFactoryParam) {
            this.appForegroundEventFlowableProvider = new AppForegroundEventFlowableProvider(universalComponentParam);
            this.programmaticContextualTriggerFlowableProvider = new ProgrammaticContextualTriggerFlowableProvider(universalComponentParam);
            this.campaignCacheClientProvider = new CampaignCacheClientProvider(universalComponentParam);
            this.clockProvider = new ClockProvider(universalComponentParam);
            this.gRPCChannelProvider = new GRPCChannelProvider(universalComponentParam);
            this.providesApiKeyHeadersProvider = GrpcClientModule_ProvidesApiKeyHeadersFactory.create(grpcClientModuleParam);
            this.providesInAppMessagingSdkServingStubProvider = DoubleCheck.provider(GrpcClientModule_ProvidesInAppMessagingSdkServingStubFactory.create(grpcClientModuleParam, this.gRPCChannelProvider, this.providesApiKeyHeadersProvider));
            this.grpcClientProvider = DoubleCheck.provider(GrpcClient_Factory.create(this.providesInAppMessagingSdkServingStubProvider));
            this.applicationProvider = new ApplicationProvider(universalComponentParam);
            this.providerInstallerProvider = new ProviderInstallerProvider(universalComponentParam);
            this.providesApiClientProvider = DoubleCheck.provider(ApiClientModule_ProvidesApiClientFactory.create(apiClientModuleParam, this.grpcClientProvider, this.applicationProvider, this.providerInstallerProvider));
            this.analyticsEventsManagerProvider = new AnalyticsEventsManagerProvider(universalComponentParam);
            this.schedulersProvider = new SchedulersProvider(universalComponentParam);
            this.impressionStorageClientProvider = new ImpressionStorageClientProvider(universalComponentParam);
            this.rateLimiterClientProvider = new RateLimiterClientProvider(universalComponentParam);
            this.appForegroundRateLimitProvider = new AppForegroundRateLimitProvider(universalComponentParam);
            this.providesSharedPreferencesUtilsProvider = ApiClientModule_ProvidesSharedPreferencesUtilsFactory.create(apiClientModuleParam);
            this.providesTestDeviceHelperProvider = ApiClientModule_ProvidesTestDeviceHelperFactory.create(apiClientModuleParam, this.providesSharedPreferencesUtilsProvider);
            this.providesFirebaseInstallationsProvider = ApiClientModule_ProvidesFirebaseInstallationsFactory.create(apiClientModuleParam);
            this.firebaseEventsSubscriberProvider = new FirebaseEventsSubscriberProvider(universalComponentParam);
            this.providesDataCollectionHelperProvider = ApiClientModule_ProvidesDataCollectionHelperFactory.create(apiClientModuleParam, this.providesSharedPreferencesUtilsProvider, this.firebaseEventsSubscriberProvider);
            this.abtIntegrationHelperProvider = InstanceFactory.create(abtIntegrationHelperParam);
            this.blockingExecutorProvider = new BlockingExecutorProvider(universalComponentParam);
            this.inAppMessageStreamManagerProvider = DoubleCheck.provider(InAppMessageStreamManager_Factory.create(this.appForegroundEventFlowableProvider, this.programmaticContextualTriggerFlowableProvider, this.campaignCacheClientProvider, this.clockProvider, this.providesApiClientProvider, this.analyticsEventsManagerProvider, this.schedulersProvider, this.impressionStorageClientProvider, this.rateLimiterClientProvider, this.appForegroundRateLimitProvider, this.providesTestDeviceHelperProvider, this.providesFirebaseInstallationsProvider, this.providesDataCollectionHelperProvider, this.abtIntegrationHelperProvider, this.blockingExecutorProvider));
            this.programmaticContextualTriggersProvider = new ProgrammaticContextualTriggersProvider(universalComponentParam);
            this.providesFirebaseAppProvider = ApiClientModule_ProvidesFirebaseAppFactory.create(apiClientModuleParam);
            this.transportFactoryProvider = InstanceFactory.create(transportFactoryParam);
            this.analyticsConnectorProvider = new AnalyticsConnectorProvider(universalComponentParam);
            this.developerListenerManagerProvider = new DeveloperListenerManagerProvider(universalComponentParam);
            this.providesMetricsLoggerClientProvider = DoubleCheck.provider(TransportClientModule_ProvidesMetricsLoggerClientFactory.create(this.providesFirebaseAppProvider, this.transportFactoryProvider, this.analyticsConnectorProvider, this.providesFirebaseInstallationsProvider, this.clockProvider, this.developerListenerManagerProvider, this.blockingExecutorProvider));
            this.displayCallbacksFactoryProvider = DisplayCallbacksFactory_Factory.create(this.impressionStorageClientProvider, this.clockProvider, this.schedulersProvider, this.rateLimiterClientProvider, this.campaignCacheClientProvider, this.appForegroundRateLimitProvider, this.providesMetricsLoggerClientProvider, this.providesDataCollectionHelperProvider);
            this.lightWeightExecutorProvider = new LightWeightExecutorProvider(universalComponentParam);
            this.firebaseInAppMessagingProvider = DoubleCheck.provider(FirebaseInAppMessaging_Factory.create(this.inAppMessageStreamManagerProvider, this.programmaticContextualTriggersProvider, this.providesDataCollectionHelperProvider, this.providesFirebaseInstallationsProvider, this.displayCallbacksFactoryProvider, this.developerListenerManagerProvider, this.lightWeightExecutorProvider));
        }

        @Override
        public FirebaseInAppMessaging providesFirebaseInAppMessaging() {
            return (FirebaseInAppMessaging)this.firebaseInAppMessagingProvider.get();
        }

        @Override
        public DisplayCallbacksFactory displayCallbacksFactory() {
            return new DisplayCallbacksFactory(Preconditions.checkNotNullFromComponent(this.universalComponent.impressionStorageClient()), Preconditions.checkNotNullFromComponent(this.universalComponent.clock()), Preconditions.checkNotNullFromComponent(this.universalComponent.schedulers()), Preconditions.checkNotNullFromComponent(this.universalComponent.rateLimiterClient()), Preconditions.checkNotNullFromComponent(this.universalComponent.campaignCacheClient()), Preconditions.checkNotNullFromComponent(this.universalComponent.appForegroundRateLimit()), (MetricsLoggerClient)this.providesMetricsLoggerClientProvider.get(), this.dataCollectionHelper());
        }

        private static final class AppForegroundEventFlowableProvider
        implements Provider<ConnectableFlowable<String>> {
            private final UniversalComponent universalComponent;

            AppForegroundEventFlowableProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public ConnectableFlowable<String> get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.appForegroundEventFlowable());
            }
        }

        private static final class ProgrammaticContextualTriggerFlowableProvider
        implements Provider<ConnectableFlowable<String>> {
            private final UniversalComponent universalComponent;

            ProgrammaticContextualTriggerFlowableProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public ConnectableFlowable<String> get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.programmaticContextualTriggerFlowable());
            }
        }

        private static final class CampaignCacheClientProvider
        implements Provider<CampaignCacheClient> {
            private final UniversalComponent universalComponent;

            CampaignCacheClientProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public CampaignCacheClient get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.campaignCacheClient());
            }
        }

        private static final class ClockProvider
        implements Provider<Clock> {
            private final UniversalComponent universalComponent;

            ClockProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public Clock get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.clock());
            }
        }

        private static final class GRPCChannelProvider
        implements Provider<Channel> {
            private final UniversalComponent universalComponent;

            GRPCChannelProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public Channel get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.gRPCChannel());
            }
        }

        private static final class ApplicationProvider
        implements Provider<Application> {
            private final UniversalComponent universalComponent;

            ApplicationProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public Application get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.application());
            }
        }

        private static final class ProviderInstallerProvider
        implements Provider<ProviderInstaller> {
            private final UniversalComponent universalComponent;

            ProviderInstallerProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public ProviderInstaller get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.providerInstaller());
            }
        }

        private static final class AnalyticsEventsManagerProvider
        implements Provider<AnalyticsEventsManager> {
            private final UniversalComponent universalComponent;

            AnalyticsEventsManagerProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public AnalyticsEventsManager get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.analyticsEventsManager());
            }
        }

        private static final class SchedulersProvider
        implements Provider<Schedulers> {
            private final UniversalComponent universalComponent;

            SchedulersProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public Schedulers get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.schedulers());
            }
        }

        private static final class ImpressionStorageClientProvider
        implements Provider<ImpressionStorageClient> {
            private final UniversalComponent universalComponent;

            ImpressionStorageClientProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public ImpressionStorageClient get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.impressionStorageClient());
            }
        }

        private static final class RateLimiterClientProvider
        implements Provider<RateLimiterClient> {
            private final UniversalComponent universalComponent;

            RateLimiterClientProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public RateLimiterClient get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.rateLimiterClient());
            }
        }

        private static final class AppForegroundRateLimitProvider
        implements Provider<RateLimit> {
            private final UniversalComponent universalComponent;

            AppForegroundRateLimitProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public RateLimit get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.appForegroundRateLimit());
            }
        }

        private static final class FirebaseEventsSubscriberProvider
        implements Provider<Subscriber> {
            private final UniversalComponent universalComponent;

            FirebaseEventsSubscriberProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public Subscriber get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.firebaseEventsSubscriber());
            }
        }

        private static final class BlockingExecutorProvider
        implements Provider<Executor> {
            private final UniversalComponent universalComponent;

            BlockingExecutorProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public Executor get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.blockingExecutor());
            }
        }

        private static final class ProgrammaticContextualTriggersProvider
        implements Provider<ProgramaticContextualTriggers> {
            private final UniversalComponent universalComponent;

            ProgrammaticContextualTriggersProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public ProgramaticContextualTriggers get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.programmaticContextualTriggers());
            }
        }

        private static final class AnalyticsConnectorProvider
        implements Provider<AnalyticsConnector> {
            private final UniversalComponent universalComponent;

            AnalyticsConnectorProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public AnalyticsConnector get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.analyticsConnector());
            }
        }

        private static final class DeveloperListenerManagerProvider
        implements Provider<DeveloperListenerManager> {
            private final UniversalComponent universalComponent;

            DeveloperListenerManagerProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public DeveloperListenerManager get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.developerListenerManager());
            }
        }

        private static final class LightWeightExecutorProvider
        implements Provider<Executor> {
            private final UniversalComponent universalComponent;

            LightWeightExecutorProvider(UniversalComponent universalComponent) {
                this.universalComponent = universalComponent;
            }

            public Executor get() {
                return Preconditions.checkNotNullFromComponent(this.universalComponent.lightWeightExecutor());
            }
        }
    }
}

