/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.Constants;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirelogAnalyticsEvent;
import com.google.firebase.messaging.MessagingAnalytics$$Lambda$0;
import com.google.firebase.messaging.NotificationParams;

public class MessagingAnalytics {
    private static final DataEncoder dataEncoder = new JsonDataEncoderBuilder().registerEncoder(FirelogAnalyticsEvent.FirelogAnalyticsEventWrapper.class, (ObjectEncoder)new FirelogAnalyticsEvent.FirelogAnalyticsEventWrapperEncoder()).registerEncoder(FirelogAnalyticsEvent.class, (ObjectEncoder)new FirelogAnalyticsEvent.FirelogAnalyticsEventEncoder()).build();

    public static void logNotificationReceived(Intent intent) {
        if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
            MessagingAnalytics.logToScion("_nr", intent);
        }
        if (MessagingAnalytics.shouldUploadFirelogAnalytics(intent)) {
            TransportFactory transportFactory = FirebaseMessaging.getTransportFactory();
            if (transportFactory != null) {
                Transport transport = transportFactory.getTransport("FCM_CLIENT_EVENT_LOGGING", String.class, Encoding.of((String)"json"), MessagingAnalytics$$Lambda$0.$instance);
                MessagingAnalytics.logToFirelog("MESSAGE_DELIVERED", intent, (Transport<String>)transport);
                return;
            }
            Log.e((String)"FirebaseMessaging", (String)"TransportFactory is null. Skip exporting message delivery metrics to Big Query");
        }
    }

    public static void logNotificationOpen(Intent intent) {
        MessagingAnalytics.setUserPropertyIfRequired(intent);
        MessagingAnalytics.logToScion("_no", intent);
    }

    public static void logNotificationDismiss(Intent intent) {
        MessagingAnalytics.logToScion("_nd", intent);
    }

    public static void logNotificationForeground(Intent intent) {
        MessagingAnalytics.logToScion("_nf", intent);
    }

    public static boolean shouldUploadScionMetrics(Intent intent) {
        if (intent == null || MessagingAnalytics.isDirectBootMessage(intent)) {
            return false;
        }
        return "1".equals(intent.getStringExtra("google.c.a.e"));
    }

    public static boolean shouldUploadFirelogAnalytics(Intent intent) {
        if (intent == null || MessagingAnalytics.isDirectBootMessage(intent)) {
            return false;
        }
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    private static boolean isDirectBootMessage(Intent intent) {
        return "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(intent.getAction());
    }

    static boolean deliveryMetricsExportToBigQueryEnabled() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            Log.i((String)"FirebaseMessaging", (String)"FirebaseApp has not being initialized. Device might be in direct boot mode. Skip exporting delivery metrics to Big Query");
            return false;
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("export_to_big_query")) {
            return sharedPreferences.getBoolean("export_to_big_query", false);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("delivery_metrics_exported_to_big_query_enabled")) {
                return applicationInfo.metaData.getBoolean("delivery_metrics_exported_to_big_query_enabled", false);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    private static void setUserPropertyIfRequired(Intent intent) {
        if (intent == null) {
            return;
        }
        String string = intent.getStringExtra("google.c.a.tc");
        if ("1".equals(string)) {
            AnalyticsConnector analyticsConnector = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class);
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=true. Setting user property and reengagement event");
            }
            if (analyticsConnector != null) {
                String string2 = intent.getStringExtra("google.c.a.c_id");
                analyticsConnector.setUserProperty("fcm", "_ln", (Object)string2);
                Bundle bundle = new Bundle();
                bundle.putString("source", "Firebase");
                bundle.putString("medium", "notification");
                bundle.putString("campaign", string2);
                analyticsConnector.logEvent("fcm", "_cmp", bundle);
                return;
            }
            Log.w((String)"FirebaseMessaging", (String)"Unable to set user property for conversion tracking:  analytics library is missing");
            return;
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=false. Do not set user property");
        }
    }

    @VisibleForTesting
    static void logToScion(String string, Intent intent) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        Bundle bundle = new Bundle();
        String string9 = MessagingAnalytics.getComposerId(intent);
        if (string9 != null) {
            bundle.putString("_nmid", string9);
        }
        if ((string8 = MessagingAnalytics.getComposerLabel(intent)) != null) {
            bundle.putString("_nmn", string8);
        }
        if (!TextUtils.isEmpty((CharSequence)(string7 = MessagingAnalytics.getMessageLabel(intent)))) {
            bundle.putString("label", string7);
        }
        if (!TextUtils.isEmpty((CharSequence)(string6 = MessagingAnalytics.getMessageChannel(intent)))) {
            bundle.putString("message_channel", string6);
        }
        if ((string5 = MessagingAnalytics.getTopic(intent)) != null) {
            bundle.putString("_nt", string5);
        }
        if ((string4 = MessagingAnalytics.getMessageTime(intent)) != null) {
            try {
                bundle.putInt("_nmt", Integer.parseInt(string4));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing timestamp in GCM event", (Throwable)numberFormatException);
            }
        }
        if ((string3 = MessagingAnalytics.getUseDeviceTime(intent)) != null) {
            try {
                bundle.putInt("_ndt", Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing use_device_time in GCM event", (Throwable)numberFormatException);
            }
        }
        String string10 = MessagingAnalytics.getMessageTypeForScion(intent);
        if ("_nr".equals(string) || "_nf".equals(string)) {
            bundle.putString("_nmc", string10);
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            string2 = String.valueOf(bundle);
            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Logging to scion event=").append(string).append(" scionPayload=").append(string2).toString());
        }
        if ((string2 = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class)) != null) {
            string2.logEvent("fcm", string, bundle);
            return;
        }
        Log.w((String)"FirebaseMessaging", (String)"Unable to log event: analytics library is missing");
    }

    private static void logToFirelog(@Constants.FirelogAnalytics.EventType String string, Intent intent, Transport<String> transport) {
        FirelogAnalyticsEvent firelogAnalyticsEvent = new FirelogAnalyticsEvent(string, intent);
        FirelogAnalyticsEvent.FirelogAnalyticsEventWrapper firelogAnalyticsEventWrapper = new FirelogAnalyticsEvent.FirelogAnalyticsEventWrapper(firelogAnalyticsEvent);
        try {
            transport.send(Event.ofTelemetry((Object)dataEncoder.encode((Object)firelogAnalyticsEventWrapper)));
            return;
        }
        catch (EncodingException encodingException) {
            Log.d((String)"FirebaseMessaging", (String)"Failed to encode big query analytics payload. Skip sending");
            return;
        }
    }

    static void setDeliveryMetricsExportToBigQuery(boolean bl) {
        FirebaseApp.getInstance().getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit().putBoolean("export_to_big_query", bl).apply();
    }

    @NonNull
    static int getTtl(Intent intent) {
        Object object = intent.getExtras().get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    @Nullable
    static String getCollapseKey(Intent intent) {
        return intent.getStringExtra("collapse_key");
    }

    @Nullable
    static String getComposerId(Intent intent) {
        return intent.getStringExtra("google.c.a.c_id");
    }

    @Nullable
    static String getComposerLabel(Intent intent) {
        return intent.getStringExtra("google.c.a.c_l");
    }

    @Nullable
    static String getMessageLabel(Intent intent) {
        return intent.getStringExtra("google.c.a.m_l");
    }

    @Nullable
    static String getMessageChannel(Intent intent) {
        return intent.getStringExtra("google.c.a.m_c");
    }

    @Nullable
    static String getMessageTime(Intent intent) {
        return intent.getStringExtra("google.c.a.ts");
    }

    @Nullable
    static String getMessageId(Intent intent) {
        String string = intent.getStringExtra("google.message_id");
        if (string == null) {
            string = intent.getStringExtra("message_id");
        }
        return string;
    }

    @NonNull
    static String getPackageName() {
        return FirebaseApp.getInstance().getApplicationContext().getPackageName();
    }

    @NonNull
    static String getInstanceId() {
        return FirebaseInstanceId.getInstance((FirebaseApp)FirebaseApp.getInstance()).getId();
    }

    @NonNull
    static String getMessageTypeForScion(Intent intent) {
        if (intent.getExtras() != null && NotificationParams.isNotification(intent.getExtras())) {
            return "display";
        }
        return "data";
    }

    @NonNull
    @Constants.FirelogAnalytics.MessageType
    static String getMessageTypeForFirelog(Intent intent) {
        if (intent.getExtras() != null && NotificationParams.isNotification(intent.getExtras())) {
            return "DISPLAY_NOTIFICATION";
        }
        return "DATA_MESSAGE";
    }

    @Nullable
    static String getTopic(Intent intent) {
        String string = intent.getStringExtra("from");
        if (string != null && string.startsWith("/topics/")) {
            return string;
        }
        return null;
    }

    @Nullable
    static String getUseDeviceTime(Intent intent) {
        if (intent.hasExtra("google.c.a.udt")) {
            return intent.getStringExtra("google.c.a.udt");
        }
        return null;
    }

    @NonNull
    static int getPriority(Intent intent) {
        String string = intent.getStringExtra("google.delivered_priority");
        if (string == null) {
            if ("1".equals(intent.getStringExtra("google.priority_reduced"))) {
                return 2;
            }
            string = intent.getStringExtra("google.priority");
        }
        return MessagingAnalytics.getMessagePriority(string);
    }

    @NonNull
    private static int getMessagePriority(String string) {
        if ("high".equals(string)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    static String getProjectNumber() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        String string = firebaseApp.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = firebaseApp.getOptions().getApplicationId();
        if (!string2.startsWith("1:")) {
            return string2;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        String string3 = stringArray[1];
        if (string3.isEmpty()) {
            return null;
        }
        return string3;
    }
}

