/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml_naturallanguage;

import com.google.android.gms.internal.firebase_ml_naturallanguage.zzfb;
import com.google.android.gms.internal.firebase_ml_naturallanguage.zzgj;
import com.google.android.gms.internal.firebase_ml_naturallanguage.zzgp;
import com.google.android.gms.internal.firebase_ml_naturallanguage.zzib;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhc
extends zzfb<Long>
implements zzgp<Long>,
zzib,
RandomAccess {
    private static final zzhc zzafc = new zzhc(new long[0], 0);
    private long[] zzafd;
    private int size;

    zzhc() {
        this(new long[10], 0);
    }

    private zzhc(long[] lArray, int n) {
        this.zzafd = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzei();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzafd, n2, this.zzafd, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhc)) {
            return super.equals(object);
        }
        zzhc zzhc2 = (zzhc)object;
        if (this.size != zzhc2.size) {
            return false;
        }
        long[] lArray = zzhc2.zzafd;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzafd[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzgj.zzn(this.zzafd[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzab(n);
        return this.zzafd[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzei();
        zzgj.checkNotNull(collection);
        if (!(collection instanceof zzhc)) {
            return super.addAll(collection);
        }
        zzhc zzhc2 = (zzhc)collection;
        if (zzhc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhc2.size;
        if (n > this.zzafd.length) {
            this.zzafd = Arrays.copyOf(this.zzafd, n);
        }
        System.arraycopy(zzhc2.zzafd, 0, this.zzafd, this.size, zzhc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzei();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzafd[i])) continue;
            System.arraycopy(this.zzafd, i + 1, this.zzafd, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzab(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzac(n));
        }
    }

    private final String zzac(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhc zzhc2 = this;
        zzhc2.zzei();
        zzhc2.zzab(n);
        long l3 = zzhc2.zzafd[n];
        zzhc2.zzafd[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhc zzhc2 = this;
        zzhc2.zzei();
        zzhc2.zzab(n);
        long l = zzhc2.zzafd[n];
        if (n < zzhc2.size - 1) {
            System.arraycopy(zzhc2.zzafd, n + 1, zzhc2.zzafd, n, zzhc2.size - n - 1);
        }
        --zzhc2.size;
        ++zzhc2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhc zzhc2 = this;
        zzhc2.zzei();
        if (n < 0 || n > zzhc2.size) {
            throw new IndexOutOfBoundsException(zzhc2.zzac(n));
        }
        if (zzhc2.size < zzhc2.zzafd.length) {
            System.arraycopy(zzhc2.zzafd, n, zzhc2.zzafd, n + 1, zzhc2.size - n);
        } else {
            long[] lArray = new long[zzhc2.size * 3 / 2 + 1];
            System.arraycopy(zzhc2.zzafd, 0, lArray, 0, n);
            System.arraycopy(zzhc2.zzafd, n, lArray, n + 1, zzhc2.size - n);
            zzhc2.zzafd = lArray;
        }
        zzhc2.zzafd[n] = l2;
        ++zzhc2.size;
        ++zzhc2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhc zzhc2 = this;
        zzhc2.zzei();
        if (zzhc2.size == zzhc2.zzafd.length) {
            long[] lArray = new long[zzhc2.size * 3 / 2 + 1];
            System.arraycopy(zzhc2.zzafd, 0, lArray, 0, zzhc2.size);
            zzhc2.zzafd = lArray;
        }
        zzhc2.zzafd[zzhc2.size++] = l2;
        return true;
    }

    @Override
    public final /* synthetic */ zzgp zzad(int n) {
        int n2 = n;
        zzhc zzhc2 = this;
        if (n2 < zzhc2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhc(Arrays.copyOf(zzhc2.zzafd, n2), zzhc2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzafc.zzeh();
    }
}

